/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp.api;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.log4j.Appender;
import org.apache.log4j.helpers.NullEnumeration;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;
import org.snmp4j.util.EnumerationIterator;

public class LegoLog4jLogAdapter
implements LogAdapter,
Comparable {
    private static final long LOG_CODE = 0L;
    private Log logger = LogFactory.getInstance(LegoLog4jLogAdapter.class, "lego_snmp");
    private String thisClassName = LegoLog4jLogAdapter.class.getName();

    public LegoLog4jLogAdapter() {
        this.logger.setShowLocSrc(true);
    }

    public void debug(Serializable message) {
        String stackStr = this.getStackMsg(Thread.currentThread().getStackTrace());
        this.logger.debug((Object)(message + stackStr), 0L);
    }

    public void error(Serializable message) {
        String stackStr = this.getStackMsg(Thread.currentThread().getStackTrace());
        this.logger.error((Object)(message + stackStr), 0L);
    }

    public void error(CharSequence message, Throwable throwable) {
        String stackStr = this.getStackMsg(Thread.currentThread().getStackTrace());
        this.logger.error((Object)(message + stackStr), throwable, 0L);
    }

    public void info(CharSequence message) {
        String stackStr = this.getStackMsg(Thread.currentThread().getStackTrace());
        this.logger.info((Object)(message + stackStr), 0L);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(Serializable message) {
        String stackStr = this.getStackMsg(Thread.currentThread().getStackTrace());
        this.logger.warn((Object)(message + stackStr), 0L);
    }

    public void fatal(Object message) {
        String stackStr = this.getStackMsg(Thread.currentThread().getStackTrace());
        this.logger.fatal((Object)(message + stackStr), 0L);
    }

    public void fatal(CharSequence message, Throwable throwable) {
        String stackStr = this.getStackMsg(Thread.currentThread().getStackTrace());
        this.logger.fatal((Object)(message + stackStr), throwable, 0L);
    }

    public void setLogLevel(LogLevel level) {
        this.fatal("set level:" + level);
    }

    public Log getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.logger.toString();
    }

    public LogLevel getLogLevel() {
        return LogLevel.DEBUG;
    }

    private String getStackMsg(StackTraceElement[] ste) {
        if (ste == null) {
            return "[]";
        }
        boolean srcFlag = false;
        for (int i = 0; i < ste.length; ++i) {
            StackTraceElement s = ste[i];
            if (srcFlag) {
                return s == null ? "" : new StringBuffer().append("[").append(s.getClassName()).append("][").append(s.getMethodName()).append(",").append(s.getLineNumber()).append("]").toString();
            }
            if (null == s || !this.thisClassName.equals(s.getClassName())) continue;
            srcFlag = true;
        }
        return null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((LegoLog4jLogAdapter)o).getName());
    }

    public LogLevel getEffectiveLogLevel() {
        return LogLevel.DEBUG;
    }

    public Iterator<Appender> getLogHandler() {
        return new EnumerationIterator((Enumeration)NullEnumeration.getInstance());
    }
}

