/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp.api;

import com.huawei.lego.com.south.sdk.model.LegoSnmpOID;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.sdk.model.SnmpV1Param;
import com.huawei.lego.com.south.snmp.abs.ISnmp4jAPI;
import com.huawei.lego.com.south.snmp.abs.ISnmpResponse;
import com.huawei.lego.com.south.snmp.abs.ISnmpTableResponse;
import com.huawei.lego.com.south.snmp.abs.Property;
import com.huawei.lego.com.south.snmp.abs.SnmpProtocolParam;
import com.huawei.lego.com.south.snmp.abs.VBPro;
import com.huawei.lego.com.south.snmp.api.LegoLogFactoryForSnmp4j;
import com.huawei.lego.com.south.snmp.api.LegoUdpTransportMappingCreator;
import com.huawei.lego.com.south.snmp.api.Snmp4jTarget;
import com.huawei.lego.com.south.snmp.api.SnmpResponse;
import com.huawei.lego.com.south.snmp.api.TableResponse;
import com.huawei.lego.com.south.snmp.api.TextTableListener;
import com.huawei.lego.com.south.snmp.exception.SnmpException;
import com.huawei.lego.com.south.snmp.util.SnmpUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.security.UsmUserTable;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;

public class Snmp4jAPIImpl
implements ISnmp4jAPI {
    private static final String LOCAL_ENGINID_COM_HW_IC_TRAP = "com.hw.ic.north.trap";
    private static final int ENGINEBOOTS_500 = 500;
    private static final int VALUE_10 = 10;
    private static final int VALUE_1000 = 1000;
    private static final int VALUE_2 = 2;
    private static final int VALUE_5000 = 5000;
    private Log log = LogFactory.getInstance(Snmp4jAPIImpl.class);
    private Snmp snmpCommunicater;
    private Snmp4jTarget snmp4jTarget = new Snmp4jTarget();
    private Log logger = LogFactory.getInstance(this);

    @Override
    public void open(String host, int rport, String[] userContextEngineId, SnmpProtocolParam proParam) {
        this.initSnmp4jTarget(host, rport, userContextEngineId, proParam);
        try {
            this.initv3();
            this.snmp4jTarget.setConnected(true);
        }
        catch (Exception ex) {
            this.log.error((Object)("Snmp open failed" + ExceptionUtil.getErrorMessage(ex)), 0L);
            this.snmp4jTarget.setConnected(false);
        }
    }

    public void initSnmp4jTarget(String host, int rport, String[] userContextEngineId, SnmpProtocolParam proParam) {
        if (userContextEngineId.length < 3) {
            throw new IllegalArgumentException("invalid userContextEngineId length: " + userContextEngineId.length + " expected 3.");
        }
        int authPtl = proParam.getAuthProtocol();
        String authPras = proParam.getAuthPasshrase();
        int privPtl = proParam.getPrivProtocol();
        String privPras = proParam.getPrivPassphrase();
        if (this.snmp4jTarget.isConnected()) {
            this.log.warn((Object)"Snmp4J already opened.", 0L);
            return;
        }
        String user = userContextEngineId[0];
        String rcontext = userContextEngineId[1];
        String engineid = userContextEngineId[2];
        if (user == null) {
            throw new IllegalArgumentException("Parameter user cannot be null.");
        }
        this.snmp4jTarget.setHost(host);
        this.snmp4jTarget.setPort(rport);
        this.snmp4jTarget.setSecurityName(new OctetString(user));
        this.snmp4jTarget.setContext(rcontext == null ? null : new OctetString(rcontext));
        this.snmp4jTarget.setEngineId(engineid == null ? null : new OctetString(engineid));
        this.snmp4jTarget.setAuthPassphrase(authPras == null ? null : new OctetString(authPras));
        this.snmp4jTarget.setPrivPassphrase(privPras == null ? null : new OctetString(privPras));
        this.snmp4jTarget.setAuthProtocol(SnmpUtil.getAuthProtocol(SnmpEnum.AuthProtocol.getAuthProtocol(authPtl)));
        this.snmp4jTarget.setPrivProtocol(SnmpUtil.getPrivProtocol(SnmpEnum.PrivProtocol.getPrivProtocol(privPtl)));
        this.snmp4jTarget.setVersion(SnmpEnum.SnmpVersion.VERSION3.getValue());
        this.snmp4jTarget.setSendTarget((Target)new UserTarget());
        this.snmp4jTarget.getSendTarget().setVersion(3);
        ((UserTarget)this.snmp4jTarget.getSendTarget()).setSecurityName(this.snmp4jTarget.getSecurityName());
        Address targetAddress = GenericAddress.parse((String)("udp:" + this.snmp4jTarget.getHost() + "/" + this.snmp4jTarget.getPort()));
        ((UserTarget)this.snmp4jTarget.getSendTarget()).setSecurityLevel(this.snmp4jTarget.getAuthProtocol() == null ? 1 : (this.snmp4jTarget.getPrivProtocol() == null ? 2 : 3));
        this.snmp4jTarget.getSendTarget().setAddress(targetAddress);
        this.snmpCommunicater = null;
    }

    public void releaseResources() {
        if (this.snmpCommunicater != null) {
            try {
                this.snmpCommunicater.close();
                this.snmp4jTarget.setConnected(false);
                CommonUtil.sleep(1000L);
            }
            catch (Exception e) {
                this.log.error((Object)("Snmp close failed" + ExceptionUtil.getErrorMessage(e)), 0L);
            }
        }
    }

    private void initv3() throws IOException {
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        this.snmpCommunicater = new Snmp((TransportMapping)transport);
        this.snmpCommunicater.listen();
        this.snmpCommunicater.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
        this.snmpCommunicater.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        this.snmpCommunicater.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv3());
        Address targetAddress = GenericAddress.parse((String)("udp:" + this.snmp4jTarget.getHost() + "/" + this.snmp4jTarget.getPort()));
        this.snmp4jTarget.setSendTarget((Target)new UserTarget());
        this.snmp4jTarget.getSendTarget().setVersion(3);
        ((UserTarget)this.snmp4jTarget.getSendTarget()).setSecurityLevel(this.snmp4jTarget.getAuthProtocol() == null ? 1 : (this.snmp4jTarget.getPrivProtocol() == null ? 2 : 3));
        this.snmp4jTarget.getSendTarget().setAddress(targetAddress);
        SnmpUtil.getUsm();
        byte[] authoritativeengineID = this.snmpCommunicater.discoverAuthoritativeEngineID(this.snmp4jTarget.getSendTarget().getAddress(), (long)this.snmp4jTarget.getTimeout());
        if (null == authoritativeengineID || authoritativeengineID.length <= 0) {
            throw new SnmpException("init V3 error! discoverAuthoritativeEngineID faild!");
        }
        this.snmp4jTarget.setEngineId(new OctetString(authoritativeengineID));
        SecurityProtocols secProtocols = SecurityProtocols.getInstance();
        OctetString authPassphrase = new OctetString(this.snmp4jTarget.getAuthPassphrase());
        byte[] authKey = null;
        authKey = this.initv3Helper(secProtocols, this.snmp4jTarget.getAuthProtocol(), authPassphrase, authoritativeengineID);
        OctetString privPassphrase = new OctetString(this.snmp4jTarget.getPrivPassphrase());
        byte[] privKey = null;
        privKey = this.initv3Helper(secProtocols, this.snmp4jTarget.getPrivProtocol(), privPassphrase, authoritativeengineID);
        if (!VerifyUtil.isEmpty(this.snmpCommunicater.getUSM())) {
            this.snmpCommunicater.getUSM().addLocalizedUser(authoritativeengineID, this.snmp4jTarget.getSecurityName(), this.snmp4jTarget.getAuthProtocol(), authKey, this.snmp4jTarget.getPrivProtocol(), privKey);
            if (!this.log.isDebugEnabled()) {
                UsmUserTable ut = this.snmpCommunicater.getUSM().getUserTable();
                List users = ut.getUserEntries();
                for (UsmUserEntry usmUserEntry : users) {
                    this.log.info((Object)("@@@ username:" + usmUserEntry.getUserName()), 0L);
                    this.log.info((Object)("@@@ securityName:" + usmUserEntry.getUsmUser().getSecurityName()), 0L);
                }
            }
        }
        ((UserTarget)this.snmp4jTarget.getSendTarget()).setSecurityName(this.snmp4jTarget.getSecurityName());
    }

    private byte[] initv3Helper(SecurityProtocols secProtocols, OID oid, OctetString passphrase, byte[] authoritativeengineID) {
        byte[] key = null;
        if (oid != null) {
            key = secProtocols.passwordToKey(this.snmp4jTarget.getAuthProtocol(), passphrase, authoritativeengineID);
        }
        return key;
    }

    @Override
    public void open(String host, int rport, String rcomm, String wcomm, int snmpVersion) {
        if (this.snmp4jTarget.isConnected()) {
            this.log.warn("Snmp4J already opened.");
            return;
        }
        if (null == rcomm || null == wcomm) {
            throw new SnmpException("SNMP V2 param error!");
        }
        this.snmp4jTarget.setHost(host);
        this.snmp4jTarget.setPort(rport);
        this.snmp4jTarget.setVersion(snmpVersion);
        this.snmp4jTarget.setReadCommunity(new OctetString(rcomm));
        this.snmp4jTarget.setWriteCommunity(new OctetString(wcomm));
        try {
            this.init();
            this.snmp4jTarget.setConnected(true);
        }
        catch (Exception e) {
            this.log.error((Object)("Snmp open failed" + ExceptionUtil.getErrorMessage(e)), 0L);
            this.snmp4jTarget.setConnected(false);
        }
    }

    private void init() throws IOException {
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        this.snmpCommunicater = new Snmp((TransportMapping)transport);
        this.snmpCommunicater.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
        this.snmpCommunicater.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        this.snmpCommunicater.listen();
        Address targetAddress = GenericAddress.parse((String)("udp:" + this.snmp4jTarget.getHost() + "/" + this.snmp4jTarget.getPort()));
        this.snmp4jTarget.setSendTarget((Target)new CommunityTarget());
        this.snmp4jTarget.getSendTarget().setAddress(targetAddress);
        this.snmp4jTarget.getSendTarget().setVersion(1);
    }

    @Override
    public boolean isConnected() {
        return this.snmp4jTarget.isConnected();
    }

    @Override
    public ISnmp4jAPI set(int timeout, int tryTimes) {
        this.snmp4jTarget.setTimeout(timeout < 1000 ? 5000 : timeout);
        this.snmp4jTarget.setRetryTime(tryTimes < 0 ? 0 : tryTimes);
        return this;
    }

    @Override
    public synchronized ISnmpResponse snmpGet(String ... oids) {
        SnmpResponse sr = new SnmpResponse();
        if (!this.isConnected()) {
            sr.setStatusCode(SnmpEnum.SnmpErrorStatus.UNKNOWN_FAILURE.getValue());
            sr.setReasonPhrase("Connection is not established.");
            return sr;
        }
        if (oids == null || oids.length == 0) {
            sr.setStatusCode(SnmpEnum.SnmpErrorStatus.PARAM_CHECK_ERROR.getValue());
            sr.setReasonPhrase("Parameter[oids] cannot be null or empty.");
            return sr;
        }
        return this.snmpGet(-96, oids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSnmpV2Trap(String trapIp, int trapPort, long sysUptime, String trapOid, String[] snmpoids, String[] values) {
        boolean checkLength = false;
        boolean bl = checkLength = snmpoids.length != values.length;
        if (checkLength) {
            throw new SnmpException("The param is error");
        }
        TransportMapping transport = null;
        Snmp snmp = null;
        try {
            transport = LegoUdpTransportMappingCreator.create();
            CommunityTarget comtarget = new CommunityTarget();
            comtarget.setVersion(1);
            comtarget.setAddress((Address)new UdpAddress(trapIp + "/" + trapPort));
            comtarget.setRetries(2);
            comtarget.setTimeout(5000L);
            comtarget.setCommunity(this.snmp4jTarget.getWriteCommunity());
            PDU pdu = new PDU();
            pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new OctetString(new Date(sysUptime).toString())));
            pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(trapOid)));
            int index = 0;
            for (String oid : snmpoids) {
                this.log.debug((Object)("Sending V2 Trap :oid " + oid), 0L);
                String value = values[index];
                if (value == null) {
                    value = "";
                }
                pdu.add(new VariableBinding(new OID(oid), (Variable)new OctetString(value)));
                ++index;
            }
            pdu.setType(-89);
            snmp = new Snmp(transport);
            this.log.debug((Object)("Sending V2 Trap to " + trapIp + " : " + trapPort), 0L);
            snmp.send(pdu, (Target)comtarget);
        }
        catch (Exception e) {
            this.log.error((Object)("Error in Sending V2 Trap to " + trapIp + " on Port " + trapPort + ExceptionUtil.getErrorMessage(e)), 0L);
        }
        finally {
            if (null != snmp) {
                try {
                    snmp.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Error close snmp ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSnmpV3Trap(String trapIp, int trapPort, long sysUptime, String trapOid, String[] snmpoids, String[] values) {
        SecurityModels secModels;
        this.log.debug((Object)"#### begin trap v3", 0L);
        if (snmpoids.length != values.length) {
            throw new SnmpException("The param is error");
        }
        SNMP4JSettings.setExtensibilityEnabled((boolean)true);
        SecurityProtocols.getInstance().addDefaultProtocols();
        UserTarget snmpTarget = new UserTarget();
        snmpTarget.setSecurityName(new OctetString(this.snmp4jTarget.getSecurityName()));
        snmpTarget.setVersion(this.snmp4jTarget.getVersion());
        snmpTarget.setAddress(GenericAddress.parse((String)("udp:" + trapIp + "/" + trapPort)));
        this.log.debug((Object)("North trap addr: " + snmpTarget.getAddress()), 0L);
        DefaultUdpTransportMapping transport = null;
        try {
            transport = new DefaultUdpTransportMapping();
        }
        catch (IOException e1) {
            this.log.debug((Object)"error!", 0L);
        }
        OctetString engineId = this.snmp4jTarget.getEngineId();
        if (engineId == null || engineId.toString().equals("")) {
            engineId = new OctetString(LOCAL_ENGINID_COM_HW_IC_TRAP);
        }
        USM usm = new USM(SecurityProtocols.getInstance(), engineId, 500);
        SecurityModels securityModels = secModels = SecurityModels.getInstance();
        synchronized (securityModels) {
            Snmp snmp = null;
            try {
                snmp = new Snmp((TransportMapping)transport);
                if (snmp.getUSM() == null) {
                    secModels.addSecurityModel((SecurityModel)usm);
                }
                OctetString authenticationPassphrase = null;
                OctetString privacyPassphrase = null;
                if (null == this.snmp4jTarget.getAuthProtocol()) {
                    snmpTarget.setSecurityLevel(1);
                } else if (null == this.snmp4jTarget.getPrivProtocol()) {
                    snmpTarget.setSecurityLevel(2);
                    authenticationPassphrase = new OctetString(this.snmp4jTarget.getAuthPassphrase());
                } else {
                    snmpTarget.setSecurityLevel(3);
                    authenticationPassphrase = new OctetString(this.snmp4jTarget.getAuthPassphrase());
                    privacyPassphrase = new OctetString(this.snmp4jTarget.getPrivPassphrase());
                }
                snmp.getUSM().addUser(new OctetString(this.snmp4jTarget.getSecurityName()), engineId, new UsmUser(new OctetString(this.snmp4jTarget.getSecurityName()), this.snmp4jTarget.getAuthProtocol(), authenticationPassphrase, this.snmp4jTarget.getPrivProtocol(), privacyPassphrase));
                this.processListen((TransportMapping)transport);
                ScopedPDU pdu = new ScopedPDU();
                pdu.setContextEngineID(engineId);
                pdu.setType(-89);
                pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new OctetString(new Date(sysUptime).toString())));
                pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(trapOid)));
                this.setSNMPDatda(snmpoids, values, snmpTarget, engineId, snmp, pdu);
            }
            catch (Exception e) {
                this.log.error((Object)("snmp send error." + ExceptionUtil.getErrorMessage(e)), 0L);
            }
            finally {
                this.closeSnmp(snmp);
            }
            this.log.debug((Object)"#### end trap v3", 0L);
        }
    }

    private void processListen(TransportMapping transport) {
        try {
            if (null != transport) {
                transport.listen();
            }
        }
        catch (IOException e1) {
            this.log.debug((Object)"error!", 0L);
        }
    }

    private void closeSnmp(Snmp snmp) {
        try {
            if (snmp != null) {
                snmp.close();
            }
        }
        catch (IOException e) {
            this.log.error((Object)"snmp close error.", (Throwable)e, 0L);
        }
    }

    private void setSNMPDatda(String[] snmpoids, String[] values, UserTarget snmpTarget, OctetString engineId, Snmp snmp, ScopedPDU pdu) throws IOException {
        int index = 0;
        for (String oid : snmpoids) {
            this.log.debug("Sending V2 Trap :oid " + oid);
            String value = values[index];
            if (value == null) {
                value = "";
            }
            pdu.add(new VariableBinding(new OID(oid), (Variable)new OctetString(value)));
            ++index;
        }
        snmp.setLocalEngine(engineId.toByteArray(), 500, 1);
        snmp.send((PDU)pdu, (Target)snmpTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSnmpV1Trap(String trapIp, int trapPort, SnmpV1Param snmpv1param, String[] snmpoids, String[] values) {
        Snmp snmp = null;
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transport);
            transport.listen();
            CommunityTarget comtarget = new CommunityTarget();
            comtarget.setVersion(0);
            comtarget.setAddress((Address)new UdpAddress(trapIp + "/" + trapPort));
            comtarget.setRetries(2);
            comtarget.setTimeout(5000L);
            PDUv1 pdu = new PDUv1();
            pdu.setType(-92);
            pdu.setEnterprise(new OID(snmpv1param.getEnterprise()));
            pdu.setGenericTrap(6);
            pdu.setSpecificTrap(1);
            int index = 0;
            for (String oid : snmpoids) {
                this.logger.debug((Object)"Sending V1 Trap :oid %s", oid);
                String value = values[index];
                if (value == null) {
                    value = "";
                }
                pdu.add(new VariableBinding(new OID(oid), (Variable)new OctetString(value)));
                ++index;
            }
            ResponseEvent respEvnt = snmp.send((PDU)pdu, (Target)comtarget);
            this.log.debug((Object)("Sending V1 Trap to " + trapIp + " : " + trapPort), 0L);
            this.parseResponse(respEvnt);
        }
        catch (Exception e) {
            this.log.error((Object)("Error in Sending V1 Trap to " + trapIp + " on Port " + trapPort + ExceptionUtil.getErrorMessage(e)), 0L);
        }
        finally {
            if (null != snmp) {
                try {
                    snmp.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Error in snmp.close", (Throwable)e, 0L);
                }
            }
        }
    }

    private void parseResponse(ResponseEvent respEvnt) {
        if (respEvnt != null && respEvnt.getResponse() != null) {
            Vector recVBs = respEvnt.getResponse().getVariableBindings();
            for (int i = 0; i < recVBs.size(); ++i) {
                VariableBinding recVB = (VariableBinding)recVBs.elementAt(i);
                this.log.debug((Object)(recVB.getOid() + " : " + recVB.getVariable()), 0L);
            }
        }
    }

    @Override
    public synchronized ISnmpResponse snmpGetBulk(String ... oids) {
        SnmpResponse srr = new SnmpResponse();
        if (!this.isConnected()) {
            srr.setStatusCode(SnmpEnum.SnmpErrorStatus.UNKNOWN_FAILURE.getValue());
            srr.setReasonPhrase("Connection is not established.");
            return srr;
        }
        if (oids == null || oids.length == 0) {
            srr.setStatusCode(SnmpEnum.SnmpErrorStatus.PARAM_CHECK_ERROR.getValue());
            srr.setReasonPhrase("Parameter[oids] cannot be null or empty.");
            return srr;
        }
        return this.snmpGet(-96, oids);
    }

    private ISnmpResponse snmpGet(int type, String[] oids) {
        SnmpResponse sr = new SnmpResponse();
        sr.setInvokeName("Get");
        PDU pdu = this.getPDUObject();
        this.snmp4jTarget.getSendTarget().setVersion(this.snmp4jTarget.getVersion());
        this.snmp4jTarget.getSendTarget().setTimeout((long)this.snmp4jTarget.getTimeout());
        this.snmp4jTarget.getSendTarget().setRetries(this.snmp4jTarget.getRetryTime());
        pdu.setType(type);
        for (String oid : oids) {
            if (null == oid || "".equals(oid)) continue;
            pdu.add(new VariableBinding(new OID(oid.trim())));
            sr.getOidList().add(oid.trim());
        }
        this.debugInfo();
        try {
            ResponseEvent re = this.snmpCommunicater.send(pdu, this.snmp4jTarget.getSendTarget());
            this.setSNMPResponseParams(sr, re);
            if (sr.getStatusCode() != SnmpEnum.SnmpErrorStatus.NO_ERROR.getValue()) {
                this.log.error((Object)sr, 0L);
                if (re != null && re.getError() != null) {
                    this.log.error((Object)"snmpget error", (Throwable)re.getError(), 0L);
                }
            }
            return sr;
        }
        catch (IOException e) {
            this.log.error((Object)"Snmp get failed", (Throwable)e, 0L);
            sr.setStatusCode(SnmpEnum.SnmpErrorStatus.UNKNOWN_FAILURE.getValue());
            sr.setReasonPhrase(e.getMessage());
            return sr;
        }
    }

    private void setSNMPResponseParams(SnmpResponse sr, ResponseEvent re) {
        PDU res;
        PDU pDU = res = re == null ? null : re.getResponse();
        if (res != null) {
            sr.setStatusCode(res.getErrorStatus());
            sr.setReasonPhrase(res.getErrorStatusText());
            if (sr.getStatusCode() == SnmpEnum.SnmpErrorStatus.NO_ERROR.getValue()) {
                for (VariableBinding vb : res.getVariableBindings()) {
                    sr.addVB(vb.getOid().toString(), vb.getVariable().toString(), vb.getVariable().getSyntax());
                }
            }
        } else {
            sr.setStatusCode(SnmpEnum.SnmpErrorStatus.UNKNOWN_FAILURE.getValue());
            sr.setReasonPhrase(re == null ? " No Response" : "Response not contains PDU.");
        }
    }

    private PDU getPDUObject() {
        PDU pdu = null;
        if (this.snmp4jTarget.getVersion() == SnmpEnum.SnmpVersion.VERSION3.getValue()) {
            ScopedPDU pduv3 = new ScopedPDU();
            if (this.snmp4jTarget.getContext() != null) {
                pduv3.setContextName(this.snmp4jTarget.getContext());
            }
            if (this.snmp4jTarget.getEngineId() != null) {
                pduv3.setContextEngineID(this.snmp4jTarget.getEngineId());
            }
            pdu = pduv3;
        } else {
            pdu = new PDU();
            ((CommunityTarget)this.snmp4jTarget.getSendTarget()).setCommunity(this.snmp4jTarget.getReadCommunity());
        }
        return pdu;
    }

    public UsmUser removeUser(OctetString engineID, OctetString userName) {
        return SnmpUtil.getUsm().removeUser(engineID, userName);
    }

    @Override
    public ISnmpResponse snmpGetNext(String ... oids) {
        SnmpResponse sr = new SnmpResponse();
        if (!this.isConnected()) {
            sr.setStatusCode(SnmpEnum.SnmpErrorStatus.UNKNOWN_FAILURE.getValue());
            sr.setReasonPhrase("Connection is not established.");
            return sr;
        }
        if (oids == null || oids.length == 0) {
            sr.setStatusCode(SnmpEnum.SnmpErrorStatus.PARAM_CHECK_ERROR.getValue());
            sr.setReasonPhrase("Parameter[oids] cannot be null or empty.");
            return sr;
        }
        return this.snmpGet(-95, oids);
    }

    @Override
    public ISnmpResponse set(String oid, String value, int type) {
        return this.set(new VBPro().add(oid, value, type));
    }

    @Override
    public ISnmpResponse set(VBPro vbs) {
        SnmpResponse sr = new SnmpResponse();
        sr.setInvokeName("Set");
        if (!this.isConnected()) {
            sr.setStatusCode(SnmpEnum.SnmpErrorStatus.UNKNOWN_FAILURE.getValue());
            sr.setReasonPhrase("Connection is not established.");
            return sr;
        }
        if (vbs == null || vbs.size() == 0) {
            sr.setStatusCode(SnmpEnum.SnmpErrorStatus.PARAM_CHECK_ERROR.getValue());
            sr.setReasonPhrase("Parameter[oids] cannot be null or empty.");
            return sr;
        }
        PDU pdu = this.getScopedPDU();
        this.snmp4jTarget.getSendTarget().setVersion(this.snmp4jTarget.getVersion());
        this.snmp4jTarget.getSendTarget().setTimeout((long)this.snmp4jTarget.getTimeout());
        this.snmp4jTarget.getSendTarget().setRetries(this.snmp4jTarget.getRetryTime());
        pdu.setType(-93);
        try {
            for (Property prop : vbs.getVbs()) {
                VariableBinding vb = SnmpUtil.getVB(prop);
                if (vb == null) continue;
                pdu.add(vb);
                sr.getOidList().add(prop.getName());
            }
        }
        catch (Exception e) {
            sr.setStatusCode(SnmpEnum.SnmpErrorStatus.UNKNOWN_FAILURE.getValue());
            sr.setReasonPhrase("Error while creating VB." + ExceptionUtil.getErrorMessage(e));
            return sr;
        }
        try {
            return this.getSnmpResponseObject(sr, pdu);
        }
        catch (IOException e) {
            this.log.error((Object)"Snmp set failed", (Throwable)e, 0L);
            sr.setStatusCode(SnmpEnum.SnmpErrorStatus.UNKNOWN_FAILURE.getValue());
            sr.setReasonPhrase(e.getMessage());
            return sr;
        }
    }

    private ISnmpResponse getSnmpResponseObject(SnmpResponse sr, PDU pdu) throws IOException {
        PDU res;
        ResponseEvent re = this.snmpCommunicater.send(pdu, this.snmp4jTarget.getSendTarget());
        PDU pDU = res = re == null ? null : re.getResponse();
        if (res == null) {
            Exception e;
            Exception exception = e = re == null ? null : re.getError();
            if (null != e) {
                this.log.error((Object)("Snmp set operation got response with null PDU, exception: " + ExceptionUtil.getErrorMessage(e)), 0L);
                sr.setReasonPhrase(e.getMessage());
            } else {
                this.log.error((Object)"Snmp set operation got response with null PDU.", 0L);
                sr.setReasonPhrase(re == null ? "No response" : "Response No Error.");
            }
            sr.setStatusCode(-2147483647);
            return sr;
        }
        sr.setStatusCode(res.getErrorStatus());
        sr.setReasonPhrase(res.getErrorStatusText());
        return sr;
    }

    private PDU getScopedPDU() {
        PDU pdus = null;
        if (this.snmp4jTarget.getVersion() == SnmpEnum.SnmpVersion.VERSION3.getValue()) {
            ScopedPDU pduv3s = new ScopedPDU();
            if (this.snmp4jTarget.getContext() != null) {
                pduv3s.setContextName(this.snmp4jTarget.getContext());
            }
            if (this.snmp4jTarget.getEngineId() != null) {
                pduv3s.setContextEngineID(this.snmp4jTarget.getEngineId());
            }
            pdus = pduv3s;
        } else {
            pdus = new PDU();
            ((CommunityTarget)this.snmp4jTarget.getSendTarget()).setCommunity(this.snmp4jTarget.getWriteCommunity());
        }
        return pdus;
    }

    protected void finalize() throws Throwable {
        try {
            if (null != this.snmpCommunicater) {
                this.snmpCommunicater.close();
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"error!", 200L);
        }
        super.finalize();
    }

    @Override
    public void close() {
        try {
            if (this.snmpCommunicater != null) {
                this.snmpCommunicater.close();
                this.snmpCommunicater = null;
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Snmp close failed", (Throwable)e, 0L);
        }
        this.snmp4jTarget.setConnected(false);
    }

    @Override
    public ISnmpTableResponse getTableByGetNext(String ... oids) {
        return this.getTableByGetNexts(oids);
    }

    private ISnmpTableResponse getTableByGetNexts(String[] oids) {
        if (!this.isConnected()) {
            return null;
        }
        if (oids == null || oids.length == 0) {
            return null;
        }
        TableResponse table = new TableResponse();
        table.setInvokeName("Table Get Next");
        for (String oid : oids) {
            table.addOid(oid);
        }
        return this.getTableDataNext(oids, table);
    }

    private ISnmpTableResponse getTableDataNext(String[] oids, TableResponse table) {
        boolean isTableEnd = false;
        String[] nextOid = new String[oids.length];
        System.arraycopy(oids, 0, nextOid, 0, oids.length);
        ArrayList<String> row = new ArrayList<String>();
        while (!(isTableEnd = this.getTableDataNext(oids, table, isTableEnd, nextOid, row))) {
        }
        return table;
    }

    private boolean getTableDataNext(String[] oids, TableResponse table, boolean isTableEnd, String[] nextOid, List<String> row) {
        ISnmpResponse response = this.snmpGetNext(nextOid);
        List<Property> pros = response.getVB().getVbs();
        ArrayList<Property> rawDataRow = new ArrayList<Property>();
        if (null != pros && !pros.isEmpty()) {
            int i = 0;
            for (Property pro : pros) {
                LegoSnmpOID legoOid = new LegoSnmpOID(SnmpEnum.SnmpType.STRING, pro.getName());
                nextOid[i] = "." + legoOid.getSnmpoid();
                if (!nextOid[i].contains(oids[i])) {
                    isTableEnd = true;
                    return isTableEnd;
                }
                ++i;
                String oid = pro.getName();
                String v = pro.getValue();
                int type = pro.getType();
                row.add(v);
                rawDataRow.add(new Property(oid, v, type, pro.getIndex()));
            }
            table.addRow(row);
            table.addRawRow(rawDataRow);
        }
        return isTableEnd;
    }

    @Override
    public ISnmpTableResponse getTable(String ... oids) {
        return this.getTable(15000, oids);
    }

    @Override
    public ISnmpTableResponse getTable(int timeout, String ... oids) {
        if (!this.isConnected()) {
            return null;
        }
        if (oids == null || oids.length == 0) {
            return null;
        }
        TableResponse table = new TableResponse();
        table.setInvokeName("Table Get");
        for (String oid : oids) {
            table.addOid(oid);
        }
        return this.getTableData(timeout, table, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableResponse getTableData(int timeout, TableResponse table, OID lowerBoundIndex, OID upperBoundIndex) {
        TableUtils tableUtils = new TableUtils((Session)this.snmpCommunicater, (PDUFactory)new PDUFactoryReqTable(this.snmp4jTarget.getContext(), this.snmp4jTarget.getEngineId()));
        Counter32 counter = new Counter32();
        this.snmp4jTarget.getSendTarget().setVersion(this.snmp4jTarget.getVersion());
        this.snmp4jTarget.getSendTarget().setTimeout((long)this.snmp4jTarget.getTimeout());
        this.snmp4jTarget.getSendTarget().setRetries(this.snmp4jTarget.getRetryTime());
        if (this.snmp4jTarget.getVersion() != SnmpEnum.SnmpVersion.VERSION3.getValue()) {
            ((CommunityTarget)this.snmp4jTarget.getSendTarget()).setCommunity(this.snmp4jTarget.getReadCommunity());
        }
        this.debugInfo();
        OID[] columns = table.getOIDs();
        tableUtils.setMaxNumColumnsPerPDU(columns.length);
        tableUtils.setMaxNumRowsPerPDU(10);
        boolean tm = false;
        Counter32 counter32 = counter;
        synchronized (counter32) {
            TextTableListener listener = new TextTableListener(table);
            tableUtils.getTable(this.snmp4jTarget.getSendTarget(), columns, (TableListener)listener, (Object)counter, lowerBoundIndex, upperBoundIndex);
            tm = this.processTM(tm, timeout, counter, listener);
        }
        if (tm) {
            table.setStatusCode(SnmpEnum.SnmpErrorStatus.TIME_OUT.getValue());
        }
        return table;
    }

    private boolean processTM(boolean tm, int timeout, Counter32 counter, TextTableListener listener) {
        try {
            while (!tm) {
                long start = System.currentTimeMillis();
                counter.wait(timeout);
                listener.timeout();
                if (System.currentTimeMillis() - start < (long)timeout) continue;
                tm = true;
            }
        }
        catch (InterruptedException ex) {
            tm = true;
        }
        return tm;
    }

    public int removeUsmUser(String userName, String engineID) {
        USM usm = (USM)SecurityModels.getInstance().getSecurityModel(new Integer32(3));
        if (usm == null) {
            return 0;
        }
        OctetString oun = new OctetString(userName);
        OctetString oed = new OctetString(engineID);
        List userlist = usm.removeAllUsers(oun, oed);
        if (userlist != null) {
            return userlist.size();
        }
        return 0;
    }

    private void debugInfo() {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n************SNMP PARAM**********\n");
        sb.append("*** snmp4jTarget.getHost():" + this.snmp4jTarget.getSendTarget().getAddress() + "\n");
        sb.append("*** snmp4jTarget.getVersion():" + this.snmp4jTarget.getSendTarget().getVersion() + "\n");
        sb.append("*** snmp4jTarget.getTimeout():" + this.snmp4jTarget.getSendTarget().getTimeout() + "\n");
        if (this.snmp4jTarget.getVersion() != SnmpEnum.SnmpVersion.VERSION3.getValue()) {
            sb.append("*** snmp4jTarget.getCommunity():" + ((CommunityTarget)this.snmp4jTarget.getSendTarget()).getCommunity() + "\n");
        } else {
            sb.append("*** V3 getSecurityLevel:" + this.snmp4jTarget.getSendTarget().getSecurityLevel() + "\n");
            sb.append("*** V3 getSecurityName:" + this.snmp4jTarget.getSendTarget().getSecurityName() + "\n");
            UsmUserEntry use = this.snmpCommunicater.getUSM().getUserTable().getUser(this.snmp4jTarget.getSecurityName());
            if (use != null) {
                sb.append("*** V3 getUserName :" + use.getUserName() + "\n");
                sb.append("*** V3 getEngineID :" + use.getEngineID() + "\n");
                if (null != use.getUsmUser().getAuthenticationProtocol()) {
                    sb.append("*** V3 getAuthenticationProtocol :" + use.getUsmUser().getAuthenticationProtocol().toString() + "\n");
                }
                if (null != use.getUsmUser().getPrivacyProtocol()) {
                    sb.append("*** V3 getPrivacyProtocol :" + use.getUsmUser().getPrivacyProtocol().toString() + "\n");
                }
                sb.append("*** V3 getLocalizationEngineID :" + use.getUsmUser().getLocalizationEngineID() + "\n");
            }
        }
        sb.append("********************************\n");
        this.log.info((Object)sb.toString(), 0L);
    }

    static {
        LegoLogFactoryForSnmp4j.init();
    }

    private static class PDUFactoryReqTable
    implements PDUFactory {
        private OctetString contextName = null;
        private OctetString engineId = null;

        PDUFactoryReqTable(OctetString ctName, OctetString engId) {
            this.contextName = ctName;
            this.engineId = engId;
        }

        public PDU createPDU(Target target) {
            ScopedPDU request = null;
            if (target.getVersion() == 3) {
                ScopedPDU scopedPDU = request = new ScopedPDU();
                if (this.contextName != null) {
                    scopedPDU.setContextName(this.contextName);
                }
                if (this.engineId != null) {
                    scopedPDU.setContextEngineID(this.engineId);
                }
            } else {
                request = new PDU();
            }
            request.setType(-91);
            return request;
        }

        public PDU createPDU(MessageProcessingModel arg0) {
            return null;
        }
    }
}

