/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.exception;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class ExceptionInforLoader {
    private static Log log = LogFactory.getInstance(ExceptionInforLoader.class);
    private static ExceptionInforLoader instance;
    private String name = "exception.properties";
    private Properties props = new Properties();

    private ExceptionInforLoader() {
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream(this.name);
            this.props.load(stream);
        }
        catch (IOException e) {
            log.error((Object)("" + this.name), (Throwable)e, 200L);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error((Object)("" + this.name), (Throwable)e, 200L);
                }
            }
        }
    }

    public static synchronized ExceptionInforLoader getLoader() {
        if (instance == null) {
            instance = new ExceptionInforLoader();
        }
        return instance;
    }

    public Properties getProperties() {
        return this.props;
    }
}

