/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.exception;

import com.huawei.lego.core.sdk.exception.ExceptionInfor;
import com.huawei.lego.core.sdk.exception.ExceptionInforLoader;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Properties;

public class ExceptionLogDecorator
extends RuntimeException {
    private static final long serialVersionUID = -7330712415483341792L;
    private Log log = LogFactory.getInstance(this);

    public ExceptionLogDecorator(String message, Throwable cause) {
        super(message, cause);
        Class<?> clazz = cause.getClass();
        Properties prop = ExceptionInforLoader.getLoader().getProperties();
        this.log.error((Object)new ExceptionInfor(clazz, prop).toString(), (Throwable)null, 0L);
    }

    public ExceptionLogDecorator(String message) {
        super(message);
        this.log.error((Object)message, (Throwable)null, 0L);
    }

    public ExceptionLogDecorator(int errorCode) {
        this.log.error((Object)("Code: " + errorCode), (Throwable)null, 0L);
    }

    public ExceptionLogDecorator(Throwable cause) {
        super(cause);
        Class<?> clazz = cause.getClass();
        Properties prop = ExceptionInforLoader.getLoader().getProperties();
        this.log.error((Object)new ExceptionInfor(clazz, prop).toString(), (Throwable)null, 0L);
    }

    public ExceptionLogDecorator(int errorCode, Throwable e) {
        super("Code: " + errorCode, e);
        this.log.error((Object)("Code: " + errorCode), (Throwable)null, 0L);
    }

    public ExceptionLogDecorator(int errorCode, String info) {
        super("Code: " + errorCode + "\t" + info);
        this.log.error((Object)("Code: " + errorCode + "\t" + info), (Throwable)null, 0L);
    }
}

