/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.exception;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LegoCheckedException
extends RuntimeException {
    protected static final String I18N_PREFIX = "i18n:";
    private static final Log logger = LogFactory.getInstance(LegoCheckedException.class);
    private static final long serialVersionUID = 9223257323548528435L;
    private static final List<Class<? extends Throwable>> EXCEPTIONS = Arrays.asList(ExecutionException.class, InvocationTargetException.class);
    private long errorCode = -1L;
    private String[] parameters;
    private Object accessoryResult;

    public LegoCheckedException(String message, Throwable cause) {
        super(message, cause);
    }

    public LegoCheckedException(String message) {
        super(message);
    }

    public LegoCheckedException(long errorCode) {
        super("Code: " + errorCode);
        this.errorCode = errorCode;
    }

    public LegoCheckedException(long errorCode, String[] parameter) {
        super("Code: " + errorCode);
        this.errorCode = errorCode;
        this.parameters = parameter;
    }

    public LegoCheckedException(long errorCode, String[] parameter, Throwable cause) {
        super("Code: " + errorCode, cause);
        this.errorCode = errorCode;
        this.parameters = parameter;
    }

    public LegoCheckedException(long errorCode, String[] parameter, String message) {
        super(message);
        this.errorCode = errorCode;
        this.parameters = parameter;
    }

    public LegoCheckedException(long errorCode, String message, Log logger, String ... parameter) {
        this(errorCode, parameter, message);
        logger.error((Object)message, this);
    }

    public LegoCheckedException(long errorCode, Throwable e) {
        super("Code: " + errorCode, e);
        this.errorCode = errorCode;
    }

    public LegoCheckedException(long errorCode, String info) {
        super("Code: " + errorCode + "\t" + info);
        this.errorCode = errorCode;
    }

    public LegoCheckedException(long errorCode, String info, Throwable e) {
        super("Code: " + errorCode + "\t" + info, e);
        this.errorCode = errorCode;
    }

    public static LegoCheckedException combine(LegoCheckedException ... errors) {
        return LegoCheckedException.combine(logger, errors);
    }

    public static LegoCheckedException combine(Log log, LegoCheckedException ... errors) {
        return LegoCheckedException.combine(log, 1073947478L, 5, errors);
    }

    public static LegoCheckedException combine(long errorCode, int limit, LegoCheckedException ... errors) {
        return LegoCheckedException.combine(logger, errorCode, limit, errors);
    }

    public static LegoCheckedException combine(Log log, long errorCode, int limit, LegoCheckedException ... errors) {
        if (errors == null || errors.length == 0) {
            return null;
        }
        if (errors.length == 1) {
            return errors[0];
        }
        int maxcount = Math.max(1, limit);
        JSONArray items = Stream.of(errors).map(e -> e.log(log).i18n()).collect(Collectors.toCollection(JSONArray::new));
        String count = Integer.toString(items.size());
        int originsize = items.size();
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (VerifyUtil.isEmpty(item) || items.size() <= maxcount && items.toString().length() <= 1000) continue;
            iterator.remove();
        }
        if (items.size() < originsize) {
            items.add("...");
        }
        items.add(0, I18N_PREFIX + new JSONObject().set("join", "\n").toString());
        return new LegoCheckedException(errorCode, new String[]{I18N_PREFIX + items, count});
    }

    public LegoCheckedException log() {
        return this.log(logger);
    }

    public LegoCheckedException log(Log log) {
        log.error(this, (Object)"%s. code:%s, args:%s", this.getMessage(), this.getErrorCode(), Optional.ofNullable(this.getParameters()).map(Arrays::asList).orElse(Collections.emptyList()));
        if (this.getCause() instanceof LegoCheckedException) {
            ((LegoCheckedException)this.getCause()).log(log);
        }
        return this;
    }

    public Object getAccessoryResult() {
        return this.accessoryResult;
    }

    public void setAccessoryResult(Object result) {
        this.accessoryResult = result;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String getErrorMessageKey() {
        return "lego.err." + this.errorCode;
    }

    public static LegoCheckedException cast(Throwable t, long errorCode, String ... params) {
        Throwable error;
        Throwable throwable = error = EXCEPTIONS.stream().anyMatch(type -> type.isInstance(t)) ? t.getCause() : t;
        if (error instanceof LegoCheckedException) {
            LegoCheckedException e = (LegoCheckedException)error;
            return e.errorCode != 0L ? e : new LegoCheckedException(errorCode, params, t);
        }
        return new LegoCheckedException(errorCode, params, t);
    }

    public String i18n() {
        JSONArray array = new JSONArray();
        array.add("lego.err." + this.errorCode);
        if (this.parameters != null) {
            array.addAll(Arrays.asList(this.parameters));
        }
        return I18N_PREFIX + array;
    }
}

