/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.file.util;

import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CsvFileUtil
extends FileUtil {
    private static final String SIGN_COMMA = ",";
    private final Log LOGGER = LogFactory.getInstance(CsvFileUtil.class);
    private CSVPrinter csvPrinter;

    public CsvFileUtil() {
        this.setStrExtend("csv");
    }

    @Override
    public void closeFile() throws IOException {
        this.csvPrinter.close();
    }

    @Override
    public void writeFile(List<List<String>> dataList) {
        this.writeToFile(dataList);
    }

    private void closeStream(PrintWriter pw, OutputStreamWriter osw, FileOutputStream fos) {
        if (null != pw) {
            pw.close();
        }
        if (null != osw) {
            try {
                osw.close();
            }
            catch (IOException e) {
                this.LOGGER.error("error: " + ExceptionUtil.getErrorMessage(e));
            }
        }
        if (null != fos) {
            try {
                fos.close();
            }
            catch (IOException e) {
                this.LOGGER.error("error:" + ExceptionUtil.getErrorMessage(e));
            }
        }
    }

    @Override
    public void writeFile(List<List<String>> dataList, String detailPath) {
        this.writeToFile(dataList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void writeToFile(List<List<String>> dataList) {
        block18: {
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            PrintWriter pw = null;
            CSVFormat format = CSVFormat.DEFAULT.withHeader(new String[]{SIGN_COMMA}).withSkipHeaderRecord();
            fos = new FileOutputStream(this.getWriteFileName());
            osw = new OutputStreamWriter((OutputStream)fos, Charset.forName(this.getStrChar()));
            pw = new PrintWriter(osw);
            this.csvPrinter = new CSVPrinter((Appendable)pw, format);
            int iIndex = 0;
            Object[] arrTemp = new String[this.getColTitle().size()];
            if (this.getWriteFileName().contains("currentAlarm")) {
                Date date = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat(":yyyy-MM-dd HH:mm:ss");
                this.csvPrinter.printRecord((Object[])new String[]{this.getStrUsrName(), dateFormat.format(date)});
            } else {
                this.csvPrinter.printRecord((Object[])new String[]{this.getStrUsrName(), CsvFileUtil.getNowTime()});
            }
            for (String strTemp : this.getColTitle()) {
                arrTemp[iIndex++] = CommonUtil.formatAvoidCsvInjection(strTemp);
            }
            this.csvPrinter.printRecord(arrTemp);
            for (List lstStr : dataList) {
                iIndex = 0;
                Object[] arrTemps = new String[lstStr.size()];
                for (String info : lstStr) {
                    arrTemps[iIndex++] = CommonUtil.formatAvoidCsvInjection(info);
                }
                this.csvPrinter.printRecord(arrTemps);
            }
            this.csvPrinter.flush();
            try {
                if (null != this.csvPrinter) {
                    this.csvPrinter.close();
                }
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Closer writer failed, errMsg=%s", ExceptionUtil.getErrorMessage(e));
            }
            this.closeStream(pw, osw, fos);
            break block18;
            catch (IOException e) {
                try {
                    this.LOGGER.error("error:" + ExceptionUtil.getErrorMessage(e));
                }
                catch (Throwable throwable) {
                    try {
                        if (null != this.csvPrinter) {
                            this.csvPrinter.close();
                        }
                    }
                    catch (Exception e2) {
                        this.LOGGER.error((Object)"Closer writer failed, errMsg=%s", ExceptionUtil.getErrorMessage(e2));
                    }
                    this.closeStream(pw, osw, fos);
                    throw throwable;
                }
                try {
                    if (null != this.csvPrinter) {
                        this.csvPrinter.close();
                    }
                }
                catch (Exception e3) {
                    this.LOGGER.error((Object)"Closer writer failed, errMsg=%s", ExceptionUtil.getErrorMessage(e3));
                }
                this.closeStream(pw, osw, fos);
            }
        }
    }
}

