/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.apache.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;

public abstract class Log4jConfigurer {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String XML_FILE_EXTENSION = ".xml";

    public static void initLogging(String location) throws FileNotFoundException {
        String resolvedLocation = SystemPropertyUtils.resolvePlaceholders((String)location);
        URL url = ResourceUtils.getURL((String)resolvedLocation);
        if ("file".equals(url.getProtocol()) && !ResourceUtils.getFile((URL)url).exists()) {
            throw new FileNotFoundException("Log4j config file not found");
        }
        Configurator.initialize(null, (String)resolvedLocation);
    }

    public static void initLogging(String location, long refreshInterval) throws FileNotFoundException {
        String resolvedLocation = SystemPropertyUtils.resolvePlaceholders((String)location);
        File file = ResourceUtils.getFile((String)resolvedLocation);
        if (!file.exists()) {
            throw new FileNotFoundException("Log4j config file not found");
        }
        Configurator.initialize(null, (String)resolvedLocation);
        LoggerContext ctx = (LoggerContext)org.apache.logging.log4j.LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        config.getWatchManager().setIntervalSeconds((int)refreshInterval);
    }

    public static void shutdownLogging() {
        LogManager.shutdown();
    }
}

