/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.mediation.synchronize;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.ISynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.XmlSynchronizeContext;
import com.huawei.lego.core.sdk.mediation.synchronize.util.SynchronizeUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractSynchronizer
implements ISynchronizer {
    public static final Log LOGGER = LogFactory.getInstance(AbstractSynchronizer.class);
    private XmlSynchronizeContext neSyncMapping = null;

    public final XmlSynchronizeContext getNeSyncMapping() {
        return this.neSyncMapping;
    }

    public final void setNeSyncMapping(XmlSynchronizeContext neSyncMapping) {
        this.neSyncMapping = neSyncMapping;
    }

    protected final void populateMoPropertyValue(String propertyValue, String propertyType, String propertyName, ManagedObject managedObject) {
        Class<?> moClass = managedObject.getClass();
        try {
            if ((this.check(propertyType) || propertyType.equals("java.lang.Long") || propertyType.equals("boolean") || propertyType.equals("java.lang.Boolean")) && propertyValue != null && propertyValue.contains("(")) {
                int beginIndex = propertyValue.indexOf("(");
                int endIndex = propertyValue.indexOf(")");
                propertyValue = propertyValue.subSequence(beginIndex + 1, endIndex).toString();
            }
            this.invokeFieldMethod(propertyValue, propertyType, propertyName, managedObject, moClass);
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception when populateMoPropertyValue, propertyName is : " + propertyName + ", propertyType is : " + propertyType + ", managedObject is : " + managedObject + ExceptionUtil.getErrorMessage(e)), 200L);
        }
    }

    private void invokeFieldMethod(String propertyValue, String propertyType, String propertyName, ManagedObject managedObject, Class<?> moClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<Object> propertyTypeClass = null;
        Object parsedValue = null;
        if (propertyType.equals("int")) {
            propertyTypeClass = Integer.TYPE;
            parsedValue = NumberUtil.convertToInteger(propertyValue);
        } else if (propertyType.equals("java.lang.Integer")) {
            propertyTypeClass = Integer.class;
            parsedValue = NumberUtil.convertToInteger(propertyValue);
        } else if (propertyType.equals("long")) {
            propertyTypeClass = Long.TYPE;
            parsedValue = NumberUtil.convertToLong(propertyValue);
        } else if (propertyType.equals("java.lang.Long")) {
            propertyTypeClass = Long.class;
            parsedValue = NumberUtil.convertToLong(propertyValue);
        } else if (propertyType.equals("boolean")) {
            propertyTypeClass = Boolean.TYPE;
            parsedValue = propertyValue;
        } else if (propertyType.equals("java.lang.Boolean")) {
            propertyTypeClass = Boolean.class;
            parsedValue = propertyValue;
        } else {
            propertyTypeClass = String.class;
            parsedValue = propertyValue;
        }
        Method fieldMethod = moClass.getMethod("set" + SynchronizeUtil.formatPropertyName(propertyName), propertyTypeClass);
        fieldMethod.invoke((Object)managedObject, parsedValue);
    }

    private boolean check(String propertyType) {
        return propertyType.equals("int") || propertyType.equals("java.lang.Integer") || propertyType.equals("long");
    }

    @Override
    public int getSyncMOCount() {
        return 0;
    }
}

