/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.mediation.synchronize.model;

import com.huawei.lego.cbb.resource.sdk.constant.MoConstant;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.sdk.exception.LegoNewInstanceException;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.ISynchronizer;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class XmlSynchronizeContext {
    private static final Log LOGGER = LogFactory.getInstance(XmlSynchronizeContext.class);
    private List<XmlSynchronizeContext> childrenContext = new ArrayList<XmlSynchronizeContext>(1);
    private Map<String, XmlSynchronizeContext> sysOidXmlSynchronizeContextMap;
    private ISynchronizer synchronizer;
    private Class moClass;
    private String modelId;
    private boolean topMo;
    private String productId;
    private String subType;
    private String type;
    private String referredOid;
    private String referingOid;
    private boolean iPolling = false;

    public boolean isPolling() {
        return this.iPolling;
    }

    public void setIsPolling(boolean isPolling) {
        this.iPolling = isPolling;
    }

    public Class getMoClass() {
        return this.moClass;
    }

    public void setMoClass(Class moClasst) {
        this.moClass = moClasst;
    }

    public boolean isTopMo() {
        return this.topMo;
    }

    public void setTopMo(boolean topMo) {
        this.topMo = topMo;
    }

    public String getReferredOid() {
        return this.referredOid;
    }

    public void setReferredOid(String referredOid) {
        this.referredOid = referredOid;
    }

    public String getReferingOid() {
        return this.referingOid;
    }

    public void setReferingOid(String referingOid) {
        this.referingOid = referingOid;
    }

    public void addChild(XmlSynchronizeContext child) {
        this.childrenContext.add(child);
    }

    public List<XmlSynchronizeContext> getChildren() {
        return this.childrenContext;
    }

    public Map<String, XmlSynchronizeContext> getSysOidXmlSynchronizeContextMap() {
        return this.sysOidXmlSynchronizeContextMap;
    }

    public void setSysOidXmlSynchronizeContextMap(Map<String, XmlSynchronizeContext> sysOidXmlSynchronizeContextMap) {
        this.sysOidXmlSynchronizeContextMap = sysOidXmlSynchronizeContextMap;
    }

    public ISynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public ManagedObject getHalfConstructMo() {
        ManagedObject partyInitializedMo = null;
        try {
            partyInitializedMo = (ManagedObject)this.moClass.newInstance();
            partyInitializedMo.setManaged(true);
            partyInitializedMo.setDomainModelId(this.modelId);
            partyInitializedMo.setDomainProductId(this.productId);
            partyInitializedMo.setStatus(MoConstant.ON_LINE_MO);
            if (partyInitializedMo instanceof TopoObject) {
                TopoObject partyInitializedMo2 = (TopoObject)partyInitializedMo;
                partyInitializedMo2.setMainType(this.type);
                partyInitializedMo2.setSubType(this.subType);
            }
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)e, 200L);
            throw new LegoNewInstanceException(e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e, 200L);
            throw new LegoNewInstanceException(e);
        }
        return partyInitializedMo;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getType() {
        return this.type;
    }

    public void setSysOids(String sysOids) {
        if (!StringUtils.hasText((String)sysOids)) {
            return;
        }
        String[] sysOidArray = sysOids.split(",");
        this.sysOidXmlSynchronizeContextMap = new HashMap<String, XmlSynchronizeContext>();
        for (String sysOid : sysOidArray) {
            String t = sysOid.trim();
            if (!StringUtils.hasText((String)t)) continue;
            this.sysOidXmlSynchronizeContextMap.put(t, this);
        }
    }

    public void setSynchronizer(String synchronizerName) {
        try {
            Class<?> classSynch;
            ClassLoader classLoader = AdapterUtils.getClassLoader(XmlSynchronizeContext.class);
            if (null != classLoader && null != (classSynch = classLoader.loadClass(synchronizerName))) {
                this.synchronizer = (ISynchronizer)classSynch.newInstance();
            }
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)e, 200L);
            throw new LegoNewInstanceException(e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e, 200L);
            throw new LegoNewInstanceException(e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage(e), 200L);
            throw new LegoNewInstanceException(e);
        }
    }

    public void setMo(Class moClasst) {
        this.moClass = moClasst;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "XmlSynchronizeContext [childrenContext=" + this.childrenContext + ", synchronizer=" + this.synchronizer + "]";
    }
}

