/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.mediation.synchronize.snmp;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.com.south.sdk.constant.ProtocolConstant;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.AbstractSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.model.SnmpSyncParamInfo;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.model.SnmpSynchronizeParameter;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.util.SnmpSynchronizeUtil;
import com.huawei.lego.core.sdk.mediation.synchronize.util.SynchronizeUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.Attributes;

public abstract class AbstractSnmpSynchronizer
extends AbstractSynchronizer {
    private static Log logger = LogFactory.getInstance(AbstractSnmpSynchronizer.class);
    private List<String> targetOidList = new ArrayList<String>();
    private Map<String, String> oidPropertyNameMap = new TreeMap<String, String>();
    private Map<String, String> propertyNameReferenceMap = new TreeMap<String, String>();
    private Map<String, String> oidPropertyTypeMap = new TreeMap<String, String>();

    @Override
    public final MoListOrMap synchronizeDataAndConstructMo(SynchronizeParameter synchronizeParameter, MoListOrMap parentMoListOrMap) {
        Map<String, Protocol> managementProtocolMap = synchronizeParameter.getManagementProtocolMap();
        if (managementProtocolMap == null || !managementProtocolMap.containsKey(ProtocolConstant.SNMP_PARA)) {
            logger.warn((Object)("the managementProtocolMap does not contain ProtocolConstant.SNMP_PARA, managementProtocolMap is : " + managementProtocolMap + ", synchronizeParameter is : " + synchronizeParameter), 200L);
            throw new LegoUncheckedException(1053L);
        }
        Collections.sort(this.targetOidList);
        SnmpSyncParamInfo paraminfo = new SnmpSyncParamInfo();
        paraminfo.setReferredAReferingOid(new String[]{super.getNeSyncMapping().getReferredOid(), super.getNeSyncMapping().getReferingOid()});
        paraminfo.setTargetOidList(this.targetOidList);
        SnmpSynchronizeParameter snmpSynchronizeParameter = new SnmpSynchronizeParameter(new String[]{synchronizeParameter.getDeviceIp(), synchronizeParameter.getDeviceNetmask()}, synchronizeParameter.getManagementProtocolMap(), new String[]{synchronizeParameter.getSysOid(), synchronizeParameter.getSysName(), synchronizeParameter.getSysDescr(), synchronizeParameter.getLocation()}, synchronizeParameter.getTargetMo(), synchronizeParameter.getDiscoveryPolicy(), paraminfo);
        List<String[]> mibValueResultList = SnmpSynchronizeUtil.getMibValueFromAgent(this.targetOidList, snmpSynchronizeParameter);
        if (super.getNeSyncMapping().isTopMo() && (mibValueResultList == null || mibValueResultList.isEmpty())) {
            logger.error((Object)("the getMibValueFromAgent result of top is null, targetOidList is : " + this.targetOidList), 200L);
            throw new LegoUncheckedException(1053L);
        }
        mibValueResultList = this.postProcessAfterGetMibValueFromAgent(snmpSynchronizeParameter, this.targetOidList, mibValueResultList);
        this.printLoggerInfo(mibValueResultList);
        if (mibValueResultList != null && !mibValueResultList.isEmpty()) {
            MoListOrMap resultMoListOrMap = this.constructManagedObjects(mibValueResultList, parentMoListOrMap, snmpSynchronizeParameter);
            resultMoListOrMap = this.postProcessAfterConstructMo(snmpSynchronizeParameter, parentMoListOrMap, resultMoListOrMap);
            return resultMoListOrMap;
        }
        logger.info((Object)"the mibValueResult_ is null, so the product process the synchronization by itself", 200L);
        return new MoListOrMap();
    }

    private void printLoggerInfo(List<String[]> mibValueResultList) {
        if (mibValueResultList == null || mibValueResultList.isEmpty()) {
            logger.info((Object)"postProcessAfterGetMibValueFromAgent mibValueResultList is : null or empty", 200L);
            return;
        }
        logger.info((Object)"postProcessAfterGetMibValueFromAgent mibValueResultList is ---> ", 200L);
        for (String[] resultRow : mibValueResultList) {
            logger.info((Object)("postResultOneRow is : " + Arrays.asList(resultRow)), 200L);
        }
    }

    protected abstract MoListOrMap constructManagedObjects(List<String[]> var1, MoListOrMap var2, SnmpSynchronizeParameter var3);

    protected MoListOrMap postProcessAfterConstructMo(SnmpSynchronizeParameter snmpSynchronizeParameter, MoListOrMap parentMoListOrMap, MoListOrMap resultMoListOrMap) {
        return resultMoListOrMap;
    }

    protected List<String[]> postProcessAfterGetMibValueFromAgent(SnmpSynchronizeParameter snmpSynchronizeParameter, List<String> oidList, List<String[]> mibValueResultList) {
        return mibValueResultList;
    }

    public final void parser(String qName, Attributes attributes) {
        if ("field".equals(qName)) {
            String ref;
            logger.debug("qName:" + qName);
            String name = attributes.getValue("name");
            String oid = attributes.getValue("oid");
            if (this.cheStringLength(oid)) {
                String type = attributes.getValue("type");
                this.targetOidList.add(oid);
                this.oidPropertyNameMap.put(oid, name);
                this.oidPropertyTypeMap.put(oid, type);
            }
            if (this.cheStringLength(ref = attributes.getValue("ref"))) {
                this.propertyNameReferenceMap.put(name, ref);
            }
        }
    }

    private boolean cheStringLength(String param) {
        if (null != param && param.length() > 0) {
            return true;
        }
        logger.debug("result is false");
        return false;
    }

    public boolean parseBooleanValue(String strValue) {
        return !"0".equals(strValue);
    }

    public final Map<String, String> getOidPropertyNameMap() {
        return this.oidPropertyNameMap;
    }

    public final void setOidPropertyNameMap(Map<String, String> oidPropertyNameMap) {
        this.oidPropertyNameMap = oidPropertyNameMap;
    }

    public final List<String> getTargetOidList() {
        return this.targetOidList;
    }

    public final void setTargetOidList(List<String> targetOidList) {
        this.targetOidList = targetOidList;
    }

    public final Map<String, String> getPropertyNameReferenceMap() {
        return this.propertyNameReferenceMap;
    }

    public final void setPropertyNameReferenceMap(Map<String, String> propertyNameReferenceMap) {
        this.propertyNameReferenceMap = propertyNameReferenceMap;
    }

    public final Map<String, String> getOidPropertyTypeMap() {
        return this.oidPropertyTypeMap;
    }

    public final void setOidPropertyTypeMap(Map<String, String> oidPropertyTypeMap) {
        this.oidPropertyTypeMap = oidPropertyTypeMap;
    }

    public static ManagedObject constructManagedObjectByMibValue(String[] snmpResultArray, Map<String, String> oidPropertyNameMap, Map<String, String> propertyNameRefMap, Map<String, String> oidPropertyTypeMap, ManagedObject targetMo) {
        Class<?> targetMoClass = targetMo.getClass();
        String arrays = snmpResultArray != null ? Arrays.toString(snmpResultArray) : "null";
        logger.info((Object)("input mibValueMap is : " + arrays), 200L);
        logger.info((Object)("input oidPropertyNameMap is : " + oidPropertyNameMap), 200L);
        logger.info((Object)("input oidPropertyTypeMap is : " + oidPropertyTypeMap), 200L);
        logger.info((Object)("input targetMo is : " + targetMo), 200L);
        String[] propertyNameArray = oidPropertyNameMap.values().toArray(new String[oidPropertyNameMap.values().size()]);
        String[] propertyTypeArray = oidPropertyTypeMap.values().toArray(new String[oidPropertyTypeMap.values().size()]);
        if (null == snmpResultArray) {
            logger.info((Object)("mo after construct indirect by referred property is : " + targetMo), 200L);
            return targetMo;
        }
        if (snmpResultArray.length > propertyNameArray.length || snmpResultArray.length > propertyTypeArray.length) {
            logger.error((Object)"snmpResultArray length not match with propertyNameArray or propertyTypeArray", 200L);
            throw new IllegalArgumentException("snmpResultArray length not match with propertyNameArray or propertyTypeArray");
        }
        for (int i = 0; i < snmpResultArray.length; ++i) {
            String snmpValue = snmpResultArray[i];
            String propertyType = null;
            String propertyName = null;
            try {
                propertyName = propertyNameArray[i];
                propertyType = propertyTypeArray[i];
                snmpValue = AbstractSnmpSynchronizer.processSNMPValue(propertyType, snmpValue);
                AbstractSnmpSynchronizer.invokeTargetMo(targetMo, targetMoClass, snmpValue, propertyType, propertyName);
            }
            catch (Exception e) {
                logger.error((Object)(", propertyName is : " + propertyName + ", propertyType is : " + propertyType + ExceptionUtil.getErrorMessage(e)), 200L);
            }
            logger.info((Object)("mo after construct direct by property is : " + targetMo), 200L);
            AbstractSnmpSynchronizer.invokeTargetMOMethod(propertyNameRefMap, targetMo, targetMoClass);
        }
        logger.info((Object)("mo after construct indirect by referred property is : " + targetMo), 200L);
        return targetMo;
    }

    private static String processSNMPValue(String propertyType, String snmpValue) {
        if ((propertyType.equals("int") || propertyType.equals("java.lang.Integer") || propertyType.equals("long") || propertyType.equals("java.lang.Long")) && snmpValue != null && snmpValue.contains("(")) {
            logger.info((Object)("the original values is : " + snmpValue), 200L);
            int beginIndex = snmpValue.indexOf("(");
            int endIndex = snmpValue.indexOf(")");
            snmpValue = snmpValue.subSequence(beginIndex + 1, endIndex).toString();
            logger.info((Object)("parsed mib snmpValue is : " + snmpValue), 200L);
        }
        return snmpValue;
    }

    private static void invokeTargetMOMethod(Map<String, String> propertyNameRefMap, ManagedObject targetMo, Class<?> targetMoClass) {
        for (Map.Entry<String, String> entry : propertyNameRefMap.entrySet()) {
            String referingPropertyName = entry.getKey();
            String referredPropertyName = entry.getValue();
            try {
                Method refMethod = targetMoClass.getMethod("get" + SynchronizeUtil.formatPropertyName(referredPropertyName), new Class[0]);
                Method propertySetMethod = targetMoClass.getMethod("set" + SynchronizeUtil.formatPropertyName(referingPropertyName), refMethod.getReturnType());
                propertySetMethod.invoke((Object)targetMo, refMethod.invoke((Object)targetMo, new Object[0]));
            }
            catch (Exception e) {
                logger.error((Object)("exception when constructManagedObject, referredPropertyName is : " + referredPropertyName + ", referingPropertyName is : " + referingPropertyName + ExceptionUtil.getErrorMessage(e)), 200L);
            }
        }
    }

    private static void invokeTargetMo(ManagedObject targetMo, Class<?> targetMoClass, String snmpValue, String propertyType, String propertyName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<Object> propertyTypeClass = null;
        Object parsedMibValue = null;
        if (propertyType.equals("int")) {
            propertyTypeClass = Integer.TYPE;
            parsedMibValue = NumberUtil.convertToInteger(snmpValue);
        } else if (propertyType.equals("java.lang.Integer")) {
            propertyTypeClass = Integer.class;
            parsedMibValue = NumberUtil.convertToInteger(snmpValue);
        } else if (propertyType.equals("long")) {
            propertyTypeClass = Long.TYPE;
            parsedMibValue = NumberUtil.convertToLong(snmpValue);
        } else if (propertyType.equals("java.lang.Long")) {
            propertyTypeClass = Long.class;
            parsedMibValue = NumberUtil.convertToLong(snmpValue);
        } else {
            propertyTypeClass = String.class;
            parsedMibValue = snmpValue;
        }
        Method propertyMethod = targetMoClass.getMethod("set" + SynchronizeUtil.formatPropertyName(propertyName), propertyTypeClass);
        propertyMethod.invoke((Object)targetMo, parsedMibValue);
    }
}

