/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ipv6AddressUtil {
    private static final Log LOG = LogFactory.getInstance(Ipv6AddressUtil.class);
    private static Pattern patternIPv6 = Pattern.compile(AddressUtil.IPV6REG);

    public static String convertIpv6(String serverIp) {
        if (Ipv6AddressUtil.isSavedIpv6(serverIp)) {
            return serverIp;
        }
        return "[" + serverIp + "]";
    }

    public static boolean isSavedIpv6(String serverIp) {
        return serverIp.startsWith("[") && serverIp.endsWith("]");
    }

    public static String fillIpv6(String ipv6, String fillString) {
        if ((ipv6 = ipv6.trim()).startsWith(":")) {
            ipv6 = "0000" + ipv6;
        }
        if (ipv6.endsWith(":")) {
            ipv6 = ipv6 + "0000";
        }
        StringBuilder newIpv6 = new StringBuilder();
        String[] segments = ipv6.split(":");
        if (VerifyUtil.isEmpty(segments[0])) {
            segments[0] = "0000";
        }
        if (VerifyUtil.isEmpty(segments[segments.length - 1])) {
            segments[segments.length - 1] = "0000";
        }
        for (String segment : segments) {
            if (VerifyUtil.isEmpty(segment)) {
                for (int i = 0; i <= 8 - segments.length; ++i) {
                    newIpv6.append("0000").append(fillString);
                }
                continue;
            }
            if (segment.length() == 1) {
                newIpv6.append("000");
                newIpv6.append(segment);
            } else if (segment.length() == 2) {
                newIpv6.append("00");
                newIpv6.append(segment);
            } else if (segment.length() == 3) {
                newIpv6.append("0");
                newIpv6.append(segment);
            } else {
                newIpv6.append(segment);
            }
            newIpv6.append(fillString);
        }
        return newIpv6.substring(0, newIpv6.length() - fillString.length());
    }

    public static String formatIPv6(String ipStr) {
        return "[" + ipStr.trim().replaceAll("^\\[|\\]$", "") + "]";
    }

    public static BigInteger ipv6ToInt(String ipaddress) {
        String oldIpAddress = ipaddress;
        BigInteger big = BigInteger.ZERO;
        try {
            int compressIndex;
            if (ipaddress.contains("%")) {
                ipaddress = ipaddress.split("%")[0];
            }
            if ((compressIndex = ipaddress.indexOf("::")) != -1) {
                char[] ch;
                String part1s = ipaddress.substring(0, compressIndex);
                String part2s = ipaddress.substring(compressIndex + 1);
                BigInteger part1 = Ipv6AddressUtil.ipv6ToInt(part1s);
                BigInteger part2 = Ipv6AddressUtil.ipv6ToInt(part2s);
                int part1hasDot = 0;
                for (char c : ch = part1s.toCharArray()) {
                    if (c != ':') continue;
                    ++part1hasDot;
                }
                return part1.shiftLeft(16 * (7 - part1hasDot)).add(part2);
            }
            String[] str = ipaddress.split(":");
            for (int i = 0; i < str.length; ++i) {
                if (str[i].isEmpty()) {
                    str[i] = "0";
                }
                big = big.add(BigInteger.valueOf(Long.valueOf(str[i], 16)).shiftLeft(16 * (str.length - i - 1)));
            }
        }
        catch (Exception ex) {
            throw ExceptionUtil.convertException(ex, "Transfer to bigint got error. input ip:" + oldIpAddress, 1073947393L, new String[0], LOG);
        }
        return big;
    }

    public static boolean isValidIPv6(String ipv6) {
        if (Ipv6AddressUtil.isIPv6Address(ipv6)) {
            try {
                Inet6Address address = (Inet6Address)InetAddress.getByName(ipv6);
                if (null == address) {
                    return false;
                }
                return !address.isMulticastAddress() && !address.isLoopbackAddress() && !address.isAnyLocalAddress();
            }
            catch (UnknownHostException e) {
                LOG.error("check isValidIPV6 failed! " + ExceptionUtil.getErrorMessage(e));
                return false;
            }
            catch (Exception ex) {
                LOG.error("check isValidIPV6 error! " + ExceptionUtil.getErrorMessage(ex));
                return Ipv4AddressUtil.isValidIPv4(ipv6);
            }
        }
        return Ipv4AddressUtil.isValidIPv4(ipv6);
    }

    public static boolean isIPv6Address(String ip) {
        if (VerifyUtil.isEmpty(ip)) {
            LOG.debug("ip is null! ");
            return false;
        }
        String ipv6 = Normalizer.normalize(ip, Normalizer.Form.NFKC);
        Matcher mat = patternIPv6.matcher(ipv6);
        if (mat.matches()) {
            try {
                Inet6Address address = (Inet6Address)InetAddress.getByName(ipv6);
                return null != address;
            }
            catch (UnknownHostException ex1) {
                LOG.info(ExceptionUtil.getErrorMessage(ex1));
                return false;
            }
        }
        LOG.info((Object)"%s is not a ipv6 address!", ipv6);
        return false;
    }

    public static String getIpv6Address(String text) {
        if (text == null || VerifyUtil.isEmpty(text)) {
            return null;
        }
        Matcher matcher = patternIPv6.matcher(text);
        while (matcher.find()) {
            String matched = matcher.group();
            if (!patternIPv6.matcher(matched).matches()) continue;
            return matched;
        }
        return null;
    }
}

