/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class LegoCmdUtil {
    private static final Log LOGGER = LogFactory.getInstance(LegoCmdUtil.class);
    private static final int FAIL_FLAG = -1;
    private static final long THRITY_MINUTES = 1800000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runShell(String shStr, String outFile) {
        Process process = null;
        if (SecurityUtil.fileValueBlackListCheck(shStr)) {
            LOGGER.error("The input shStr is illegal.");
            return;
        }
        try {
            process = Runtime.getRuntime().exec(shStr);
            try (InputStreamReader ir = new InputStreamReader(process.getInputStream(), Charset.defaultCharset());
                 LineNumberReader input = new LineNumberReader(ir);
                 OutputStream outputStream = Files.newOutputStream(Paths.get(outFile, new String[0]), new OpenOption[0]);){
                String outLine;
                while ((outLine = input.readLine()) != null) {
                    outputStream.write(outLine.getBytes(StandardCharsets.UTF_8));
                    outputStream.write(System.lineSeparator().getBytes(StandardCharsets.UTF_8));
                }
                int result = LegoCmdUtil.waitProcessExecuteWithTimeout(process);
                if (result != 0) {
                    LOGGER.error((Object)"The executing result is not normal. Result: %s", String.valueOf(result));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Executing linux command failed. ErrMsg: %s", ExceptionUtil.getErrorMessage(e));
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int waitProcessExecuteWithTimeout(Process process) {
        int result = -1;
        ProcessWorker worker = new ProcessWorker(process);
        try {
            worker.start();
            worker.join(1800000L);
            result = worker.getRetValue();
            if (Integer.MIN_VALUE == result) {
                result = -1;
            }
        }
        catch (Exception ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
        }
        finally {
            if (null != process) {
                process.destroy();
                process = null;
            }
        }
        return result;
    }

    private static class ProcessWorker
    extends Thread {
        private final Process process;
        private int retValue = Integer.MIN_VALUE;

        public ProcessWorker(Process process) {
            this.process = process;
        }

        public int getRetValue() {
            return this.retValue;
        }

        @Override
        public void run() {
            try {
                this.retValue = this.process.waitFor();
            }
            catch (Exception e) {
                LOGGER.error("Executing waitFor failed." + ExceptionUtil.getErrorMessage(e));
            }
        }
    }
}

