/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class LegoConfig {
    private static final Log logger = LogFactory.getInstance(LegoConfig.class);
    private static final String CERT_ALARM_SWITCH_OFF = "off";
    private static final String CERT_ALARM_SWITCH = "CertificateAlarmSwith";
    private static final String SYSTEM_PROPERTIES = "conf/lego.properties";
    private static final String NODE_CONFIG = "conf/node.properties";
    private static final String DEPLOY_CONFIG = "conf/legoDeploy.conf";
    public static final String TOMCAT_CONFIG = "../conf/catalina.properties";
    private static final Map<String, LegoConfig> INSTANCES = new HashMap<String, LegoConfig>();
    private static final long GET_REGULAR = 600L;
    private static final long TEN_THOUSAND_MILLISECONDS = 1000L;
    private static final String SYS_DEFAULT_DBPASSWORD_ISCHANGED = "sys.default.dbpassword.ischanged";
    private static final String SYS_DEFAULT_MANAGERDBPASSWORD_ISCHANGED = "sys.default.managerdbpassword.ischanged";
    private String path;
    private Properties properties;

    public LegoConfig(String path) {
        this.path = path;
        this.readConfigProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigProperties() {
        File file = new File(this.path);
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            InputStreamReader inputReader = null;
            try {
                fileInputStream = new FileInputStream(file);
                inputReader = new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset());
                Properties props = new Properties();
                props.load(inputReader);
                this.setProperties(props);
            }
            catch (IOException e) {
                try {
                    logger.error((Object)"Read lego.properties fail. error: %s", ExceptionUtil.getErrorMessage(e));
                }
                catch (Throwable throwable) {
                    CommonUtil.close(inputReader);
                    CommonUtil.close(fileInputStream);
                    throw throwable;
                }
                CommonUtil.close(inputReader);
                CommonUtil.close(fileInputStream);
            }
            CommonUtil.close(inputReader);
            CommonUtil.close(fileInputStream);
        }
    }

    public synchronized void reloadConfigProperties() {
        this.readConfigProperties();
    }

    public static LegoConfig getInstance() {
        return LegoConfig.getInstance(SYSTEM_PROPERTIES);
    }

    public static LegoConfig getNodeConfig() {
        return LegoConfig.getInstance(NODE_CONFIG);
    }

    public static LegoConfig getDeployConfig() {
        return LegoConfig.getInstance(DEPLOY_CONFIG);
    }

    public static synchronized LegoConfig getInstance(String path) {
        LegoConfig config = INSTANCES.get(path);
        if (config == null) {
            config = new LegoConfig(path);
            INSTANCES.put(path, config);
        }
        return config;
    }

    public String getKeyValue(String key) {
        String value = "";
        if (null != this.properties) {
            value = this.properties.getProperty(key);
        }
        return value;
    }

    public String getKeyValue(String key, String defaultValue) {
        String value = this.getKeyValue(key);
        value = value != null ? Normalizer.normalize(value, Normalizer.Form.NFKC) : defaultValue;
        return value;
    }

    public void updateKeyValue(String key, String value) throws IOException {
        Set<String> propertyNames = this.properties.stringPropertyNames();
        if (!propertyNames.contains(key)) {
            logger.error("Not support add new key, only set key`s value.");
            throw new IllegalArgumentException("Not support the key");
        }
        this.properties.setProperty(key, value);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.path), StandardCharsets.UTF_8);){
            this.properties.store(writer, "save data");
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            logger.error((Object)"Exception when update file, errorMsg: %s", ExceptionUtil.getErrorMessage(e));
            throw e;
        }
    }

    public long getNumber(String key, long defaultValue) {
        long num;
        String value = this.getKeyValue(key, String.valueOf(defaultValue));
        logger.info("get value from config file with key, key:" + key + "value:" + value);
        value = value != null ? value : "";
        value = value.replaceAll("^\\s*|\\s*$", "");
        value = value.matches("^\\d+$") ? value : String.valueOf(defaultValue);
        try {
            num = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            logger.error("number format error for " + key + ", will use default value: " + defaultValue);
            num = defaultValue;
        }
        return num;
    }

    public long getNumberWithMaxValue(String key, long defaultValue, long maxLimitValue) {
        long num = this.getNumber(key, defaultValue);
        return Math.min(num, maxLimitValue);
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean isCertAlarmSwitch() {
        boolean certAlarmSwitch = true;
        String alarmSwitch = this.properties.getProperty(CERT_ALARM_SWITCH);
        logger.debug((Object)("cert alarm switch:" + alarmSwitch), 1L);
        if (CERT_ALARM_SWITCH_OFF.equalsIgnoreCase(alarmSwitch)) {
            certAlarmSwitch = false;
        }
        return certAlarmSwitch;
    }

    public static synchronized void updateInstance() {
        LegoConfig config = INSTANCES.get(SYSTEM_PROPERTIES);
        if (config != null) {
            config.reloadConfigProperties();
            INSTANCES.put(SYSTEM_PROPERTIES, config);
        }
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.getKeyValue(key, String.valueOf(defaultValue));
        if (!VerifyUtil.isEmpty(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static void diffDataBaseConfig(Map<String, String> data) {
        String fileName = PathUtil.getRuntimePath() + File.separator + "bin" + File.separator + "config" + File.separator + "system.xml";
        File file = new File(fileName);
        try {
            SAXReader sax = CommonUtil.newSecureSAXReader();
            Document document = sax.read(file);
            Node node = document.selectSingleNode("/install/database");
            if (!(node instanceof Element)) {
                logger.error("Node is not instanceof document.");
                return;
            }
            Element dbElement = (Element)node;
            String enDbpassword = dbElement.attributeValue("dbpassword");
            if (!WccEncryptor.decrypt(enDbpassword).equals(WccEncryptor.decrypt(LegoConfig.getInstance().getKeyValue("sys.default.dbPwd", "")))) {
                data.put(SYS_DEFAULT_DBPASSWORD_ISCHANGED, "true");
            } else {
                data.put(SYS_DEFAULT_DBPASSWORD_ISCHANGED, "false");
            }
            String enManagerdbusername = dbElement.attributeValue("managerpassword");
            if (!WccEncryptor.decrypt(enManagerdbusername).equals(WccEncryptor.decrypt(LegoConfig.getInstance().getKeyValue("sys.default.managerdbPwd", "")))) {
                data.put(SYS_DEFAULT_MANAGERDBPASSWORD_ISCHANGED, "true");
            } else {
                data.put(SYS_DEFAULT_MANAGERDBPASSWORD_ISCHANGED, "false");
            }
        }
        catch (DocumentException | SAXException e1) {
            logger.error((Object)"Parse document error: %s", e1);
        }
    }

    static {
        Thread regularGetLegoConfigThread = new Thread(){

            @Override
            public void run() {
                this.setName("regularGetLegoConfigThread");
                while (true) {
                    try {
                        while (true) {
                            1.sleep(600000L);
                            LegoConfig.updateInstance();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to get regular legoConfig.", ExceptionUtil.getErrorMessage(e));
                        continue;
                    }
                    break;
                }
            }
        };
        regularGetLegoConfigThread.start();
        logger.info("regular get legoConfig thread already start");
    }
}

