/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public final class NumberUtil {
    private static final Log logger = LogFactory.getInstance(NumberUtil.class);
    private static final short ZERO = 0;
    private static final boolean FALSE = Boolean.FALSE;

    private NumberUtil() {
    }

    public static boolean getBooleanValue(Boolean booleanValue) {
        return booleanValue == null ? FALSE : booleanValue;
    }

    public static short getShortValue(Short shortObj) {
        return shortObj == null ? (short)0 : shortObj;
    }

    public static int getIntValue(Integer intObj) {
        return intObj == null ? 0 : intObj;
    }

    public static long getLongValue(Long longObj) {
        return longObj == null ? 0L : longObj;
    }

    public static Double parseDouble(Object obj) {
        Double data = 0.0;
        if (obj != null) {
            try {
                data = Double.valueOf(obj.toString());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Parsing failed. obj:" + obj), 0L);
                data = 0.0;
            }
        }
        return data;
    }

    public static Integer parseInteger(Object obj) {
        Integer data = 0;
        if (obj != null) {
            try {
                data = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Parsing failed. obj:" + obj), 0L);
                data = 0;
            }
        }
        return data;
    }

    public static Long parseLong(Object obj) {
        Long value = 0L;
        if (obj != null) {
            try {
                value = Long.valueOf(obj.toString());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Parsing failed. obj:" + obj), 0L);
                value = 0L;
            }
        }
        return value;
    }

    public static Long convertToLong(Object object, long defaultValue) {
        if (null == object) {
            return defaultValue;
        }
        Long result = null;
        try {
            result = Long.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 0L);
            result = defaultValue;
        }
        return result;
    }

    public static Integer convertToInteger(Object object, int defaultValue) {
        return NumberUtil.convertToInteger(object, RADIX.TEN, defaultValue);
    }

    public static Integer convertToInteger(Object object, RADIX radix, int defaultValue) {
        if (null == object) {
            return defaultValue;
        }
        Integer result = null;
        try {
            result = Integer.valueOf(String.valueOf(object), radix.getValue());
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 0L);
            result = defaultValue;
        }
        return result;
    }

    public static Double convertToDouble(Object object, double defaultValue) {
        if (null == object) {
            return defaultValue;
        }
        Double result = null;
        try {
            result = Double.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 0L);
            result = defaultValue;
        }
        return result;
    }

    public static Long convertToLong(Object object, LegoCheckedException failException) {
        if (null == object) {
            throw failException;
        }
        try {
            return Long.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 0L);
            throw failException;
        }
    }

    public static Integer convertToInteger(Object object, RADIX radix, LegoCheckedException failException) {
        if (null == object) {
            throw failException;
        }
        try {
            return Integer.valueOf(String.valueOf(object), radix.getValue());
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 0L);
            throw failException;
        }
    }

    public static Integer convertToInteger(Object object, LegoCheckedException failException) {
        return NumberUtil.convertToInteger(object, RADIX.TEN, failException);
    }

    public static Double convertToDouble(Object object, LegoCheckedException failException) {
        if (null == object) {
            throw failException;
        }
        try {
            return Double.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 0L);
            throw failException;
        }
    }

    public static Float convertToFloat(Object object, LegoCheckedException failException) {
        if (null == object) {
            throw failException;
        }
        try {
            return Float.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 0L);
            throw failException;
        }
    }

    public static Long convertToLong(Object object) {
        return NumberUtil.convertToLong(object, new LegoCheckedException(1073947393L));
    }

    public static Integer convertToInteger(Object object) {
        return NumberUtil.convertToInteger(object, new LegoCheckedException(1073947393L));
    }

    public static Integer convertToInteger(Object object, RADIX radix) {
        return NumberUtil.convertToInteger(object, radix, new LegoCheckedException(1073947393L));
    }

    public static Double convertToDouble(Object object) {
        return NumberUtil.convertToDouble(object, new LegoCheckedException(1073947393L));
    }

    public static Float convertToFloat(Object object) {
        return NumberUtil.convertToFloat(object, new LegoCheckedException(1073947393L));
    }

    public static enum RADIX {
        TWO(2),
        EIGHT(8),
        TEN(10),
        SIXTEEN(16);

        private int value;

        private RADIX(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

