/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public final class ReflectUtil {
    private static final Log logger = LogFactory.getInstance(ReflectUtil.class);

    private ReflectUtil() {
    }

    public static Method getter(Class<?> clazz, String fieldName, Class<?> fieldType) {
        fieldName = "get" + fieldName.substring(0, 1).toUpperCase(Locale.US) + fieldName.substring(1);
        return ReflectUtil.method(clazz, fieldName, fieldType, new Class[0]);
    }

    public static Method setter(Class<?> clazz, String fieldName, Class<?> fieldType) {
        fieldName = "set" + fieldName.substring(0, 1).toUpperCase(Locale.US) + fieldName.substring(1);
        return ReflectUtil.method(clazz, fieldName, Void.class, fieldType);
    }

    public static Method method(Class<?> clazz, String name, Class<?> retType, Class<?> ... argTypes) {
        if (VerifyUtil.isEmpty(clazz)) {
            return null;
        }
        try {
            Method m = clazz.getDeclaredMethod(name, argTypes);
            return retType.isAssignableFrom(m.getReturnType()) ? m : null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.debug(ExceptionUtil.getErrorMessage(e));
            return ReflectUtil.method(clazz.getSuperclass(), name, retType, argTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object object, Method m) {
        if (VerifyUtil.isEmpty(m)) {
            return null;
        }
        boolean needRestore = false;
        try {
            needRestore = ReflectUtil.modifyAccessible(m);
            Object object2 = m.invoke(object, new Object[0]);
            return object2;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.debug(ExceptionUtil.getErrorMessage(e));
        }
        finally {
            ReflectUtil.restoreAccessible(m, needRestore);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object object, Field f) {
        if (VerifyUtil.isEmpty(f)) {
            return null;
        }
        boolean needRestore = false;
        try {
            needRestore = ReflectUtil.modifyAccessible(f);
            Object object2 = f.get(object);
            return object2;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.debug(ExceptionUtil.getErrorMessage(e));
        }
        finally {
            ReflectUtil.restoreAccessible(f, needRestore);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean set(Object object, Method m, Object value) {
        if (VerifyUtil.isEmpty(m)) {
            return false;
        }
        boolean needRestore = false;
        try {
            needRestore = ReflectUtil.modifyAccessible(m);
            m.invoke(object, value);
            boolean bl = true;
            return bl;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error(ExceptionUtil.getErrorMessage(e));
        }
        finally {
            ReflectUtil.restoreAccessible(m, needRestore);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean set(Object object, Field f, Object value) {
        if (VerifyUtil.isEmpty(f)) {
            return false;
        }
        boolean needRestore = false;
        try {
            needRestore = ReflectUtil.modifyAccessible(f);
            f.set(object, value);
            boolean bl = true;
            return bl;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error(ExceptionUtil.getErrorMessage(e));
        }
        finally {
            ReflectUtil.restoreAccessible(f, needRestore);
        }
        return false;
    }

    private static boolean modifyAccessible(AccessibleObject ao) {
        if (ao.isAccessible()) {
            return false;
        }
        ao.setAccessible(true);
        return true;
    }

    private static void restoreAccessible(AccessibleObject ao, boolean needRestore) {
        if (needRestore) {
            ao.setAccessible(false);
        }
    }

    public static Field field(Class<?> clazz, String name, Class<?> fieldType) {
        if (VerifyUtil.isEmpty(clazz)) {
            return null;
        }
        try {
            Field f = clazz.getDeclaredField(name);
            return fieldType.isAssignableFrom(f.getType()) ? f : null;
        }
        catch (NoSuchFieldException | SecurityException e) {
            logger.debug(ExceptionUtil.getErrorMessage(e));
            return ReflectUtil.field(clazz.getSuperclass(), name, fieldType);
        }
    }
}

