/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.util.ReflectUtil;
import java.lang.reflect.Field;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SecurityUtil {
    public static final String EMPTY_STRING = "";
    private static final String PROPERTIES_BLACK_LIST = "[|&<>$`!;\n]";
    private static final String SENSITIVE_PATTERN = "\"(admin_pass|password|Password|PASSWORD|passwd|oldPasswd|newPasswd|passwdNew)\"\\s*:\\s*\"([^\\\\\"]|\\\\.)*\"";
    private static final int ERASE_COUNT = 3;

    private SecurityUtil() {
    }

    public static String desensitization(String string) {
        String[] exprs;
        String newString = string;
        if (newString == null) {
            return null;
        }
        for (String expr : exprs = new String[]{SENSITIVE_PATTERN}) {
            newString = newString.replaceAll(expr, "\"$1\":\"***\"");
        }
        String str = "(iqn|eui)\\.[A-Za-z0-9.:-]{4,219}";
        newString = newString.replaceAll(str, "***");
        return newString;
    }

    public static boolean fileValueBlackListCheck(String param) {
        if (Objects.isNull(param) || EMPTY_STRING.equals(param)) {
            return false;
        }
        Pattern pattern = Pattern.compile(PROPERTIES_BLACK_LIST);
        Matcher matcher = pattern.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return matcher.find();
    }

    public static boolean fileValueBlackListCheck(String[] params) {
        for (String param : params) {
            if (!SecurityUtil.fileValueBlackListCheck(param)) continue;
            return true;
        }
        return false;
    }

    public static void erasePwd(String password) {
        Field value = ReflectUtil.field(String.class, "value", char[].class);
        char[] strValArr = (char[])ReflectUtil.get((Object)password, value);
        SecurityUtil.eraseChars(strValArr);
    }

    public static void eraseChars(char[] chars) {
        if (chars == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            Arrays.fill(chars, '\u0000');
        }
    }
}

