/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SortList;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;

public class TestPortUtil
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static TestPortUtil instanse = null;
    private static final Log LOGGER = LogFactory.getInstance(SortList.class);

    private TestPortUtil() {
    }

    public static synchronized TestPortUtil getInstanse() {
        if (instanse == null) {
            instanse = new TestPortUtil();
        }
        return instanse;
    }

    public Boolean ipReachable(String hostIp) {
        Boolean reachable;
        try {
            reachable = ServiceProvider.getPingService().ping(hostIp, 0, 3);
        }
        catch (Exception e) {
            reachable = false;
            LOGGER.error((Object)("up down level NMS pinging ip : " + hostIp + "...... failed" + ExceptionUtil.getErrorMessage(e)), 200L);
        }
        return reachable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean portEnable(String hostIp, int port) {
        Boolean enable = Boolean.TRUE;
        Socket socket = null;
        if (null == hostIp) {
            return Boolean.FALSE;
        }
        try {
            socket = new Socket(hostIp, port);
        }
        catch (Exception ex) {
            enable = Boolean.FALSE;
            LOGGER.error((Object)("exception when test ip and port, ip is : " + hostIp + ", port is : " + port + ExceptionUtil.getErrorMessage(ex)), 200L);
        }
        finally {
            try {
                if (null != socket) {
                    socket.close();
                } else {
                    enable = false;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"exception when close socket", (Throwable)e, 200L);
            }
        }
        return enable;
    }
}

