/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.ism.drm.wcc.util.WccHelper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;

public class WccEncryptor {
    private static final Log log = LogFactory.getInstance(WccEncryptor.class);

    private static WccHelper getWccHelper() {
        try {
            return WccHelper.getInstance();
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getErrorMessage(e));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public static void exportWccConfig(String file, String encryptPwd) {
        WccEncryptor.getWccHelper().exportWccConfig(file, encryptPwd);
    }

    public static void importWccConfig(String file, String decryptPwd, boolean isAppend) {
        WccEncryptor.getWccHelper().importWccConfig(file, decryptPwd, isAppend);
    }

    public static boolean checkFileComplete(String file, String oldHashCode) {
        boolean isOk = false;
        try {
            isOk = WccEncryptor.getWccHelper().checkFileComplete(file, oldHashCode);
        }
        catch (IOException e) {
            log.error("CheckFileComplete failed:" + ExceptionUtil.getErrorMessage(e));
        }
        catch (Exception e) {
            log.error("CheckFileComplete failed:" + ExceptionUtil.getErrorMessage(e));
            e.printStackTrace();
        }
        return isOk;
    }

    public static String decrypt(String txt) {
        String decryptCtxt = "";
        try {
            decryptCtxt = WccEncryptor.getWccHelper().decrypt(txt);
        }
        catch (Exception e) {
            decryptCtxt = "";
            log.error("decrypt failed:" + ExceptionUtil.getErrorMessage(e));
        }
        return decryptCtxt;
    }

    public static String encrypt(String txt) {
        String encryptCtxt = "";
        try {
            encryptCtxt = WccEncryptor.getWccHelper().encrypt(txt);
        }
        catch (Exception e) {
            encryptCtxt = "";
            log.error("encrypt failed:" + ExceptionUtil.getErrorMessage(e));
        }
        return encryptCtxt;
    }
}

