/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.topo.sdk.model;

import com.huawei.lego.nem.topo.sdk.annotation.XmlProperty;
import com.huawei.lego.nem.topo.sdk.model.ITreeElements;
import com.huawei.lego.nem.topo.sdk.model.TopoElement;
import com.huawei.lego.nem.topo.sdk.model.UIStyle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UIElement
extends TopoElement
implements ITreeElements,
Cloneable {
    private static final long serialVersionUID = 8679645094836735000L;
    @XmlProperty(Alias="eleType")
    private Long eleType;
    private String entityId;
    @XmlProperty(Alias="mainType")
    private String eleMainType;
    @XmlProperty(Alias="subType")
    private String eleSubType;
    @XmlProperty(Alias="route")
    private String appendixInfo;
    private Map<String, UIElement> unStoredElements = new HashMap<String, UIElement>();
    private boolean existInLayout = false;
    @XmlProperty(Alias="visible")
    private boolean authVisible = true;
    private String aliasName;
    private String extProp;

    public UIElement() {
    }

    public UIElement(Long id) {
        super(id);
    }

    public UIElement getParentUIElement() {
        TopoElement parentEle = this.getParentElement();
        if (null != parentEle && parentEle instanceof UIElement) {
            return (UIElement)parentEle;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public void setParentUIElement(TopoElement topoEle) {
        this.setParentElement(topoEle);
    }

    public Set<UIElement> getChildUIElement() {
        return this.getChildElements();
    }

    @Override
    public void addUnStoredUIElement(String key, UIElement ele) {
        if (this.unStoredElements.get(key) != null) {
            this.unStoredElements.remove(key);
        }
        this.unStoredElements.put(key, ele);
    }

    @Override
    public void removeUnStoredUIElement(String key, UIElement ele) {
        this.unStoredElements.remove(key);
    }

    @Override
    public void restoreDefaultValues() {
        for (UIElement child : this.getChildElements()) {
            child.restoreDefaultValues();
        }
        this.unStoredElements.clear();
        this.existInLayout = false;
        this.authVisible = true;
    }

    @Override
    public Map<String, UIElement> getUnstoredUIElement() {
        return this.unStoredElements;
    }

    @Override
    public void addChildEle(UIElement ele) {
        if (ele.getParentElement() != null) {
            ele.getParentElement().getChildElements().remove(ele);
        }
        ele.setParentElement(this);
        this.getChildElements().add(ele);
    }

    protected void removeChildEles(UIElement ele) {
        Set<UIElement> childs = ele.getChildElements();
        for (UIElement child : childs) {
            this.removeChildEles(child);
        }
        ele.setParentElement(null);
        ele.getChildElements().clear();
    }

    public void removeChildEle() {
        this.removeChildEles(this);
    }

    public String toString() {
        StringBuilder val = new StringBuilder();
        this.toString(this, val);
        return val.toString();
    }

    protected void toString(UIElement ele, StringBuilder val) {
        val.append("+----").append(ele.getDisName()).append("----+\n");
        for (UIElement child : ele.getChildElements()) {
            this.toString(child, val);
        }
    }

    public UIElement clone() throws CloneNotSupportedException {
        Map<String, UIStyle> styleSet = this.getStyleSet();
        HashMap<String, UIStyle> cloneStyles = new HashMap<String, UIStyle>();
        for (Map.Entry<String, UIStyle> entry : styleSet.entrySet()) {
            UIStyle style = entry.getValue();
            cloneStyles.put(entry.getKey(), new UIStyle(style.getStyleName(), style.getStyleValue()));
        }
        UIElement cloneEle = (UIElement)super.clone();
        cloneEle.setStyleSet(cloneStyles);
        return cloneEle;
    }

    @Override
    public Set<UIElement> getChildEleUI() {
        return this.getChildElements();
    }

    @Override
    public boolean isExistInLayout() {
        return this.existInLayout;
    }

    @Override
    public void setIsExistInLayout(boolean bExist) {
        this.existInLayout = bExist;
    }

    @Override
    public boolean isAuthVisible() {
        return this.authVisible;
    }

    @Override
    public void setAuthVisible(boolean bVisible) {
        this.authVisible = bVisible;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public String getEleMainType() {
        return this.eleMainType;
    }

    public void setEleMainType(String eleMainType) {
        this.eleMainType = eleMainType;
    }

    public String getEleSubType() {
        return this.eleSubType;
    }

    public void setEleSubType(String eleSubType) {
        this.eleSubType = eleSubType;
    }

    public String getAppendixInfo() {
        return this.appendixInfo;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setAppendixInfo(String appendixInfo) {
        this.appendixInfo = appendixInfo;
    }

    public String getExtProp() {
        return this.extProp;
    }

    public void setExtProp(String extProp) {
        this.extProp = extProp;
    }

    public Long getEleType() {
        return this.eleType;
    }

    public void setEleType(Long eleType) {
        this.eleType = eleType;
    }

    @Override
    public boolean isChildEleUIExist(UIElement ele) {
        return this.getChildElements().contains(ele);
    }

    @Override
    public void removeChildEleUI(UIElement ele) {
        UIElement delEle = null;
        for (UIElement child : this.getChildElements()) {
            if (null == child || null == ele || null == child.getId() || !child.getId().equals(ele.getId())) continue;
            delEle = child;
        }
        this.getChildElements().remove(delEle);
        this.getChildElements().remove(ele);
        if (null != ele) {
            ele.setParentElement(null);
        }
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof UIElement)) {
            return false;
        }
        UIElement eleUI = (UIElement)obj;
        if (null == this.getId() || null == eleUI.getId()) {
            return false;
        }
        return this.getId().equals(eleUI.getId());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

