/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class AbstractStorageManager {
    private static Log logger = LogFactory.getInstance(AbstractStorageManager.class);

    protected List<Initiator> getArrayInitiators(String deviceId, HostVO hostVO) {
        List initiators = hostVO.getInitiators();
        if (null == initiators || initiators.isEmpty()) {
            logger.error((Object)("There is no initiator. DevSN:" + deviceId + ",HostSN:" + hostVO.getId() + ",IP:" + hostVO.getIpAddress() + ",Name:" + hostVO.getName()), 90160758784001L);
            throw new LegoCheckedException(1073948717L, new String[]{hostVO.getName()});
        }
        ArrayList<Initiator> arrayInitiatos = new ArrayList<Initiator>();
        for (Initiator initiator : initiators) {
            Initiator arrayInitiator = this.getArrayInitiatorFromDb(deviceId, initiator);
            if (null != arrayInitiator) {
                arrayInitiatos.add(arrayInitiator);
                continue;
            }
            logger.error((Object)("Array initiator does not exists. DevSN:" + deviceId + ",Identity:" + initiator.getIdentity() + ",HostIP:" + hostVO.getIpAddress()), 90160758784001L);
        }
        return arrayInitiatos;
    }

    protected ArrayHost getArrayHostByInitiator(Initiator initiator) {
        ArrayHost arrayHost = this.getArrayHostByUuid(initiator.getHostUUID());
        if (null != arrayHost) {
            ArrayList<Initiator> initiators = new ArrayList<Initiator>();
            initiators.add(initiator);
            arrayHost.setInitators(initiators);
            return arrayHost;
        }
        logger.error((Object)("Getting array host by initiator failed. Initiator:" + initiator.getIdentity()), 90160758784001L);
        return null;
    }

    protected ArrayHost getArrayHostByUuid(String uuid) {
        ManagedObject mObject = this.getMoDao().getMoByUuid(uuid, Boolean.valueOf(false));
        if (null != mObject) {
            return (ArrayHost)mObject;
        }
        return null;
    }

    protected ArrayHostGroup getArrayHostGroupByUuid(String uuid) {
        ManagedObject mObject = this.getMoDao().getMoByUuid(uuid, Boolean.valueOf(false));
        if (null != mObject) {
            return (ArrayHostGroup)mObject;
        }
        return null;
    }

    protected IMoDao getMoDao() {
        return CommonDAOLocator.getMoDao();
    }

    private XveMOType getXveInitiatorType(Initiator initiator) {
        XveMOType xveMOType = null;
        if (initiator.getHbaType().equals(DrmEnumDefine.InitiatorType.FC.getName())) {
            xveMOType = XveMOType.FC_INITIATOR;
        } else if (initiator.getHbaType().equals(DrmEnumDefine.InitiatorType.ISCSI.getName())) {
            xveMOType = XveMOType.ISCSI_INITIATOR;
        }
        return xveMOType;
    }

    private int getTv1InitiatorType(Initiator initiator) {
        int typeValue = -1;
        if (initiator.getHbaType().equals(DrmEnumDefine.InitiatorType.FC.getName())) {
            typeValue = 1;
        } else if (initiator.getHbaType().equals(DrmEnumDefine.InitiatorType.ISCSI.getName())) {
            typeValue = 5;
        }
        return typeValue;
    }

    private Initiator getArrayInitiatorFromDb(String deviceId, Initiator initiator) {
        Initiator arrayInitiator = this.getTv1Initiator(deviceId, initiator);
        if (null == arrayInitiator) {
            arrayInitiator = this.getXveInitiator(deviceId, initiator);
        }
        return arrayInitiator;
    }

    private Initiator getTv1Initiator(String deviceId, Initiator initiator) {
        int initiatorTypeValue = this.getTv1InitiatorType(initiator);
        if (-1 == initiatorTypeValue) {
            logger.error((Object)("The initiator type is not supported. Type:" + initiator.getHbaType() + ",Identity:" + initiator.getIdentity() + ", DevSN:" + deviceId), 90160758784001L);
            return null;
        }
        String initiatorUUID = deviceId + ":7:7:" + initiator.getIdentity() + ";" + initiatorTypeValue;
        ManagedObject mObject = this.getMoDao().getMoByUuid(initiatorUUID, Boolean.valueOf(false));
        if (null != mObject) {
            return (Initiator)mObject;
        }
        if (1 == initiatorTypeValue) {
            initiatorUUID = deviceId + ":7:7:" + String.valueOf(initiator.getIdentity()).toLowerCase(Locale.getDefault()) + ";" + initiatorTypeValue;
            mObject = this.getMoDao().getMoByUuid(initiatorUUID, Boolean.valueOf(false));
            if (null != mObject) {
                return (Initiator)mObject;
            }
            initiatorUUID = deviceId + ":7:7:" + String.valueOf(initiator.getIdentity()).toUpperCase(Locale.getDefault()) + ";" + initiatorTypeValue;
            mObject = this.getMoDao().getMoByUuid(initiatorUUID, Boolean.valueOf(false));
            if (null != mObject) {
                return (Initiator)mObject;
            }
        }
        return null;
    }

    private Initiator getXveInitiator(String deviceId, Initiator initiator) {
        XveMOType xveMOType = this.getXveInitiatorType(initiator);
        if (null == xveMOType) {
            logger.error((Object)("The initiator type is not supported. Type:" + initiator.getHbaType() + ",Identity:" + initiator.getIdentity() + ", DevSN:" + deviceId), 90160758784001L);
            return null;
        }
        String identityHashCode = String.valueOf(String.valueOf(initiator.getIdentity()).hashCode());
        String initiatorUUID = new XveUUID(deviceId, xveMOType, identityHashCode).toString();
        ManagedObject mObject = this.getMoDao().getMoByUuid(initiatorUUID, Boolean.valueOf(false));
        if (null != mObject) {
            return (Initiator)mObject;
        }
        if (XveMOType.FC_INITIATOR.equals((Object)xveMOType)) {
            identityHashCode = String.valueOf(String.valueOf(initiator.getIdentity()).toLowerCase(Locale.getDefault()).hashCode());
            initiatorUUID = new XveUUID(deviceId, xveMOType, identityHashCode).toString();
            mObject = this.getMoDao().getMoByUuid(initiatorUUID, Boolean.valueOf(false));
            if (null != mObject) {
                return (Initiator)mObject;
            }
            identityHashCode = String.valueOf(String.valueOf(initiator.getIdentity()).toUpperCase(Locale.getDefault()).hashCode());
            initiatorUUID = new XveUUID(deviceId, xveMOType, identityHashCode).toString();
            mObject = this.getMoDao().getMoByUuid(initiatorUUID, Boolean.valueOf(false));
            if (null != mObject) {
                return (Initiator)mObject;
            }
        }
        return null;
    }
}

