/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReprotectManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.util.ManagedObjectUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractStorageReprotectManager
implements IStorageReprotectManager {
    private static Log logger = LogFactory.getInstance(AbstractStorageReprotectManager.class);

    public void checkStorageReplication(String deviceId, List<String> resourceIds) {
        AbstractStorageReprotectManager.checkReplications(deviceId, resourceIds);
    }

    public static void checkReplications(String deviceId, List<String> resourceIds) {
        if (VerifyUtil.isEmpty((String)deviceId) || VerifyUtil.isEmpty(resourceIds)) {
            logger.error((Object)("Invalid parameters. DevId:" + deviceId), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        List replicationTargetLuns = DrmStorageUtil.getReplicationTargetLunsByDevId((String)deviceId);
        if (VerifyUtil.isEmpty((Collection)replicationTargetLuns)) {
            logger.error((Object)("There is no target luns. DevId:" + deviceId), 90160758784001L);
            throw new LegoCheckedException(1073948175L);
        }
        List replicationRelations = DrmStorageUtil.getReplicationRelations((String)deviceId, (int)0);
        if (VerifyUtil.isEmpty((Collection)replicationRelations)) {
            logger.error((Object)("There is no replications. DevId:" + deviceId), 90160758784001L);
            throw new LegoCheckedException(1073948175L);
        }
        HashSet<String> tgtResourceIds = new HashSet<String>();
        for (ReplicationTargetLun repTargetLun : replicationTargetLuns) {
            tgtResourceIds.add(repTargetLun.getTgtLunId());
        }
        HashSet<String> srcResourceIds = new HashSet<String>();
        for (ReplicationRelation replicationRelation : replicationRelations) {
            srcResourceIds.add(((ReplicationPair)replicationRelation).getSrcLunId());
        }
        for (String resourceId : resourceIds) {
            if (tgtResourceIds.contains(resourceId) || srcResourceIds.contains(resourceId)) continue;
            logger.error((Object)("The replication does not exist. DevId:" + deviceId + ",ResId:" + resourceId), 90160758784001L);
            throw new LegoCheckedException(1073948175L);
        }
    }

    public void refreshStorage(String deviceId) {
        logger.debug((Object)"begin to refresh Storage, deviceId= %s", new Object[]{deviceId});
        long startTime = System.currentTimeMillis();
        IMoDao moDao = CommonDAOLocator.getMoDao();
        StorageUnit storageUnit = (StorageUnit)moDao.getMo(StorageUnit.class, "devSn", (Object)deviceId);
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        List replicationPairs = proxy.getAllReplicationPairs(deviceId, null);
        ManagedObjectUtil.associate((Collection)replicationPairs, (ManagedObject)storageUnit, (boolean)false);
        List oldReplicationPairs = DrmStorageUtil.getReplicationPairs((String)deviceId);
        DrmStorageUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, (List)replicationPairs, (List)oldReplicationPairs);
        List<ManagedObject> newRepTargetLuns = this.retrieveAllReplicationTargetLuns(replicationPairs);
        for (ManagedObject mo : newRepTargetLuns) {
            mo.setTopMoUuid(storageUnit.getTopMoUuid());
        }
        List oldRepTargetLuns = DrmStorageUtil.getReplicationTargetLunsByDevId((String)deviceId);
        DrmStorageUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, newRepTargetLuns, (List)oldRepTargetLuns);
        List replicationGroups = proxy.getAllReplicationGroups(deviceId);
        ManagedObjectUtil.associate((Collection)replicationGroups, (ManagedObject)storageUnit, (boolean)false);
        this.setDrRingId(replicationGroups, replicationPairs);
        List oldReplicationGroups = DrmStorageUtil.getReplicationRelations((String)deviceId, (int)1);
        DrmStorageUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, (List)replicationGroups, (List)oldReplicationGroups);
        long endTime = System.currentTimeMillis();
        logger.info((Object)("refreshStorage cost:" + (endTime - startTime)));
    }

    private void setDrRingId(List<ReplicationGroup> replicationGroups, List<ReplicationPair> replicationPairs) {
        HashMap<String, String> gidVSRingIds = new HashMap<String, String>();
        for (ReplicationGroup replicationGroup : replicationGroups) {
            gidVSRingIds.put(replicationGroup.getReplicationId(), replicationGroup.getDrRingId());
        }
        replicationPairs = replicationPairs != null ? replicationPairs : new ArrayList();
        for (ReplicationPair pair : replicationPairs) {
            String grpId = pair.getConsistentGroupId();
            if (VerifyUtil.isEmpty((String)grpId) || grpId.startsWith("--")) continue;
            pair.setDrRingId((String)gidVSRingIds.get(grpId));
        }
    }

    protected List<ManagedObject> retrieveAllReplicationTargetLuns(List<ReplicationPair> replicationPairs) {
        ArrayList<ManagedObject> targetLuns = new ArrayList<ManagedObject>();
        if (!VerifyUtil.isEmpty(replicationPairs)) {
            for (ReplicationPair replicationPair : replicationPairs) {
                targetLuns.addAll(replicationPair.getChildMos());
            }
        }
        return targetLuns;
    }

    public void refreshVasaProtectGroupStorage(String deviceId, String consistencyGroupId) {
        logger.debug((Object)"begin to refresh vasa Storage, deviceId= %s", new Object[]{deviceId});
        long startTime = System.currentTimeMillis();
        IMoDao moDao = CommonDAOLocator.getMoDao();
        StorageUnit storageUnit = (StorageUnit)moDao.getMo(StorageUnit.class, "devSn", (Object)deviceId);
        ArrayList<ReplicationPair> existedPairs = new ArrayList<ReplicationPair>();
        ArrayList<ReplicationTargetLun> existedTargetLuns = new ArrayList<ReplicationTargetLun>();
        HashSet<String> existedLunIds = new HashSet<String>();
        this.constructExistedPairList(deviceId, consistencyGroupId, existedPairs, existedLunIds, existedTargetLuns);
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        List replicationPairs = proxy.queryReplicationPairByCgId(deviceId, consistencyGroupId);
        ManagedObjectUtil.associate((Collection)replicationPairs, (ManagedObject)storageUnit, (boolean)false);
        DrmStorageUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, (List)replicationPairs, existedPairs);
        List<ManagedObject> newRepTargetLuns = this.retrieveAllReplicationTargetLuns(replicationPairs);
        for (ManagedObject mo : newRepTargetLuns) {
            mo.setTopMoUuid(storageUnit.getTopMoUuid());
        }
        DrmStorageUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, newRepTargetLuns, existedTargetLuns);
        Set<String> newLunIds = replicationPairs.stream().map(pair -> pair.getIsPrimary() != false ? pair.getSrcLunId() : pair.getTgtLunId()).collect(Collectors.toSet());
        this.filterNewLunAndAddToDB(storageUnit, existedLunIds, newLunIds);
        ReplicationGroup replicationGroup = proxy.getReplicationGroup(deviceId, consistencyGroupId);
        ArrayList<ReplicationGroup> replicationGroups = new ArrayList<ReplicationGroup>();
        replicationGroups.add(replicationGroup);
        ManagedObjectUtil.associate(replicationGroups, (ManagedObject)storageUnit, (boolean)false);
        this.setDrRingId(replicationGroups, replicationPairs);
        List oldReplicationGroups = DrmStorageUtil.getReplicationRelationsByCgId((String)deviceId, (String)consistencyGroupId);
        DrmStorageUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, replicationGroups, (List)oldReplicationGroups);
        long endTime = System.currentTimeMillis();
        logger.info((Object)("refreshStorage cost:" + (endTime - startTime)));
    }

    private void filterNewLunAndAddToDB(StorageUnit storageUnit, Set<String> existedLunIds, Set<String> newLunIds) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", storageUnit.getDevSn());
        props.put("lunId", existedLunIds.toArray());
        IMoDao moDao = CommonDAOLocator.getMoDao();
        List existedLuns = moDao.findMoBy(Lun.class, props);
        if (VerifyUtil.isEmpty((Collection)existedLuns)) {
            return;
        }
        existedLuns.stream().map(Lun::getLunId).forEach(newLunIds::remove);
        logger.info((Object)"devSn=%s, new lun ids to add: ids=%s", new Object[]{storageUnit.getDevSn(), newLunIds});
        if (newLunIds.isEmpty()) {
            return;
        }
        IStorageLunManager storageLunMgr = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(storageUnit.getDevSn());
        List newLuns = storageLunMgr.queryLuns(storageUnit.getDevSn(), new ArrayList<String>(newLunIds));
        newLuns.forEach(lun -> lun.setTopMoUuid(storageUnit.getTopMoUuid()));
        DrmStorageUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, (List)newLuns, null);
    }

    private void constructExistedPairList(String deviceSn, String replicationGroupId, List<ReplicationPair> oldPairList, Set<String> oldLunIds, List<ReplicationTargetLun> oldTargetLuns) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", deviceSn);
        props.put("consistentGroupId", replicationGroupId);
        props.put("relationType", 0);
        List pairs = CommonDAOLocator.getMoDao().findMoBy(ReplicationPair.class, props);
        if (VerifyUtil.isEmpty((Collection)pairs)) {
            logger.error((Object)"pairs is empty, return");
            return;
        }
        for (ReplicationPair pair : pairs) {
            String replicationId = pair.getReplicationId();
            List targetLuns = DrmStorageUtil.getTargetLunsByReplicationId((String)deviceSn, (String)replicationId);
            oldTargetLuns.addAll(targetLuns);
            oldLunIds.add(pair.getIsPrimary() != false ? pair.getSrcLunId() : pair.getTgtLunId());
        }
        oldPairList.addAll(pairs);
        logger.info((Object)"constructExistedPairMap from DB oldPairList size=%s, oldTargetLuns size=%s, oldLunIds size=%s", new Object[]{String.valueOf(oldPairList.size()), String.valueOf(oldTargetLuns.size()), String.valueOf(oldLunIds.size())});
    }

    public void checkStorageRunningStatus(String deviceId, List<String> usedDrRingIds, String drStrategy) {
    }
}

