/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.observer;

import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.storage.protection.interceptor.IReplicaBuildInterceptorHandler;
import com.huawei.lego.core.sdk.base.ServiceContext;
import java.util.List;
import java.util.Map;

public class StorageProtectionScheduleObserver
implements IObjectObserver {
    public void before(MessageEvent event) {
        int messageType = event.getMessageType();
        if (12 != messageType && 13 != messageType) {
            return;
        }
        Map message = event.getMessageMap();
        Object protectGroupObject = message.get(ProtectGroup.class.getSimpleName());
        if (!(protectGroupObject instanceof ProtectGroup)) {
            return;
        }
        Object scheduleObject = message.get(Schedule.class.getSimpleName());
        if (!(scheduleObject instanceof Schedule)) {
            return;
        }
        ProtectGroup protectGroup = (ProtectGroup)protectGroupObject;
        Schedule schedule = (Schedule)scheduleObject;
        if (13 == messageType) {
            this.handleUpdateScheduleMessage(protectGroup, schedule);
        }
        if (12 == messageType) {
            this.handleAddScheduleMessage(protectGroup, schedule);
        }
    }

    public void after(MessageEvent event) {
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private void handleAddScheduleMessage(ProtectGroup protectGroup, Schedule schedule) {
        List handlerList = ServiceContext.getInstance().lookupBeans(IReplicaBuildInterceptorHandler.class);
        if (null != handlerList && !handlerList.isEmpty()) {
            handlerList.stream().forEach(handler -> handler.addSchedule(protectGroup, schedule));
        }
    }

    private void handleUpdateScheduleMessage(ProtectGroup protectGroup, Schedule schedule) {
        List handlerList = ServiceContext.getInstance().lookupBeans(IReplicaBuildInterceptorHandler.class);
        if (null != handlerList && !handlerList.isEmpty()) {
            handlerList.stream().forEach(handler -> handler.updateSchedule(protectGroup, schedule));
        }
    }
}

