/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.google.common.base.Joiner;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.protection.path.builder.CascadeAsyncAsyncProtectionPath;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Array4DCCascadeAsyncAsyncProtectionPath
extends CascadeAsyncAsyncProtectionPath {
    @Override
    protected String getSiteInfo(List<ProtectGroupReplica> replicalist, ExecutionContext context) {
        if (VerifyUtil.isEmpty(replicalist) || null == replicalist.get(0).getPg()) {
            return super.getSiteInfo(replicalist, context);
        }
        HashMap<String, String> devSnRepMap = new HashMap<String, String>();
        replicalist.stream().forEach(pgRep -> pgRep.getReplicas().stream().forEach(poRep -> poRep.getStorageInfos().stream().forEach(storageInfo -> devSnRepMap.put(storageInfo.getStorageProviderSN(), storageInfo.getSrcStorageProviderSN()))));
        ProtectGroup pg = replicalist.get(0).getPg();
        String siteInfoListStr = (String)pg.getProps().get("PROP_KEY_SITE_INFO");
        if (null != siteInfoListStr) {
            List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
            return this.get3DCSiteInfo(devSnRepMap, (SiteInfo)siteInfoList.get(0), (SiteInfo)siteInfoList.get(1), (SiteInfo)siteInfoList.get(2));
        }
        return super.getSiteInfo(replicalist, context);
    }

    protected String get3DCSiteInfo(Map<String, String> devSnRepMap, SiteInfo siteInfoA, SiteInfo siteInfoB, SiteInfo siteInfoC) {
        String infoA = this.getSiteInfoStr(devSnRepMap, siteInfoA, siteInfoB);
        String infoB = this.getSiteInfoStr(devSnRepMap, siteInfoB, siteInfoC);
        String infoC = this.getSiteInfoStr(devSnRepMap, siteInfoC, null);
        return Joiner.on((String)"-->").join(Arrays.asList(infoA, infoB, infoC));
    }

    protected String getSiteInfoStr(Map<String, String> devSnRepMap, SiteInfo siteInfo1, SiteInfo siteInfo2) {
        if (siteInfo1.getSiteIdSet().size() <= 1) {
            return this.getSiteById((String)siteInfo1.getSiteIdSet().stream().findFirst().get()).getName();
        }
        if (null == siteInfo2) {
            List siteNameList = siteInfo1.getSiteIdSet().stream().map(siteId -> this.getSiteById((String)siteId)).map(site -> site.getName()).collect(Collectors.toList());
            String info = Joiner.on((String)"--").join(siteNameList);
            return info;
        }
        ArrayList siteInfo1SnList = new ArrayList(siteInfo1.getDevSnSet());
        siteInfo2.getDevSnSet().stream().forEach(sn -> siteInfo1SnList.remove(devSnRepMap.get(sn)));
        siteInfo1.getDevSnSet().stream().forEach(sn -> {
            if (!siteInfo1SnList.contains(sn)) {
                siteInfo1SnList.add(sn);
            }
        });
        List siteNameList = siteInfo1SnList.stream().map(sn -> this.getSiteByStorageSn((String)sn)).map(site -> site.getName()).collect(Collectors.toList());
        String info = Joiner.on((String)"--").join(siteNameList);
        return info;
    }

    @Override
    protected RelicaStorageInfo[] getExist(List<RelicaStorageInfo[]> m, RelicaStorageInfo info) {
        RelicaStorageInfo[] result = null;
        for (RelicaStorageInfo[] each : m) {
            if (each == null || each.length < 2 || each[1] != null) continue;
            result = each;
            break;
        }
        return result;
    }

    @Override
    protected String getLunNameAndIp(boolean flag, String sn, String id, ExecutionContext context) {
        StorageResource storageResource = (StorageResource)this.getAllLuns(context).get(sn + id);
        String result = "";
        if (null != storageResource) {
            Lun lun = (Lun)storageResource;
            List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lun.getWwn()});
            Optional<StorageResource> optional = resources.stream().filter(res -> !res.getDevSn().equals(sn)).findFirst();
            StorageResource secondStorageResource = null;
            if (optional.isPresent()) {
                secondStorageResource = optional.get();
            }
            result = flag ? this.getResourceStr(secondStorageResource, storageResource) : this.getResourceStr(storageResource, secondStorageResource);
        } else {
            this.getBatchOperation(context).setErrorCode(1073948206L);
        }
        return result;
    }

    private String getResourceStr(StorageResource storageResource, StorageResource secondStorageResource) {
        String resourceIp;
        DrResource resource;
        String name;
        ArrayList<String> list = new ArrayList<String>();
        if (null != storageResource) {
            name = storageResource.getName();
            resource = this.getStorageBySn(storageResource.getDevSn());
            resourceIp = resource.getIpAddress();
            list.add(name + "(" + resourceIp + ")");
        }
        if (null != secondStorageResource) {
            name = secondStorageResource.getName();
            resource = this.getStorageBySn(secondStorageResource.getDevSn());
            resourceIp = resource.getIpAddress();
            list.add(name + "(" + resourceIp + ")");
        }
        return Joiner.on((String)"--").join(list);
    }

    @Override
    public int getPolicyTemplateType() {
        return 35;
    }
}

