/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.path.builder.ArrayHyperMetroAsyncProtectionPath;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayAsyncHyperMetroProtectionPath
extends ArrayHyperMetroAsyncProtectionPath {
    private static Log logger = LogFactory.getInstance(ArrayAsyncHyperMetroProtectionPath.class);

    @Override
    public ProtectionPathData buildPath(ProtectGroup protectgroup, Map<String, ? extends StorageResource> luns, BatchOperation batchOperation) {
        return super.buildPath(protectgroup, luns, batchOperation);
    }

    @Override
    protected String getRDPath(ProtectGroup protectGroup, ExecutionContext context) {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("pgName:" + protectGroup.getName());
        StringBuilder resourceProtectionPathStr = new StringBuilder();
        BatchOperation batchOperation = this.getBatchOperation(context);
        try {
            ProtectGroupReplica pgReplica = protectGroup.getAnyoneReplicationReplica();
            this.checkEmpty(pgReplica, "pgReplica is empty!" + errorMsg, batchOperation);
            Set poReplicaSet = pgReplica.getReplicas();
            this.checkEmpty(poReplicaSet, "poReplicaSet is empty!" + errorMsg, batchOperation);
            HashSet<String> lunIdSet = new HashSet<String>();
            for (ProtectObjectReplica poReplica : poReplicaSet) {
                Set storageInfoSet = poReplica.getStorageInfos();
                this.checkEmpty(storageInfoSet, "storageInfoSet is empty!" + errorMsg, batchOperation);
                for (RelicaStorageInfo storageInfoReplica : storageInfoSet) {
                    resourceProtectionPathStr.append(this.getSingleReplicaStorageInfoPath(storageInfoReplica, lunIdSet));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("getRDPath error.msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return resourceProtectionPathStr.toString();
    }

    private String getSingleReplicaStorageInfoPath(RelicaStorageInfo storageInfoReplica, Set<String> lunIdSet) {
        StringBuilder singleStorageInfoPath = new StringBuilder();
        String srcStorageId = storageInfoReplica.getSrcStorageId();
        if (lunIdSet.contains(srcStorageId)) {
            return "";
        }
        lunIdSet.add(srcStorageId);
        String srcStorageProviderSN = storageInfoReplica.getSrcStorageProviderSN();
        String storageId = storageInfoReplica.getStorageId();
        String storageProviderSN = storageInfoReplica.getStorageProviderSN();
        try {
            Lun srcLun = this.checkLunExsist(srcStorageProviderSN, srcStorageId);
            DrResource srcDrResource = this.getStorageBySn(srcStorageProviderSN);
            String srcDevIp = srcDrResource == null ? "" : srcDrResource.getIpAddress();
            singleStorageInfoPath.append(srcLun.getName()).append("(").append(srcDevIp).append(")");
            singleStorageInfoPath.append(" --> ");
            Lun targetLun = this.checkLunExsist(storageProviderSN, storageId);
            DrResource targetDrResource = this.getStorageBySn(storageProviderSN);
            String targetIp = targetDrResource == null ? "" : targetDrResource.getIpAddress();
            singleStorageInfoPath.append(targetLun.getName()).append("(").append(targetIp).append(")");
            singleStorageInfoPath.append(" -- ");
            String wwn = targetLun.getWwn();
            StorageResource otherStorageResource = this.getHyperMetroOtherStorageResource(storageProviderSN, this.getSiteByStorageSn(storageProviderSN), wwn);
            if (otherStorageResource == null) {
                singleStorageInfoPath.append("\n");
                return singleStorageInfoPath.toString();
            }
            DrResource otherDrResource = this.getStorageBySn(otherStorageResource.getDevSn());
            String otherIp = otherDrResource == null ? "" : otherDrResource.getIpAddress();
            singleStorageInfoPath.append(otherStorageResource.getName()).append("(").append(otherIp).append(")");
            singleStorageInfoPath.append(";\n");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("getSingleReplicaStorageInfoPath error!" + e.getMessage()), (Throwable)e);
        }
        return singleStorageInfoPath.toString();
    }

    @Override
    protected String getNasRDPath(ProtectGroup protectGroup, ExecutionContext context) {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("pgName:" + protectGroup.getName());
        Set replicaList = protectGroup.getReplicaList();
        StringBuilder resourceProtectionPathStr = new StringBuilder();
        BatchOperation batchOperation = this.getBatchOperation(context);
        try {
            String vStorePairId = this.getVstorePairIdByPg(protectGroup);
            if (VerifyUtil.isEmpty((String)vStorePairId)) {
                logger.error((Object)("protectGroup get vstorePairId is NULL. PGUUID:" + protectGroup.getUuid()));
                batchOperation.setErrorCode(2117645L);
                return "";
            }
            this.checkEmpty(replicaList, "replicaList is empty!" + errorMsg, batchOperation);
            ProtectGroupReplica pgReplica = (ProtectGroupReplica)CommonUtil.getFirstElement((Collection)replicaList);
            Set poReplicaSet = pgReplica.getReplicas();
            this.checkEmpty(poReplicaSet, "poReplicaSet is empty!" + errorMsg, batchOperation);
            String storageProviderSN = this.getVstoreHyperMetroSn(poReplicaSet);
            Map<String, String> snMap = this.getVstoreHyperPairList(vStorePairId, storageProviderSN, new HashMap<String, VstoreHyperMetroPair>());
            HashSet<String> nasIdSet = new HashSet<String>();
            for (ProtectObjectReplica poReplica : poReplicaSet) {
                Set storageInfoSet = poReplica.getStorageInfos();
                this.checkEmpty(storageInfoSet, "storageInfoSet is empty!" + errorMsg, batchOperation);
                for (RelicaStorageInfo storageInfoReplica : storageInfoSet) {
                    resourceProtectionPathStr.append(this.getNasSingleReplicaStorageInfoPath(storageInfoReplica, nasIdSet, snMap));
                }
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("runtimeException msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (Exception e) {
            logger.error((Object)("getRDPath error.msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return resourceProtectionPathStr.toString();
    }

    private String getNasSingleReplicaStorageInfoPath(RelicaStorageInfo storageInfoReplica, Set<String> nasIdSet, Map<String, String> snMap) {
        StringBuilder singleStorageInfoPath = new StringBuilder();
        String srcStorageId = storageInfoReplica.getSrcStorageId();
        if (nasIdSet.contains(srcStorageId)) {
            return "";
        }
        nasIdSet.add(srcStorageId);
        String srcStorageProviderSN = storageInfoReplica.getSrcStorageProviderSN();
        String storageId = storageInfoReplica.getStorageId();
        String storageProviderSN = storageInfoReplica.getStorageProviderSN();
        try {
            NasFileSystem srcFileSystem = this.checkNasExist(srcStorageProviderSN, srcStorageId);
            DrResource srcDrResource = this.getStorageBySn(srcStorageProviderSN);
            String srcDevIp = srcDrResource == null ? "" : srcDrResource.getIpAddress();
            singleStorageInfoPath.append(srcFileSystem.getName()).append("(").append(srcDevIp).append(")");
            singleStorageInfoPath.append(" --> ");
            NasFileSystem targetFileSystem = this.checkNasExist(storageProviderSN, storageId);
            DrResource targetDrResource = this.getStorageBySn(storageProviderSN);
            String targetIp = targetDrResource == null ? "" : targetDrResource.getIpAddress();
            singleStorageInfoPath.append(targetFileSystem.getName()).append("(").append(targetIp).append(")");
            singleStorageInfoPath.append(" -- ");
            ArrayList<String> wwns = new ArrayList<String>();
            wwns.add(storageId);
            String otherSn = snMap.get(storageProviderSN);
            List<NasFileSystem> otherNasFileList = this.getHyperMetroOtherSiteNasFileSystemList(storageProviderSN, otherSn, wwns);
            NasFileSystem otherNasFile = (NasFileSystem)CommonUtil.getFirstElement(otherNasFileList);
            DrResource otherDrResource = this.getStorageBySn(otherSn);
            String otherIp = otherDrResource == null ? "" : otherDrResource.getIpAddress();
            singleStorageInfoPath.append(otherNasFile.getName()).append("(").append(otherIp).append(")");
            singleStorageInfoPath.append(";\n");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("getSingleReplicaStorageInfoPath error!" + e.getMessage()), (Throwable)e);
        }
        return singleStorageInfoPath.toString();
    }

    private List<NasFileSystem> getHyperMetroOtherSiteNasFileSystemList(String srcDevSn, String otherDevSn, List<String> ids) {
        Site site = this.getSiteByStorageSn(srcDevSn);
        if (null == site) {
            logger.error((Object)("site is null, devSn: " + srcDevSn));
            throw new LegoCheckedException(1073947393L);
        }
        List hyperMetroPairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByFileSystemIds(site.getServerUuid(), srcDevSn, ids, null, false);
        this.checkEmpty(hyperMetroPairList, "hyperMetroPairList getHyperMetroOtherSiteNasFileSystemList");
        ArrayList<String> otherSiteIds = new ArrayList<String>();
        for (HyperMetroPair hyperMetroPair : hyperMetroPairList) {
            otherSiteIds.add(hyperMetroPair.getRemoteObjId());
        }
        return StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(otherDevSn, otherSiteIds, NasFileSystem.class);
    }

    private String getVstoreHyperMetroSn(Set<ProtectObjectReplica> poReplicaSet) {
        for (ProtectObjectReplica poReplica : poReplicaSet) {
            Set storageInfoSet = poReplica.getStorageInfos();
            this.checkEmpty(storageInfoSet, "storageInfoSet is empty!");
            Iterator iterator = storageInfoSet.iterator();
            if (!iterator.hasNext()) continue;
            RelicaStorageInfo storageInfoReplica = (RelicaStorageInfo)iterator.next();
            return storageInfoReplica.getStorageProviderSN();
        }
        logger.error((Object)"poReplicaSet is null");
        throw new LegoCheckedException(1073947393L);
    }

    @Override
    protected String getSiteRelationStr(ProtectGroup protectgroup, ExecutionContext context) {
        StringBuilder siteRelationStr = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("pgname:" + protectgroup.getName());
        try {
            BatchOperation batchOperation = this.getBatchOperation(context);
            ProtectObjectStorageInfo posi = this.randomSelectPOStorageInfo(protectgroup, batchOperation);
            String srcResourceProviderSN = posi.getResourceProviderSN();
            String srcResourceId = posi.getResourceId();
            Site srcSite = this.getSiteByStorageSn(srcResourceProviderSN);
            siteRelationStr.append(srcSite == null ? "" : srcSite.getName());
            siteRelationStr.append(" --> ");
            Lun lun = this.checkLunExsist(srcResourceProviderSN, srcResourceId);
            List<ReplicationPair> pairs = this.getPairsByLun(lun, false);
            if (VerifyUtil.isEmpty(pairs)) {
                logger.error((Object)("the pairs is empty! resourceId:" + srcResourceId + ", providerSN:" + srcResourceProviderSN));
                return siteRelationStr.toString();
            }
            ReplicationPair pair = pairs.iterator().next();
            List repTgtLuns = pair.getRepTgtLuns();
            if (repTgtLuns == null || repTgtLuns.isEmpty()) {
                logger.error((Object)("the repTgtLuns is empty! resourceId:" + srcResourceId + ", providerSN:" + srcResourceProviderSN));
                return siteRelationStr.toString();
            }
            ReplicationTargetLun replicationTargetLun = (ReplicationTargetLun)repTgtLuns.iterator().next();
            String targetDevSn = replicationTargetLun.getTgtDevSN();
            Site targetSite = this.getSiteByStorageSn(targetDevSn);
            siteRelationStr.append(targetSite == null ? "" : targetSite.getName());
            siteRelationStr.append(" -- ");
            Lun targetLun = this.checkLunExsist(targetDevSn, replicationTargetLun.getTgtLunId());
            if (null == targetLun) {
                return siteRelationStr.toString();
            }
            String wwn = targetLun.getWwn();
            StorageResource otherStorageResource = this.getHyperMetroOtherStorageResource(targetDevSn, targetSite, wwn);
            if (otherStorageResource == null) {
                return siteRelationStr.toString();
            }
            Site otherSite = this.getSiteByStorageSn(otherStorageResource.getDevSn());
            siteRelationStr.append(otherSite == null ? "" : otherSite.getName());
        }
        catch (Exception e) {
            logger.error((Object)("getSiteRelationStr error.msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return siteRelationStr.toString();
    }

    protected StorageResource getHyperMetroOtherStorageResource(String targetDevSn, Site targetSite, String wwn) {
        List lunList;
        ArrayList<String> allWwnList = new ArrayList<String>();
        allWwnList.add(wwn);
        String serverId = null;
        if (targetSite != null) {
            serverId = targetSite.getServerUuid();
        }
        if (VerifyUtil.isEmpty((Collection)(lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByWwns(serverId, allWwnList, Lun.class))) || lunList.size() != 2) {
            logger.error((Object)"storageResources is empty or storageResources size is not two!");
            return null;
        }
        Iterator storageResourceIterator = lunList.iterator();
        StorageResource storageResource = (StorageResource)storageResourceIterator.next();
        StorageResource otherStorageResource = !targetDevSn.equals(storageResource.getDevSn()) ? storageResource : (StorageResource)storageResourceIterator.next();
        return otherStorageResource;
    }

    protected ProtectObjectStorageInfo randomSelectPOStorageInfo(ProtectGroup protectGroup, BatchOperation batchOperation) {
        Set polist = protectGroup.getPolist();
        this.checkEmpty(polist, "polist is empty! pgName : " + protectGroup.getName(), batchOperation);
        ProtectObject po = (ProtectObject)polist.iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        this.checkEmpty(usedStorageResourceSet, "usedStorageResourceSet is empty! pgName : " + protectGroup.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName(), batchOperation);
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        return posi;
    }

    @Override
    protected String getNasSiteRelationStr(ProtectGroup protectgroup, ExecutionContext context) {
        StringBuilder siteRelationStr = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("pgname:" + protectgroup.getName());
        try {
            BatchOperation batchOperation = this.getBatchOperation(context);
            ProtectObjectStorageInfo posi = this.randomSelectPOStorageInfo(protectgroup, batchOperation);
            String srcResourceProviderSN = posi.getResourceProviderSN();
            String srcResourceId = posi.getResourceId();
            Site srcSite = this.getSiteByStorageSn(srcResourceProviderSN);
            siteRelationStr.append(srcSite == null ? "" : srcSite.getName());
            siteRelationStr.append(" --> ");
            List<ReplicationPair> pairs = this.getPairsByNas(srcResourceProviderSN, srcResourceId);
            if (VerifyUtil.isEmpty(pairs)) {
                logger.error((Object)("the pairs is empty! resourceId:" + srcResourceId + ", providerSN:" + srcResourceProviderSN));
                return siteRelationStr.toString();
            }
            ReplicationPair pair = (ReplicationPair)CommonUtil.getFirstElement(pairs);
            List repTgtLuns = pair.getRepTgtLuns();
            if (repTgtLuns == null || repTgtLuns.isEmpty()) {
                logger.error((Object)("the repTgtLuns is empty! resourceId:" + srcResourceId + ", providerSN:" + srcResourceProviderSN));
                return siteRelationStr.toString();
            }
            ReplicationTargetLun replicationTargetLun = (ReplicationTargetLun)CommonUtil.getFirstElement((Collection)repTgtLuns);
            String targetDevSn = replicationTargetLun.getTgtDevSN();
            Site targetSite = this.getSiteByStorageSn(targetDevSn);
            siteRelationStr.append(targetSite == null ? "" : targetSite.getName());
            siteRelationStr.append(" -- ");
            String vStorePairId = this.getVstorePairIdByPg(protectgroup);
            if (VerifyUtil.isEmpty((String)vStorePairId)) {
                logger.error((Object)("protectGroup get vstorePairId is NULL. PGUUID:" + protectgroup.getUuid()));
                batchOperation.setErrorCode(2117645L);
                return "";
            }
            Map<String, String> snMap = this.getVstoreHyperPairList(vStorePairId, targetDevSn, new HashMap<String, VstoreHyperMetroPair>());
            String otherSn = snMap.get(targetDevSn);
            Site otherSite = this.getSiteByStorageSn(otherSn);
            siteRelationStr.append(otherSite == null ? "" : otherSite.getName());
        }
        catch (RuntimeException e) {
            logger.error((Object)("runtimeException msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (Exception e) {
            logger.error((Object)("getSiteRelationStr error.msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return siteRelationStr.toString();
    }

    @Override
    public int getPolicyTemplateType() {
        return 20;
    }
}

