/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.path.builder.ArrayHyperMetroAsyncProtectionPath;
import com.huawei.ism.drm.storage.protection.util.HyperDRRingPathUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.List;

public class ArrayHyperMetroAsyncRingProtectionPath
extends ArrayHyperMetroAsyncProtectionPath {
    private static Log logger = LogFactory.getInstance(ArrayHyperMetroAsyncRingProtectionPath.class);
    private static final String SRC_DEVICE_SN = "SRC_DEVICE_SN";

    @Override
    public int getPolicyTemplateType() {
        logger.debug((Object)"PolicyTemplateType:ArrayHyperMetroAsyncRingProtectionPath");
        return 26;
    }

    @Override
    protected String getSiteRelationStr(ProtectGroup protectgroup, ExecutionContext context) {
        StringBuilder siteRelationStr = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder("pgname:" + protectgroup.getName());
        try {
            BatchOperation batchOperation = this.getBatchOperation(context);
            String lunWWN = this.randomSelectALunwwn(protectgroup, batchOperation);
            List<StorageResource> storageResources = this.queryStorageResource(lunWWN);
            StorageResource srcStorageResource = null;
            StorageResource otherStorageResource = null;
            ArrayList<ReplicationPair> pairs = new ArrayList<ReplicationPair>();
            for (StorageResource res : storageResources) {
                Lun lun = this.checkLunExsist(res.getDevSn(), res.getResourceId());
                List<ReplicationPair> pairList = this.getPairsByLun(lun, true);
                ReplicationPair pair = HyperDRRingPathUtil.getTarReplicationPair(pairList, false);
                if (!VerifyUtil.isEmpty(pairList) && pairList.size() == 1 && !VerifyUtil.isEmpty((Object)pair)) {
                    this.checkEmpty(res.getDevSn(), "devSn is empty!errorMsg:" + errorMsg);
                    pairs.addAll(pairList);
                    srcStorageResource = res;
                    continue;
                }
                pairs.addAll(pairList);
                otherStorageResource = res;
            }
            this.checkEmpty(otherStorageResource, "otherStorageResource is null! errorMsg:" + errorMsg, batchOperation);
            Site otherSite = this.getSiteByDeviceSN(otherStorageResource.getDevSn());
            siteRelationStr.append(otherSite == null ? "" : otherSite.getName()).append(" -- ");
            context.setAttribute(SRC_DEVICE_SN, (Object)(srcStorageResource != null ? srcStorageResource.getDevSn() : ""));
            this.checkEmpty(srcStorageResource, "otherStorageResource is null! errorMsg:" + errorMsg, batchOperation);
            Site srcSite = this.getSiteByDeviceSN(srcStorageResource != null ? srcStorageResource.getDevSn() : "");
            siteRelationStr.append(srcSite == null ? "" : srcSite.getName()).append(" -(normal)-> ");
            this.checkEmpty(pairs, errorMsg.toString());
            ReplicationPair tarPair = HyperDRRingPathUtil.getTarReplicationPair(pairs, false);
            this.checkEmpty(tarPair, errorMsg.toString());
            List tarLuns = tarPair.getRepTgtLuns();
            this.checkEmpty(tarLuns, "devSn is empty!errorMsg:" + errorMsg);
            ReplicationTargetLun tarLun = (ReplicationTargetLun)tarLuns.iterator().next();
            Site targetSite = this.getSiteByDeviceSN(tarLun.getTgtDevSN());
            siteRelationStr.append(targetSite == null ? "" : targetSite.getName()).append("\n");
            ReplicationPair standPair = HyperDRRingPathUtil.getTarReplicationPair(pairs, true);
            this.checkEmpty(standPair, errorMsg.toString());
            List standLuns = tarPair.getRepTgtLuns();
            this.checkEmpty(standLuns, "devSn is empty!errorMsg:" + errorMsg);
            Site product = this.getSiteByStorageSn(standPair.getDevSn());
            ReplicationTargetLun standLun = (ReplicationTargetLun)standLuns.iterator().next();
            Site recovery = this.getSiteByStorageSn(standLun.getTgtDevSN());
            siteRelationStr.append(product == null ? "" : product.getName()).append(" -(standby)-> ").append(recovery == null ? "" : recovery.getName());
        }
        catch (RuntimeException e) {
            logger.error((Object)("runtimeException msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (Exception e) {
            logger.error((Object)("getSiteRelationStr error.msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return siteRelationStr.toString();
    }
}

