/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.path.AbstractProtectionPathImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperVaultProtectionPath
extends AbstractProtectionPathImpl {
    protected static final String REMOTE_REPLICA = "REMOTE_REPLICA";
    private static Log logger = LogFactory.getInstance(ArrayHyperVaultProtectionPath.class);
    private static final String HYPERVAULTKEY = "HYPER_VAULT";

    public ProtectionPathData buildPath(ProtectGroup protectgroup, Map<String, ? extends StorageResource> luns, BatchOperation batchOperation) {
        ProtectionPath storageResPath;
        ProtectionPath sitePath;
        ExecutionContext context = this.init(luns, batchOperation);
        try {
            this.initData(context, protectgroup);
            sitePath = this.buildSitePath(protectgroup, context);
            storageResPath = this.buildStorageResPath(protectgroup, context);
        }
        catch (LegoCheckedException e) {
            ArrayList<String> sitePathDetails = new ArrayList<String>();
            sitePathDetails.add("");
            sitePath = new ProtectionPath();
            storageResPath = new ProtectionPath();
            sitePath.setPathDetails(sitePathDetails);
            storageResPath.setPathDetails(sitePathDetails);
            logger.error((Object)"ArrayHyperVaultProtectionPath error!", (Throwable)e);
        }
        return this.buildProtectionPath(sitePath, storageResPath, context, protectgroup);
    }

    protected void initData(ExecutionContext context, ProtectGroup protectgroup) {
        ProtectObjectStorageInfo storageInfo = this.getStorageInfo(protectgroup);
        long startTime = System.currentTimeMillis();
        HyperVault hyperVault = this.getHyperVaultMgr(storageInfo.getResourceProviderSN()).queryHyperVaultByResourceId(storageInfo.getResourceProviderSN(), storageInfo.getResourceId());
        logger.debug((Object)("realtime to query hyper vault cost time:" + (System.currentTimeMillis() - startTime)));
        context.setAttribute(HYPERVAULTKEY, (Object)hyperVault);
    }

    protected void initData0(ExecutionContext context, ProtectGroup protectGroup) {
        Set replicaSet = protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)replicaSet)) {
            logger.error((Object)"Remote replicas not exists.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupReplica remoteReplica = null;
        for (ProtectGroupReplica replica : replicaSet) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica)) continue;
            remoteReplica = replica;
        }
        if (VerifyUtil.isEmpty(remoteReplica)) {
            logger.error((Object)"Remote replicas not exists.");
            throw new LegoCheckedException(1073947393L);
        }
        context.setAttribute("STORAGE_RESOURCES_KEY", this.getAllStorageResources(remoteReplica));
        context.setAttribute(REMOTE_REPLICA, (Object)remoteReplica);
    }

    private Map<String, StorageResource> getAllStorageResources(ProtectGroupReplica replica) {
        ArrayList<String> srcResources = new ArrayList<String>();
        ArrayList<String> tgtResources = new ArrayList<String>();
        for (ProtectObjectReplica por : replica.getReplicas()) {
            for (RelicaStorageInfo rsi : por.getStorageInfos()) {
                srcResources.add(rsi.getSrcStorageId());
                tgtResources.add(rsi.getStorageId());
            }
        }
        ArrayList allResources = new ArrayList();
        DrmEnumDefine.RESOURCE_TYPE_E resourceType = this.getResourceTypeByPgReplica(replica);
        logger.info((Object)"Resource type is %s", new Object[]{resourceType});
        allResources.addAll(this.getStorageService().getStorageResources(replica.getProductArray(), srcResources, resourceType));
        allResources.addAll(this.getStorageService().getStorageResources(replica.getRecoveryArray(), tgtResources, resourceType));
        HashMap<String, StorageResource> map = new HashMap<String, StorageResource>();
        for (StorageResource storageResource : allResources) {
            map.put(storageResource.getDevSn() + storageResource.getResourceId(), storageResource);
        }
        return map;
    }

    protected List<String> getProductLunNamesAndIp(ProtectObjectReplica protectObjectReplica, Map<String, String> proLunInfo, ExecutionContext context) {
        return this.getProductResourceNamesAndIp(protectObjectReplica, proLunInfo);
    }

    private List<String> getProductResourceNamesAndIp(ProtectObjectReplica protectObjectReplica, Map<String, String> productResourceInfo) {
        ArrayList<String> tgtLunIds = new ArrayList<String>();
        String tgtDevSn = null;
        ProtectGroupReplica replica = protectObjectReplica.getPgReplica();
        for (ProtectObjectReplica por : replica.getReplicas()) {
            for (RelicaStorageInfo rsi : por.getStorageInfos()) {
                tgtLunIds.add(rsi.getStorageId());
                tgtDevSn = rsi.getStorageProviderSN();
            }
        }
        ArrayList<String> listRsInfoId = new ArrayList<String>();
        DrmEnumDefine.RESOURCE_TYPE_E resourceType = this.getResourceTypeByPgReplica(replica);
        if (!VerifyUtil.isEmpty(tgtDevSn)) {
            List pairs = this.getStorageService().getReplicationPairsByResourceIds(tgtDevSn, tgtLunIds, false, Integer.valueOf(resourceType.getValue()));
            for (RelicaStorageInfo relicastorageinfo : protectObjectReplica.getStorageInfos()) {
                String srcLunName = this.getSrcResourceName(pairs, relicastorageinfo.getSrcStorageId());
                String ipAddress = "UNKNOWN";
                String result = srcLunName + "(" + ipAddress + ")";
                productResourceInfo.put(relicastorageinfo.getId(), result);
                listRsInfoId.add(relicastorageinfo.getId());
            }
        }
        return listRsInfoId;
    }

    private String getSrcResourceName(List<ReplicationPair> pairs, String srcStorageId) {
        for (ReplicationPair pair : pairs) {
            if (!pair.getSrcLunId().equals(srcStorageId)) continue;
            return pair.getSrcLunName();
        }
        return "";
    }

    private IStorageHyperVaultManager getHyperVaultMgr(String devSn) {
        IStorageHyperVaultManager service = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(devSn);
        if (service == null) {
            logger.error((Object)("to get the IStorageHyperVaultManager failed! devSn:" + devSn));
            throw new LegoCheckedException(-1L);
        }
        return service;
    }

    private ProtectObjectStorageInfo getStorageInfo(ProtectGroup protectGroup) {
        Set protectObjectSet = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)protectObjectSet)) {
            logger.error((Object)"protectObjectSet is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject po = (ProtectObject)protectObjectSet.iterator().next();
        Set resourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)resourceSet)) {
            logger.error((Object)"resourceSet is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo poStorageInfo = (ProtectObjectStorageInfo)resourceSet.iterator().next();
        return poStorageInfo;
    }

    private ProtectionPath buildSitePath(ProtectGroup protectgroup, ExecutionContext context) {
        String pgMsg = this.getPgMsg(protectgroup);
        logger.debug((Object)("start build site protection path..." + pgMsg));
        ProtectionPath siteProtectionPath = new ProtectionPath();
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        sitePathDetails.add(this.getSiteRelation(context));
        siteProtectionPath.setPathDetails(sitePathDetails);
        logger.debug((Object)("end build site protection path..." + pgMsg));
        return siteProtectionPath;
    }

    private String getPgMsg(ProtectGroup protectgroup) {
        return " pgName:" + protectgroup.getName() + ", pgId:" + protectgroup.getUuid();
    }

    private ProtectionPath buildStorageResPath(ProtectGroup protectgroup, ExecutionContext context) {
        logger.debug((Object)("start build storage resource protection path...pg name:" + protectgroup.getName()));
        ProtectionPath protectionpath = new ProtectionPath();
        ArrayList<String> rdPathDetailList = new ArrayList<String>();
        rdPathDetailList.add(this.getRDPath(context));
        protectionpath.setPathDetails(rdPathDetailList);
        logger.debug((Object)"end build storage resource protection path...");
        return protectionpath;
    }

    protected String getRDPath(ExecutionContext context) {
        StringBuilder rdPathStr = new StringBuilder();
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPERVAULTKEY, HyperVault.class);
        if (hyperVault == null) {
            logger.error((Object)"hyperVault is empty!");
            return "";
        }
        String localDevSn = hyperVault.getDevSn();
        String localResourceId = hyperVault.getLocalResourceId();
        String remoteDeviceSn = hyperVault.getRemoteDeviceSn();
        String remoteResourceId = hyperVault.getRemoteResourceId();
        this.appendResourceInfo(rdPathStr, localDevSn, localResourceId);
        rdPathStr.append(" --> ");
        this.appendResourceInfo(rdPathStr, remoteDeviceSn, remoteResourceId);
        return rdPathStr.toString();
    }

    protected String getRDPath0(ExecutionContext context) {
        HashMap<String, String> proLunInfo = new HashMap<String, String>();
        HashMap recoveryLunInfo = new HashMap();
        StringBuffer sb = new StringBuffer();
        ProtectGroupReplica replica = (ProtectGroupReplica)context.getAttribute(REMOTE_REPLICA, ProtectGroupReplica.class);
        HashSet pathSet = new HashSet();
        for (ProtectObjectReplica por : replica.getReplicas()) {
            this.getTargetLunNamesAndIp(por, recoveryLunInfo, context);
            List<String> list = this.getProductLunNamesAndIp(por, proLunInfo, context);
            this.getResult(list, sb, proLunInfo, recoveryLunInfo, pathSet);
        }
        return sb.toString();
    }

    private void appendResourceInfo(StringBuilder rdPathStr, String localDevSn, String localResourceId) {
        DrResource drResource = this.getStorageBySn(localDevSn);
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        rdPathStr.append(this.getResourceName(storageResourceService, localDevSn, localResourceId)).append("(").append(this.getIp(drResource)).append(")");
    }

    private String getResourceName(IStorageResourceService storageResourceService, String providerSN, String resourceId) {
        if (storageResourceService == null) {
            logger.error((Object)"storageResourceService is null!");
            return "";
        }
        StorageResource storageResource = storageResourceService.getStorageResource(providerSN, resourceId, StorageResource.class);
        if (storageResource == null) {
            logger.error((Object)"storageResource is null!");
            return "";
        }
        return storageResource.getName();
    }

    private String getIp(DrResource drResource) {
        if (drResource != null) {
            return drResource.getIpAddress();
        }
        logger.error((Object)"drResource is null!");
        return "";
    }

    protected String getSiteRelation(ExecutionContext context) {
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPERVAULTKEY, HyperVault.class);
        if (hyperVault == null) {
            logger.error((Object)"hyperVault is empty!");
            return "";
        }
        String localDevSn = hyperVault.getDevSn();
        String remoteDevSn = hyperVault.getRemoteDeviceSn();
        return this.getSiteRelation(localDevSn, remoteDevSn);
    }

    protected String getSiteRelation(String localDevSn, String remoteDevSn) {
        StringBuilder siteRelationStr = new StringBuilder();
        Site localSite = this.getSiteByStorageSn(localDevSn);
        Site remoteSite = this.getSiteByStorageSn(remoteDevSn);
        siteRelationStr.append(localSite != null ? localSite.getName() : "");
        siteRelationStr.append(" --> ");
        siteRelationStr.append(remoteSite != null ? remoteSite.getName() : "");
        return siteRelationStr.toString();
    }

    private ProtectionPathData buildProtectionPath(ProtectionPath siteProtectionPath, ProtectionPath storageResProtectionPath, ExecutionContext context, ProtectGroup protectgroup) {
        ArrayList<ProtectionPath> protectionPathList = new ArrayList<ProtectionPath>();
        protectionPathList.add(siteProtectionPath);
        protectionPathList.add(storageResProtectionPath);
        ProtectionPathData protectionPathData = new ProtectionPathData(protectionPathList);
        BatchOperation batchOperation = this.getBatchOperation(context);
        if (batchOperation.getErrorCode() != 0L) {
            batchOperation.setTargetName(protectgroup.getName());
            protectionPathData.setOperation(batchOperation);
        }
        return protectionPathData;
    }

    public int getPolicyTemplateType() {
        return 17;
    }
}

