/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.Array4DCCascadeSyncAsyncVaultBuilder;
import com.huawei.ism.drm.storage.protection.replica.builder.Array4DCConcurrentSyncAsyncBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Array4DCConcurrentSyncAsyncVaultBuilder
extends Array4DCCascadeSyncAsyncVaultBuilder {
    private Array4DCConcurrentSyncAsyncBuilder array4DCConcurrentSyncAsyncBuilder;

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        this.buildReplica(protectGroup, (IReplicaBuilder)this.array4DCConcurrentSyncAsyncBuilder);
    }

    @Override
    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        return super.beforeDeleteProtectGroup(protectGroup);
    }

    public Array4DCConcurrentSyncAsyncBuilder getArray4DCConcurrentSyncAsyncBuilder() {
        return this.array4DCConcurrentSyncAsyncBuilder;
    }

    public void setArray4DCConcurrentSyncAsyncBuilder(Array4DCConcurrentSyncAsyncBuilder array4DCConcurrentSyncAsyncBuilder) {
        this.array4DCConcurrentSyncAsyncBuilder = array4DCConcurrentSyncAsyncBuilder;
    }

    @Override
    public int getType() {
        return 41;
    }

    @Override
    public Map<Integer, String> getProtectedDeviceSn(ProtectGroup protectGroup) {
        ProtectGroupReplica replicaAToB = Array4DCConcurrentSyncAsyncVaultBuilder.getPgReplicaByLocation(protectGroup, DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue());
        ProtectGroupReplica replicaAToC = Array4DCConcurrentSyncAsyncVaultBuilder.getPgReplicaByLocation(protectGroup, DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue());
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue(), replicaAToB.getProductArray());
        result.put(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), replicaAToB.getRecoveryArray());
        result.put(DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue(), replicaAToC.getRecoveryArray());
        if (this.checkIfProductSiteIsHyperMetroSite(protectGroup)) {
            result.put(DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue(), replicaAToC.getProductArray());
        } else {
            ProtectObjectReplica poReplica = (ProtectObjectReplica)replicaAToB.getReplicas().iterator().next();
            RelicaStorageInfo storageInfo = (RelicaStorageInfo)poReplica.getStorageInfos().iterator().next();
            String resourceId = storageInfo.getStorageId();
            IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
            Lun lun = storageService.getLunBySnAndLunId(storageInfo.getStorageProviderSN(), resourceId);
            if (VerifyUtil.isEmpty((Object)lun)) {
                throw new LegoCheckedException(2117645L, "Not find lun, lunId=" + resourceId);
            }
            List allStorageResources = storageService.getStorageResourceByWwn(new String[]{lun.getWwn()});
            for (StorageResource resource : allStorageResources) {
                if (result.containsValue(resource.getDevSn())) continue;
                result.put(DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue(), resource.getDevSn());
                break;
            }
        }
        return result;
    }

    @Override
    public Map<String, List<ProtectObjectStorageInfo>> getAllStroageInfo(ProtectGroup protectGroup) {
        return super.getAllStroageInfo(protectGroup);
    }

    @Override
    protected void setReplicaInfoToStorageMap(ProtectGroup protectGroup, Map<String, ProtectObjectStorageInfo> storageInfoMap, Map<String, List<ProtectObjectStorageInfo>> map) {
        ProtectGroupReplica replicaAToB = Array4DCConcurrentSyncAsyncVaultBuilder.getPgReplicaByLocation(protectGroup, DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue());
        ProtectGroupReplica replicaAToC = Array4DCConcurrentSyncAsyncVaultBuilder.getPgReplicaByLocation(protectGroup, DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue());
        this.putStorageInfo(replicaAToB, map, storageInfoMap);
        this.putStorageInfo(replicaAToC, map, storageInfoMap);
    }
}

