/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySyncReplicationBuilder;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ArrayAsyncReplicationBuilder
extends ArraySyncReplicationBuilder {
    private static final Log logger = LogFactory.getInstance(ArrayAsyncReplicationBuilder.class);
    private static final String EXISTLUN = "existLun";
    private static final String EXISTNAS = "existNas";

    @Override
    public int getType() {
        return 1;
    }

    @Override
    protected int getReplicationType() {
        return 2;
    }

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        this.getBuilderContext().clear();
        super.buildReplica(protectGroup);
    }

    @Override
    protected void generatePosi(int protectLocation, ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, ProtectGroupReplica protectGroupReplica, ExecutionContext context) {
        int resourcetype = this.getResourcetype(protectObject.getUsedStorageResourceSet());
        if (resourcetype == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
            for (ProtectObjectStorageInfo posi : protectObject.getUsedStorageResourceSet()) {
                NasFileSystem nasMo = this.checkNasExsist(posi.getResourceProviderSN(), posi.getResourceId());
                this.generatePosiByNas(2, protectObjectReplica, protectGroupReplica, posi, nasMo);
            }
            this.getBuilderContext().put(EXISTNAS, EXISTNAS);
        } else {
            for (ProtectObjectStorageInfo posi : protectObject.getUsedStorageResourceSet()) {
                Lun lunMo = new Lun();
                lunMo.setLunId(posi.getResourceId());
                lunMo.setDevSn(posi.getResourceProviderSN());
                this.generatePosiByLun(2, protectObjectReplica, protectGroupReplica, posi, lunMo, context);
            }
            this.getBuilderContext().put(EXISTLUN, EXISTLUN);
        }
    }

    protected int getResourcetype(Set<ProtectObjectStorageInfo> allStorageInfo) {
        int type;
        block0: {
            type = 1;
            Iterator<ProtectObjectStorageInfo> iterator = allStorageInfo.iterator();
            if (!iterator.hasNext()) break block0;
            ProtectObjectStorageInfo posi = iterator.next();
            type = posi.getResourceType();
        }
        return type;
    }

    protected NasFileSystem checkNasExsist(String deviceId, String nasId) {
        ArrayList<String> nasIds = new ArrayList<String>();
        nasIds.add(nasId);
        List nasList = this.getStorageResourceService().getStorageResources(deviceId, nasIds, NasFileSystem.class);
        if (!VerifyUtil.isEmpty((Collection)nasList)) {
            return (NasFileSystem)nasList.get(0);
        }
        logger.warn((Object)("can't get nas info(" + deviceId + "_" + nasId + ")."), 90160758786989L);
        throw new LegoCheckedException(1073948175L);
    }

    protected void generatePosiByNas(int type, ProtectObjectReplica protectObjectReplica, ProtectGroupReplica protectGroupReplica, ProtectObjectStorageInfo protectObjectStorageInfo, NasFileSystem nasMo) {
        List<ReplicationPair> pairs = this.getPairsByNas(nasMo);
        if (VerifyUtil.isEmpty(pairs)) {
            logger.warn((Object)("master nas(" + nasMo.getResourceId() + ")'s ReplicationPair is empty."), 90160758786989L);
            throw new LegoCheckedException(1073948175L);
        }
        ExecutionContext context = new ExecutionContext();
        this.generateRp(type, protectObjectReplica, protectObjectStorageInfo, pairs, protectGroupReplica, context);
    }

    protected List<ReplicationPair> getPairsByNas(NasFileSystem nasMo) {
        Site site = this.getSiteByDeviceSN(nasMo.getDevSn());
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getPairsByNas error, site is null, deviceSN:" + nasMo.getDevSn()), 90160758787071L);
            return Collections.emptyList();
        }
        ArrayList<String> nasIds = new ArrayList<String>();
        nasIds.add(nasMo.getResourceId());
        return this.queryValidReplicationPairsBy(nasMo.getDevSn(), nasIds, true, DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue());
    }

    @Override
    protected void createProtectObjectReplica(ProtectGroup protectGroup, ProtectGroupReplica protectGroupReplica, ExecutionContext context) {
        super.createProtectObjectReplica(protectGroup, protectGroupReplica, context);
        PolicyTemplate template = protectGroup.getTemplate();
        Object lunObject = this.getBuilderContext().get(EXISTLUN);
        Object nasObject = this.getBuilderContext().get(EXISTNAS);
        if (lunObject != null && nasObject != null) {
            template.setSubType(3);
        } else if (lunObject != null) {
            template.setSubType(1);
        } else if (nasObject != null) {
            template.setSubType(2);
        }
    }
}

