/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.storage.protection.replica.builder.AbstractArrayHyperMetroAsyncBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ArrayHyperMetroAsyncBuilder
extends AbstractArrayHyperMetroAsyncBuilder {
    public int getType() {
        return 18;
    }

    @Override
    protected String getSrcDeviceSN(ProtectGroup protectGroup) {
        ProtectObjectStorageInfo posi = this.randomAProtectObjectStorageInfo(protectGroup);
        List<StorageResource> storageResources = null;
        if (DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue() == posi.getResourceType().intValue()) {
            storageResources = this.queryNasStorageResource(protectGroup, posi);
        } else {
            String lunWWN = posi.getLunWWN();
            this.checkEmpty(lunWWN, "lunWWN is empty. protectName:" + protectGroup.getName());
            storageResources = this.queryStorageResource(lunWWN);
        }
        IReplicaService repService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        List pgReplicas = repService.queryProtectGroupReplicaByGroup(protectGroup.getUuid(), null, false);
        if (!VerifyUtil.isEmpty((Collection)pgReplicas)) {
            ProtectGroupReplica remoteProtectGroupReplica = null;
            for (ProtectGroupReplica protectGroupReplica : pgReplicas) {
                if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)protectGroupReplica)) continue;
                remoteProtectGroupReplica = protectGroupReplica;
                break;
            }
            if (null != remoteProtectGroupReplica) {
                HashSet<String> devSnSet = new HashSet<String>();
                for (StorageResource res : storageResources) {
                    devSnSet.add(res.getDevSn());
                }
                logger.error((Object)("Found the pgReplicas ProductArray: " + remoteProtectGroupReplica.getProductArray() + ", getRecoveryArray: " + remoteProtectGroupReplica.getRecoveryArray()), 90160758786897L);
                if (devSnSet.contains(remoteProtectGroupReplica.getProductArray())) {
                    return remoteProtectGroupReplica.getProductArray();
                }
                if (devSnSet.contains(remoteProtectGroupReplica.getRecoveryArray())) {
                    return remoteProtectGroupReplica.getRecoveryArray();
                }
                logger.error((Object)("devSN hasn't been finded! pgName : " + protectGroup.getName() + ", info:" + devSnSet), 90160758786897L);
            }
            throw new LegoCheckedException(-1L);
        }
        StringBuilder errorMsg = new StringBuilder();
        DrmEnumDefine.RESOURCE_TYPE_E type = DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue() == posi.getResourceType().intValue() ? DrmEnumDefine.RESOURCE_TYPE_E.NAS : DrmEnumDefine.RESOURCE_TYPE_E.LUN;
        for (StorageResource res : storageResources) {
            StorageResource resMo = this.getAsyncReplicationBuilder().checkStorageResourceExsist(res.getDevSn(), res.getResourceId(), type);
            List pairs = this.getAsyncReplicationBuilder().getPairsByStorageResource(resMo, posi.getResourceType());
            if (!VerifyUtil.isEmpty(pairs)) {
                pairs = this.getValidStatusReplicationPairs(pairs);
            }
            if (!VerifyUtil.isEmpty(pairs) && pairs.size() == 1) {
                this.checkEmpty(res.getDevSn(), "devSn is empty!errorMsg:" + errorMsg);
                return res.getDevSn();
            }
            int pairCount = null == pairs ? -1 : pairs.size();
            errorMsg.append("devSN:" + res.getDevSn() + ", resourceID:" + res.getResourceId() + ", pairs size : " + pairCount);
        }
        logger.error((Object)("devSN hasn't been finded! pgName : " + protectGroup.getName() + ", info:" + errorMsg), 90160758786897L);
        throw new LegoCheckedException(-1L);
    }

    @Override
    protected StorageResource getSrcStorageResource(String srcDevSN, ProtectObjectStorageInfo posi) {
        boolean isNas;
        StringBuilder errorInfo = new StringBuilder();
        List storageResources = null;
        boolean bl = isNas = DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue() == posi.getResourceType().intValue();
        if (isNas) {
            String resourceId;
            if (!srcDevSN.equals(posi.getResourceProviderSN())) {
                Map map = (Map)this.getBuilderContext().get("SRC_NAS_RESOURCEIDS");
                resourceId = (String)map.get(posi.getResourceProviderSN() + ":" + posi.getResourceId());
            } else {
                resourceId = posi.getResourceId();
            }
            storageResources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResources(srcDevSN, Arrays.asList(resourceId), DrmEnumDefine.RESOURCE_TYPE_E.NAS);
        } else {
            String lunWWN = posi.getLunWWN();
            errorInfo.append("srcDevSN : " + srcDevSN + ", lunWWN:" + lunWWN + "\n");
            storageResources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWWN});
        }
        this.checkStorageResources(storageResources, isNas);
        StorageResource srcStorageResource = null;
        for (StorageResource storageResource : storageResources) {
            if (storageResource.getDevSn().equals(srcDevSN)) {
                srcStorageResource = storageResource;
                break;
            }
            errorInfo.append("devSN:" + storageResource.getDevSn() + ", resourceId:" + storageResource.getResourceId() + "\n");
        }
        this.checkEmpty(srcStorageResource, "srcStorageResource is empty! errorInfo : " + errorInfo);
        String devSn = "";
        String resourceId = "";
        if (srcStorageResource != null) {
            devSn = srcStorageResource.getDevSn();
            resourceId = srcStorageResource.getResourceId();
        }
        DrmEnumDefine.RESOURCE_TYPE_E type = DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue() == posi.getResourceType().intValue() ? DrmEnumDefine.RESOURCE_TYPE_E.NAS : DrmEnumDefine.RESOURCE_TYPE_E.LUN;
        return this.getAsyncReplicationBuilder().checkStorageResourceExsist(devSn, resourceId, type);
    }

    private List<StorageResource> queryStorageResource(String lunWWN) {
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWWN});
        if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 2) {
            logger.error((Object)("method[getSrcDeviceSN()]. Resources is empty or the size is not two! resources size:" + resources), 90160758786897L);
            throw new LegoCheckedException(1073947393L);
        }
        return resources;
    }

    private void checkStorageResources(List<StorageResource> storageResources, boolean isNas) {
        if (!VerifyUtil.isEmpty(storageResources)) {
            if (isNas && storageResources.size() == 1) {
                return;
            }
            if (!isNas && storageResources.size() == 2) {
                return;
            }
        }
        logger.error((Object)("method[getSrcLun()]. Resources is empty or the size is not two! resources:" + storageResources), 90160758786897L);
        throw new LegoCheckedException(1073947393L);
    }

    private List<StorageResource> queryNasStorageResource(ProtectGroup pg, ProtectObjectStorageInfo posi) {
        List allStorageResources = null;
        String vstorePairId = (String)pg.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        List list = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByVstore(posi.getResourceProviderSN(), posi.getVstoreId());
        this.checkEmpty(list, "has no hyperMetroPair1");
        String srcDevSn = ((HyperMetroPair)list.iterator().next()).getDevSn();
        StorageResourceServiceRouter router = StorageResourceServiceRouter.getInstance();
        allStorageResources = router.getNasHyperMetroStoreageList(srcDevSn, vstorePairId, list);
        HashMap<String, String> map = new HashMap<String, String>();
        for (HyperMetroPair hyperMetroPair : list) {
            map.put(hyperMetroPair.getDevSn() + ":" + hyperMetroPair.getLocalObjId(), hyperMetroPair.getRemoteObjId());
        }
        this.getBuilderContext().put("SRC_NAS_RESOURCEIDS", map);
        return allStorageResources;
    }
}

