/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractReplicaBuilder;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperVaultBuilder
extends AbstractReplicaBuilder {
    protected static final String PROTECTION_RELATION = "protectionRelation";
    protected static final String DEVICE_SN_PREFIX = "DEVICE_SN_LOCATION_";
    protected static final String HYPER_VAULT = "HYPER_VAULT";
    private static Log logger = LogFactory.getInstance(ArrayHyperVaultBuilder.class);

    public void buildReplica(ProtectGroup protectGroup) {
        this.check(protectGroup);
        logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " build replica." + this.getMsg(protectGroup)));
        ExecutionContext context = this.init(protectGroup);
        try {
            if (VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList())) {
                this.buildReplicaWhenCreatePG(context);
                return;
            }
            this.buildReplicaWhenRefreshPG(context);
        }
        finally {
            logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " build replica." + this.getMsg(protectGroup)));
        }
    }

    protected void check(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.error((Object)"protectGroup is null!");
            throw new LegoCheckedException(1073947393L);
        }
        PolicyTemplate template = protectGroup.getTemplate();
        if (template == null) {
            logger.error((Object)("template is null!msg:" + this.getMsg(protectGroup)));
            throw new LegoCheckedException(1073947393L);
        }
        Map props = template.getProps();
        if (VerifyUtil.isEmpty((Map)props)) {
            logger.error((Object)("template props is empty!msg:" + this.getMsg(protectGroup)));
            throw new LegoCheckedException(1073947393L);
        }
    }

    private ExecutionContext init(ProtectGroup protectGroup) {
        ExecutionContext context = new ExecutionContext();
        context.setAttribute("PROTECT_GROUP", (Object)protectGroup);
        ProtectionRelation protectionRelation = this.initProtectionRelation(protectGroup);
        context.setAttribute(PROTECTION_RELATION, (Object)protectionRelation);
        ProtectObjectStorageInfo storageInfo = this.getStorageInfo(protectGroup);
        HyperVault hyperVault = this.getHyperVaultService(storageInfo.getResourceProviderSN()).queryHyperVaultByResourceId(storageInfo.getResourceProviderSN(), storageInfo.getResourceId());
        context.setAttribute(HYPER_VAULT, (Object)hyperVault);
        if (hyperVault != null) {
            logger.debug((Object)"hyperVault is not null.");
            this.setDeviceSN(context, hyperVault);
        }
        return context;
    }

    private ProtectionRelation initProtectionRelation(ProtectGroup protectGroup) {
        PolicyTemplate template = protectGroup.getTemplate();
        Map props = template.getProps();
        String prStr = (String)props.get(PROTECTION_RELATION);
        if (VerifyUtil.isEmpty((String)prStr)) {
            logger.error((Object)"Create hyper vault Relation failed! Because protectionRelation is empty!", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectionRelation protectionRelation = ProtectionRelationJsonConverter.toProtectionRelation((String)prStr);
        String prStr2DB = ProtectionRelationJsonConverter.toJsonStr((ProtectionRelation)protectionRelation, (boolean)true);
        props.put(PROTECTION_RELATION, prStr2DB);
        return protectionRelation;
    }

    private ProtectObjectStorageInfo getStorageInfo(ProtectGroup protectGroup) {
        Set poSet = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)poSet)) {
            logger.error((Object)"poSet is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject protectObject = (ProtectObject)poSet.iterator().next();
        Set usedStorageResourceSet = protectObject.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.error((Object)"usedStorageResourceSet is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        return storageInfo;
    }

    private void buildReplicaWhenRefreshPG(ExecutionContext context) {
        this.checkHyperVaultStatusWhenRefresh(context);
    }

    private void checkHyperVaultStatusWhenRefresh(ExecutionContext context) {
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPER_VAULT, HyperVault.class);
        if (hyperVault == null) {
            logger.error((Object)("hyperVault is not existed!" + this.getMsg(this.getPG(context))));
            throw new LegoCheckedException(1073948242L);
        }
        this.checkHealthStatus(context, hyperVault);
    }

    private void buildReplicaWhenCreatePG(ExecutionContext context) {
        if (!this.existHyperVaultRelation(context)) {
            this.createHyperVaultRelation(context);
        }
        this.disableExecutePolicyInDevice(context);
    }

    private ProtectGroup getPG(ExecutionContext context) {
        return (ProtectGroup)context.getAttribute("PROTECT_GROUP", ProtectGroup.class);
    }

    private void disableExecutePolicyInDevice(ExecutionContext context) {
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPER_VAULT, HyperVault.class);
        String devSn = hyperVault.getDevSn();
        try {
            this.getHyperVaultService(devSn).disablePolicys(devSn, hyperVault.getId(), null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("to disable policy on device failed! devSn:" + devSn + ", hyperVaultId:" + hyperVault.getId()));
            throw e;
        }
    }

    protected IStorageHyperVaultManager getHyperVaultService(String devSn) {
        IStorageHyperVaultManager service = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(devSn);
        if (service == null) {
            logger.error((Object)("to get the IStorageHyperVaultManager failed! devSn:" + devSn));
            throw new LegoCheckedException(-1L);
        }
        return service;
    }

    private void createHyperVaultRelation(ExecutionContext context) {
        HyperVault newHyperVault;
        ProtectionRelation pr = (ProtectionRelation)context.getAttribute(PROTECTION_RELATION, ProtectionRelation.class);
        HyperVault hyperVaultParam = this.getHyperVault(pr);
        try {
            newHyperVault = this.getHyperVaultService(pr.getSrcResourceProviderSn()).createHyperVault(hyperVaultParam, true);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("create Hyper Vault failed!" + e.getMessage()), e.getErrorCode());
            throw e;
        }
        if (newHyperVault == null) {
            logger.error((Object)"create Hyper Vault failed!");
            throw new LegoCheckedException(1073948244L);
        }
        newHyperVault.setRemoteDeviceSn(hyperVaultParam.getRemoteDeviceSn());
        this.setDeviceSN(context, newHyperVault);
        context.setAttribute(HYPER_VAULT, (Object)newHyperVault);
    }

    private HyperVault getHyperVault(ProtectionRelation pr) {
        ProtectionRelation remoteProtectionRelation = this.getRemoteProtectionRelation(pr);
        HyperVault hyperVault = new HyperVault();
        hyperVault.setLocalResourceId(pr.getSrcResourceId());
        hyperVault.setDevSn(pr.getSrcResourceProviderSn());
        hyperVault.setRemoteResourceId(remoteProtectionRelation.getSrcResourceId());
        hyperVault.setRemoteDeviceSn(remoteProtectionRelation.getSrcResourceProviderSn());
        return hyperVault;
    }

    private ProtectionRelation getRemoteProtectionRelation(ProtectionRelation pr) {
        List targetResources = pr.getTargetResources();
        if (VerifyUtil.isEmpty((Collection)targetResources)) {
            logger.error((Object)"targetResources is empty! ");
            throw new LegoCheckedException(1073947393L);
        }
        return (ProtectionRelation)targetResources.get(0);
    }

    private boolean existHyperVaultRelation(ExecutionContext context) {
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPER_VAULT, HyperVault.class);
        if (hyperVault == null) {
            logger.debug((Object)"hyperVault is null.");
            return false;
        }
        this.checkHealthStatus(context, hyperVault);
        this.checkTargetDeviceParam(context, hyperVault);
        return true;
    }

    private void setDeviceSN(ExecutionContext context, HyperVault hyperVault) {
        context.setAttribute(DEVICE_SN_PREFIX + DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue(), (Object)hyperVault.getDevSn());
        context.setAttribute(DEVICE_SN_PREFIX + DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue(), (Object)hyperVault.getRemoteDeviceSn());
    }

    private void checkHealthStatus(ExecutionContext context, HyperVault hyperVault) {
        String healthStateStr = hyperVault.getHealthState();
        String normalStateStr = String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue());
        if (!normalStateStr.equals(healthStateStr)) {
            logger.error((Object)("the health status is not normal! healthStatus:" + healthStateStr + this.getMsg(this.getPG(context))));
            throw new LegoCheckedException(1073948239L);
        }
    }

    private void checkTargetDeviceParam(ExecutionContext context, HyperVault hyperVault) {
        ProtectionRelation protectionRelation = (ProtectionRelation)context.getAttribute(PROTECTION_RELATION, ProtectionRelation.class);
        List targetResources = protectionRelation.getTargetResources();
        if (VerifyUtil.isEmpty((Collection)targetResources)) {
            logger.error((Object)("targetResources is empty!" + this.getMsg(this.getPG(context))));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectionRelation targetPR = (ProtectionRelation)targetResources.get(0);
        String deviceSnFromArray = hyperVault.getRemoteDeviceSn();
        String resourceIdFromArray = hyperVault.getRemoteResourceId();
        String deviceSnFromFore = targetPR.getSrcResourceProviderSn();
        String resourceIdFromFore = targetPR.getSrcResourceId();
        if (!deviceSnFromArray.equals(deviceSnFromFore) || !resourceIdFromArray.equals(resourceIdFromFore)) {
            logger.error((Object)("The deviceSN or resourceId is not the same with device's!" + this.getMsg(this.getPG(context)) + "deviceSnFromArray" + deviceSnFromArray + ", resourceIdFromArray:" + resourceIdFromArray + ", deviceSnFromFore" + deviceSnFromFore + ",resourceIdFromFore:" + resourceIdFromFore));
            throw new LegoCheckedException(1073947393L);
        }
    }

    public Set<RelicaStorageInfo> deleteSnapshots(ProtectGroupReplica protectGroupReplica) {
        HashSet<RelicaStorageInfo> failedDeleteStorageInfoSet = new HashSet<RelicaStorageInfo>();
        for (ProtectObjectReplica por : protectGroupReplica.getReplicas()) {
            for (RelicaStorageInfo rsi : por.getStorageInfos()) {
                if (this.deleteReplicaOnStorage((LocalStorageReplica)rsi)) continue;
                failedDeleteStorageInfoSet.add(rsi);
            }
        }
        return failedDeleteStorageInfoSet;
    }

    private boolean deleteReplicaOnStorage(LocalStorageReplica localStorageReplica) {
        if ("NONE".equals(localStorageReplica.getStorageId())) {
            logger.debug((Object)("deleteReplicaOnStorage success: " + localStorageReplica.getSnapshotName()));
            return true;
        }
        try {
            this.getHyperVaultService(localStorageReplica.getSrcStorageProviderSN()).deleteCopy(localStorageReplica.getSrcStorageProviderSN(), localStorageReplica.getStorageId());
            return true;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("deleteSnapshotOnStorage error: " + localStorageReplica.getSrcStorageProviderSN() + ",Name:" + localStorageReplica.getSnapshotName() + ",Id:" + localStorageReplica.getStorageId() + "," + ExceptionUtil.getErrorMessage((Throwable)e) + ", errorcode:" + e.getErrorCode()));
            if (e.getErrorCode() == 1073754118L || e.getErrorCode() == 1073816833L) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("deleteReplicaOnStorage error: " + localStorageReplica.getSrcStorageProviderSN() + ",Name:" + localStorageReplica.getSnapshotName() + ",Id:" + localStorageReplica.getStorageId() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return false;
    }

    protected String getMsg(ProtectGroup protectGroup) {
        return " [pgName:" + protectGroup.getName() + ", pgId:" + protectGroup.getUuid() + "]";
    }

    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        HashSet<ProtectGroupReplica> failedDeleteReplicaSet = new HashSet<ProtectGroupReplica>();
        HashSet<RelicaStorageInfo> failedDeleteStorageInfoSet = new HashSet<RelicaStorageInfo>();
        for (ProtectGroupReplica pgr : protectGroup.getReplicaList()) {
            Set<RelicaStorageInfo> failedStorageInfos = this.deleteSnapshots(pgr);
            if (VerifyUtil.isEmpty(failedStorageInfos)) continue;
            logger.warn((Object)("exist failed to delete snapshot.size:" + failedStorageInfos.size()));
            failedDeleteStorageInfoSet.addAll(failedStorageInfos);
        }
        if (!VerifyUtil.isEmpty(failedDeleteStorageInfoSet)) {
            ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)protectGroup.getReplicaList().iterator().next();
            try {
                ProtectGroupReplica clonePgReplica = (ProtectGroupReplica)protectGroupReplica.clone();
                Set poReplicaSet = clonePgReplica.getReplicas();
                ProtectObjectReplica protectObjectReplica = (ProtectObjectReplica)poReplicaSet.iterator().next();
                protectObjectReplica.setStorageInfos(failedDeleteStorageInfoSet);
                poReplicaSet.clear();
                poReplicaSet.add(protectObjectReplica);
                failedDeleteReplicaSet.add(clonePgReplica);
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)("clone pgreplica error! error:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return failedDeleteReplicaSet;
    }

    public int getType() {
        return 17;
    }
}

