/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractReplicaBuilder;
import com.huawei.ism.drm.storage.replication.builder.StorageReplicationGroupFactory;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FusionStorageAsyncReplicationBuilder
extends AbstractReplicaBuilder {
    private static final Log logger = LogFactory.getInstance(FusionStorageAsyncReplicationBuilder.class);

    public void buildReplica(ProtectGroup protectGroup) {
        ProtectGroupReplica protectGroupReplica;
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            logger.error((Object)"error param.");
            return;
        }
        Set storageInfoSet = ((ProtectObject)protectGroup.getPolist().iterator().next()).getUsedStorageResourceSet();
        String srcDevSN = "";
        if (!VerifyUtil.isEmpty((Collection)storageInfoSet)) {
            srcDevSN = ((ProtectObjectStorageInfo)storageInfoSet.iterator().next()).getResourceProviderSN();
        }
        if (VerifyUtil.isEmpty((String)srcDevSN)) {
            srcDevSN = ((ProtectGroupReplica)protectGroup.getReplicaList().iterator().next()).getProductArray();
        }
        this.getBuilderContext().put("REPLICA_INDEX", 1);
        this.getBuilderContext().put("PROTECT_TYPE", 2);
        this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue());
        this.getBuilderContext().put("SRC_DEVICE", srcDevSN);
        StorageReplicationGroupFactory storageFactory = StorageReplicationGroupFactory.newFactory();
        List<ReplicationGroup> results = storageFactory.buildReplicationGroup(protectGroup);
        if (VerifyUtil.isEmpty(results) || results.size() != 1) {
            throw new LegoCheckedException(1073948407L, "Failed to create the volume replication or replication consistency group.");
        }
        ReplicationGroup replicationGroup = results.get(0);
        List replicationPairs = replicationGroup.getReplicationPairs();
        HashMap<String, ReplicationPair> repMap = new HashMap<String, ReplicationPair>();
        for (ReplicationPair replicationPair : replicationPairs) {
            String key = CommUtil.combineString((String[])new String[]{replicationPair.getSrcDevSN(), replicationPair.getSrcLunId()});
            repMap.put(key, replicationPair);
        }
        if (VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList())) {
            protectGroupReplica = new ProtectGroupReplica();
            protectGroupReplica.setId(UUIDGenerator.getUUID());
            protectGroupReplica.setName("REMOTEREPLICA-" + protectGroup.getName() + "-" + this.getString("REPLICA_INDEX"));
            protectGroupReplica.setProductArray(this.getString("SRC_DEVICE"));
            protectGroupReplica.setType(this.getInt("PROTECT_TYPE"));
            protectGroupReplica.setIndex(this.getInt("REPLICA_INDEX"));
            protectGroupReplica.setPg(protectGroup);
            protectGroupReplica.setProtectLocation(this.getInt("PROTECT_LOCATION"));
            protectGroupReplica.setStatus(DrmEnumDefine.REPLICA_STATUS.UNACTIVE_STATUS.getValue());
            protectGroup.getReplicaList().clear();
            protectGroup.getReplicaList().add(protectGroupReplica);
        } else {
            protectGroupReplica = (ProtectGroupReplica)CommonUtil.getFirstElement((Collection)protectGroup.getReplicaList());
            protectGroupReplica.getReplicas().clear();
            protectGroupReplica.setPoReplicaMateData(null);
        }
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ProtectObjectReplica protectObjectReplica = new ProtectObjectReplica();
            protectObjectReplica.setId(UUIDGenerator.getUUID());
            protectObjectReplica.setPoId(protectObject.getUuid());
            protectObjectReplica.setPgReplica(protectGroupReplica);
            this.generatePosi(protectObject, protectObjectReplica, repMap);
            protectGroupReplica.getReplicas().add(protectObjectReplica);
        }
    }

    private void generatePosi(ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, Map<String, ReplicationPair> repMap) {
        for (ProtectObjectStorageInfo posi : protectObject.getUsedStorageResourceSet()) {
            ReplicationPair replicationPair = repMap.get(CommUtil.combineString((String[])new String[]{posi.getResourceProviderSN(), posi.getResourceId()}));
            if (VerifyUtil.isEmpty((Object)replicationPair)) {
                logger.warn((Object)("no pair for:" + posi.getResourceName()));
                continue;
            }
            for (ReplicationTargetLun replicationTargetLun : replicationPair.getRepTgtLuns()) {
                RemoteStorageReplica remoteStorageReplica = new RemoteStorageReplica();
                remoteStorageReplica.setId(UUIDGenerator.getUUID());
                remoteStorageReplica.setSrcStorageId(replicationPair.getSrcLunId());
                remoteStorageReplica.setSrcStorageProviderSN(replicationPair.getSrcDevSN());
                remoteStorageReplica.setStorageId(replicationTargetLun.getTgtLunId());
                remoteStorageReplica.setStorageProviderSN(replicationTargetLun.getTgtDevSN());
                remoteStorageReplica.setPoReplica(protectObjectReplica);
                remoteStorageReplica.setReplicationPairId(replicationPair.getReplicationId());
                remoteStorageReplica.setConsistentGroupId(replicationPair.getConsistentGroupId());
                remoteStorageReplica.setSynchronization(Boolean.valueOf(1 == replicationPair.getReplicationMode()));
                remoteStorageReplica.setProtectObjectStorageWwn(posi.getLunWWN());
                protectObjectReplica.getStorageInfos().add(remoteStorageReplica);
                protectObjectReplica.getPgReplica().setRecoveryArray(replicationTargetLun.getTgtDevSN());
                String recoverySiteId = this.getSiteBySn(replicationTargetLun.getTgtDevSN());
                protectObjectReplica.getPgReplica().setRecoverySite(recoverySiteId);
            }
        }
    }

    public int getType() {
        return 33;
    }
}

