/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.CloneConsistentGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperClonePair;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractReplicaBuilder;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCloneManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.HyperClonePolicyVO;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCloneManager;
import com.huawei.ism.drm.storage.protection.action.RefreshHyperClonePairsTask;
import com.huawei.ism.drm.storage.protection.bean.CloneConsistentGroupCache;
import com.huawei.ism.drm.storage.protection.bean.HyperCloneTargetLunVO;
import com.huawei.ism.drm.storage.protection.replica.builder.StoragePoolResourceCache;
import com.huawei.ism.drm.storage.protection.util.HyperCloneProtectionUtil;
import com.huawei.ism.drm.storage.sdk.model.HyperClone;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourcePoolService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class HyperCloneReplicaBuilder
extends AbstractReplicaBuilder {
    private static Log logger = LogFactory.getInstance(HyperCloneReplicaBuilder.class);
    private static final String RESOURCE_POOL = "resourcePoolId";
    private static final String PROTECT_GROUP_ID = "protectGroupId";
    private static final String NEWLY_HYPER_CLONE_PAIR = "NEWLY_HYPER_CLONE_PAIR";
    private static final String CLONE_CG_CACHE = "cloneCgCache";
    private static final String STORAGE_RESOURCE_CACHE = "storageResourceCache";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildReplica(ProtectGroup protectGroup) {
        String srcDevSN = HyperCloneProtectionUtil.getSrcDevSN(protectGroup);
        if (VerifyUtil.isEmpty((String)srcDevSN)) {
            logger.error((Object)"product array is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        this.getBuilderContext().put("SRC_DEVICE", srcDevSN);
        String storagePoolId = (String)protectGroup.getProps().get(RESOURCE_POOL);
        this.getBuilderContext().put(RESOURCE_POOL, storagePoolId);
        this.getBuilderContext().put(PROTECT_GROUP_ID, protectGroup.getUuid());
        CloneConsistentGroupCache cloneCache = this.initCloneConsistentGroupCache(protectGroup);
        StoragePoolResourceCache resourceCache = this.initStoragePoolResourceCache(srcDevSN, storagePoolId);
        try {
            this.getBuilderContext().put(CLONE_CG_CACHE, cloneCache);
            this.getBuilderContext().put(STORAGE_RESOURCE_CACHE, resourceCache);
            this.processProtectGroupReplicaNumberChange(protectGroup);
            Collection<ProtectObjectStorageInfo> storageInfos = this.getProtectionStorageInfos(protectGroup);
            this.cleanCloneConsistentGroups(storageInfos);
            this.rebuildCloneConsistentGroups(protectGroup, storageInfos);
            ExecutionService.submit((Runnable)new RefreshHyperClonePairsTask(this.getNewlyHyperClonePairs()));
        }
        finally {
            this.getBuilderContext().put(CLONE_CG_CACHE, null);
            this.getBuilderContext().put(STORAGE_RESOURCE_CACHE, null);
        }
    }

    public int getType() {
        logger.debug((Object)"getType:PolicyTemplateType.ARRAY_HYPER_CLONE");
        return 16;
    }

    private CloneConsistentGroupCache initCloneConsistentGroupCache(ProtectGroup protectGroup) {
        CloneConsistentGroupCache cache = new CloneConsistentGroupCache(protectGroup);
        return cache;
    }

    private StoragePoolResourceCache initStoragePoolResourceCache(String deviceSn, String storagePoolId) {
        StoragePoolResourceCache resourceCache = new StoragePoolResourceCache();
        resourceCache.setAssociatedPoolUuid(storagePoolId);
        IStorageResourcePoolService poolService = (IStorageResourcePoolService)ServiceLocator.getInstance().getService(IStorageResourcePoolService.class);
        if (null == storagePoolId || storagePoolId.equals("-1")) {
            List storageResources = poolService.getAvailableStorageResources(deviceSn, DrmEnumDefine.RESOURCE_TYPE_E.LUN);
            resourceCache.addStorageResources(storageResources);
        } else {
            Page allStorageResourcesInPool = poolService.storageResources(storagePoolId, "name", "asc", Integer.MAX_VALUE, 0, DrmEnumDefine.RESOURCE_TYPE_E.LUN);
            List poolResources = (List)allStorageResourcesInPool.getResult();
            resourceCache.addStoragePoolResources(poolResources);
        }
        return resourceCache;
    }

    private void processProtectGroupReplicaNumberChange(ProtectGroup protectGroup) {
        int changedPgReplicaCount = this.getChangedProtectGroupReplicaCount(protectGroup);
        if (0 > changedPgReplicaCount) {
            this.deleteRedundantProtectGroupReplicas(protectGroup);
        } else if (0 < changedPgReplicaCount) {
            this.createNewlyCloneConsistentGroup(protectGroup, Math.abs(changedPgReplicaCount));
        }
    }

    private void createNewlyCloneConsistentGroup(ProtectGroup protectGroup, int increasedReplicaCount) {
        CloneConsistentGroupCache cloneCache = this.getCloneConsistentGroupCache();
        String deviceSn = String.valueOf(this.getBuilderContext().get("SRC_DEVICE"));
        Collection<ProtectObjectStorageInfo> poStorageInfos = this.getProtectionStorageInfos(protectGroup);
        for (int i = 0; i < increasedReplicaCount; ++i) {
            CloneConsistentGroup cloneCg = this.createCloneConsistentGroup(deviceSn, poStorageInfos);
            cloneCg.setPgId(protectGroup.getUuid());
            cloneCache.addCloneConsistentGroup(cloneCg);
        }
    }

    private void deleteRedundantProtectGroupReplicas(ProtectGroup pg) {
        CloneConsistentGroupCache cloneCache = this.getCloneConsistentGroupCache();
        List<ProtectGroupReplica> sortedPgReplicas = HyperCloneProtectionUtil.getSortedProtectGroupReplicas(pg);
        int latestReplicaCount = NumberUtil.convertToInteger(pg.getTemplate().getProps().get("PP_SNAPSHOT_COUNT"));
        Iterator<ProtectGroupReplica> iter = sortedPgReplicas.iterator();
        while (iter.hasNext() && sortedPgReplicas.size() > latestReplicaCount) {
            ProtectGroupReplica pgReplica = iter.next();
            this.deleteProtectGroupReplica(pg, pgReplica.getId());
            cloneCache.deleteCloneConsistentGroup(pgReplica.getId());
        }
    }

    private void cleanCloneConsistentGroups(Collection<ProtectObjectStorageInfo> poStorageInfos) {
        HashSet<String> poStorageInfoKeys = new HashSet<String>();
        for (ProtectObjectStorageInfo poStorageInfo : poStorageInfos) {
            String poStorageInfoKey = poStorageInfo.getResourceProviderSN() + ":" + poStorageInfo.getResourceId();
            poStorageInfoKeys.add(poStorageInfoKey);
        }
        CloneConsistentGroupCache cloneCache = this.getCloneConsistentGroupCache();
        for (CloneConsistentGroup cloneCG : cloneCache.getCloneConsistentGroups()) {
            this.cleanCloneConsistentGroup(cloneCG, poStorageInfoKeys);
        }
    }

    private void cleanCloneConsistentGroup(CloneConsistentGroup cloneCG, Set<String> poStorageInfoKeys) {
        CloneConsistentGroupCache cloneCache = this.getCloneConsistentGroupCache();
        ArrayList clonePairs = new ArrayList();
        clonePairs.addAll(cloneCG.getPairs());
        for (HyperClonePair clonePair : clonePairs) {
            String key = clonePair.getDeviceSn() + ":" + clonePair.getSrcLunId();
            if (poStorageInfoKeys.contains(key)) continue;
            cloneCache.deleteHyperClonePair(cloneCG, clonePair);
        }
    }

    private void rebuildCloneConsistentGroups(ProtectGroup protectGroup, Collection<ProtectObjectStorageInfo> storageInfos) {
        CloneConsistentGroupCache cloneCache = this.getCloneConsistentGroupCache();
        for (ProtectObjectStorageInfo poStorageInfo : storageInfos) {
            for (CloneConsistentGroup cloneCg : cloneCache.getCloneConsistentGroups()) {
                this.rebuildHyperClonePairByPoStorageInfo(protectGroup, poStorageInfo, cloneCg);
            }
        }
    }

    private void rebuildHyperClonePairByPoStorageInfo(ProtectGroup protectGroup, ProtectObjectStorageInfo poStorageInfo, CloneConsistentGroup cloneCg) {
        HyperClonePair hyperClonePair = cloneCg.getHyperClonePair(poStorageInfo.getResourceProviderSN(), poStorageInfo.getResourceId());
        hyperClonePair = null == hyperClonePair ? this.createHyperClonePair(poStorageInfo.getResourceProviderSN(), poStorageInfo.getResourceId(), null) : this.rebuildHyperClonePair(hyperClonePair, protectGroup, cloneCg);
        CloneConsistentGroupCache cloneCache = this.getCloneConsistentGroupCache();
        cloneCache.addHyperClonePair(cloneCg, hyperClonePair);
    }

    private HyperClonePair rebuildHyperClonePair(HyperClonePair hyperClonePair, ProtectGroup protectGroup, CloneConsistentGroup cloneCg) {
        if (!hyperClonePair.isNewlyCreated() && !HyperCloneProtectionUtil.isValidHyperClonePair(hyperClonePair)) {
            ProtectGroupReplica pgReplica = HyperCloneProtectionUtil.getProtectGroupReplica(protectGroup, cloneCg.getPgReplicaId());
            if (null != pgReplica && pgReplica.getStatus() == DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue()) {
                pgReplica.setStatus(DrmEnumDefine.REPLICA_STATUS.ERROR_STATUS.getValue());
            }
            return this.createHyperClonePair(hyperClonePair.getDeviceSn(), hyperClonePair.getSrcLunId(), hyperClonePair.getTgtLunId());
        }
        return hyperClonePair;
    }

    private int getChangedProtectGroupReplicaCount(ProtectGroup protectGroup) {
        ProtectGroup oldProtectGroup;
        int oldReplicaCount;
        block3: {
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            oldReplicaCount = 0;
            oldProtectGroup = null;
            try {
                oldProtectGroup = pgService.getProtectGroupByID(protectGroup.getUuid(), false);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 1073947394L) break block3;
                throw e;
            }
        }
        if (null != oldProtectGroup) {
            oldReplicaCount = NumberUtil.convertToInteger(oldProtectGroup.getTemplate().getProps().get("PP_SNAPSHOT_COUNT"), (int)1);
        }
        int latestReplicaCount = NumberUtil.convertToInteger(protectGroup.getTemplate().getProps().get("PP_SNAPSHOT_COUNT"), (int)1);
        return latestReplicaCount - oldReplicaCount;
    }

    private CloneConsistentGroup createCloneConsistentGroup(String deviceSn, Collection<ProtectObjectStorageInfo> poStorageInfos) {
        CloneConsistentGroup cloneConsistentGroup = new CloneConsistentGroup();
        cloneConsistentGroup.setPairs(new HashSet());
        for (ProtectObjectStorageInfo poStorageInfo : poStorageInfos) {
            HyperClonePair hyperClonePair = this.createHyperClonePair(deviceSn, poStorageInfo.getResourceId(), null);
            cloneConsistentGroup.getPairs().add(hyperClonePair);
        }
        return cloneConsistentGroup;
    }

    private HyperClonePair createHyperClonePair(String deviceSn, String srcLunId, String tgtLunId) {
        StoragePoolResourceCache resourceCache = this.geteStoragePoolResourceCache();
        IStorageResourceService resourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        Lun srcLun = (Lun)resourceService.getStorageResource(deviceSn, srcLunId, Lun.class);
        if (null == srcLun) {
            logger.error((Object)("srcLun is null.deviceSn:" + deviceSn + ", srcLunId:" + srcLunId));
            throw new LegoCheckedException(1073947394L);
        }
        HyperClonePair hyperClonePair = this.getExistedValidClonePair(srcLun, resourceCache);
        if (null == hyperClonePair) {
            hyperClonePair = this.createNewlyHyperClonePair(srcLun, tgtLunId, resourceCache);
        }
        return hyperClonePair;
    }

    private HyperClonePair getExistedValidClonePair(Lun srcLun, StoragePoolResourceCache resourceCache) {
        List<HyperCloneTargetLunVO> existedTgtLuns = HyperCloneProtectionUtil.getTargetLunsBySrcLun(srcLun.getDevSn(), srcLun);
        List<HyperCloneTargetLunVO> optimalTgtLunVOs = this.getOptimalCloneTargetLun(existedTgtLuns, resourceCache);
        if (VerifyUtil.isEmpty(optimalTgtLunVOs)) {
            return null;
        }
        HyperClonePair hyperClonePair = null;
        for (HyperCloneTargetLunVO optimalTargetLunVO : optimalTgtLunVOs) {
            if (this.isUsedHyperCloneTargetLunByPg(optimalTargetLunVO, "")) continue;
            Lun targetLun = optimalTargetLunVO.getTargetLun();
            resourceCache.updateStoragePoolResource(targetLun.getUuid(), true);
            HyperCloneTargetLun cloneTargetLun = optimalTargetLunVO.getHyperCloneTargetLun();
            DrmStorageUtil.saveOrUpdateHyperCloneTargetLun((String)srcLun.getDevSn(), (HyperCloneTargetLun)cloneTargetLun);
            hyperClonePair = this.constructHyperClonePair(srcLun.getDevSn(), srcLun.getLunId(), targetLun.getLunId(), cloneTargetLun.getPairId());
            hyperClonePair.setNewlyCreated(true);
            this.recordNewlyHyperClonePair(hyperClonePair);
            break;
        }
        return hyperClonePair;
    }

    private Collection<ProtectObjectStorageInfo> getProtectionStorageInfos(ProtectGroup protectGroup) {
        HashMap<String, ProtectObjectStorageInfo> storageInfos = new HashMap<String, ProtectObjectStorageInfo>();
        Set protectObjects = protectGroup.getPolist();
        for (ProtectObject protectObject : protectObjects) {
            Set poStorageInfos = protectObject.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo poStorageInfo : poStorageInfos) {
                String poStorageInfoKey = poStorageInfo.getResourceProviderSN() + ":" + poStorageInfo.getResourceId();
                storageInfos.put(poStorageInfoKey, poStorageInfo);
            }
        }
        return storageInfos.values();
    }

    private void deleteProtectGroupReplica(ProtectGroup protectGroup, String pgReplicaId) {
        Set pgReplicas = protectGroup.getReplicaList();
        Iterator iter = pgReplicas.iterator();
        while (iter.hasNext()) {
            ProtectGroupReplica pgReplica = (ProtectGroupReplica)iter.next();
            if (!pgReplicaId.equals(pgReplica.getId())) continue;
            iter.remove();
            break;
        }
    }

    private Set<HyperClonePair> getNewlyHyperClonePairs() {
        Object object = this.getBuilderContext().get(NEWLY_HYPER_CLONE_PAIR);
        if (null == object) {
            return new HashSet<HyperClonePair>();
        }
        return (Set)object;
    }

    private void recordNewlyHyperClonePair(HyperClonePair hyperClonePair) {
        Set<HyperClonePair> pairs = this.getNewlyHyperClonePairs();
        pairs.add(hyperClonePair);
        this.getBuilderContext().put(NEWLY_HYPER_CLONE_PAIR, pairs);
    }

    private HyperCloneTargetLun addHyperCloneTargetLun(String deviceSn, String srcLunId, String targetLunId, HyperClone hyperClone, IStorageHyperCloneManager hyperCloneMgr) {
        HyperCloneTargetLun hyperCloneTargetLun = hyperCloneMgr.getTargetLun(deviceSn, srcLunId, targetLunId);
        if (null != hyperCloneTargetLun) {
            String pgId = String.valueOf(this.getBuilderContext().get(PROTECT_GROUP_ID));
            String pairId = hyperCloneTargetLun.getPairId();
            if (this.isUsedTargetLunByOtherPg(deviceSn, srcLunId, deviceSn, targetLunId, pairId, pgId)) {
                logger.error((Object)("The target lun is used. devSn:" + deviceSn + ",SrcLunId:" + srcLunId + ",TgtLunId:" + targetLunId + ",PairId:" + pairId), 90160758784001L);
                hyperCloneTargetLun = null;
            }
        } else {
            HyperClonePolicyVO policy = new HyperClonePolicyVO();
            OperationResult result = hyperCloneMgr.addTargetLun(deviceSn, hyperClone.getId(), targetLunId, policy);
            if (null != result && result.isSuccess()) {
                hyperCloneTargetLun = hyperCloneMgr.getTargetLun(deviceSn, srcLunId, targetLunId);
            } else {
                String errorCode = null != result ? result.getErrorCode() : "";
                logger.warn((Object)("Adding target lun failed. devSn:" + deviceSn + ",SrcLunId:" + srcLunId + ",TgtLunId:" + targetLunId + ",ErrorCode:" + errorCode), 90160758784001L);
            }
        }
        return hyperCloneTargetLun;
    }

    private List<HyperCloneTargetLunVO> getOptimalCloneTargetLun(List<HyperCloneTargetLunVO> hyperCloneTargetLunVOs, StoragePoolResourceCache resourceCache) {
        ArrayList<HyperCloneTargetLunVO> optimalHyperCloneTargetLunVOs = new ArrayList<HyperCloneTargetLunVO>();
        if (VerifyUtil.isEmpty(hyperCloneTargetLunVOs)) {
            logger.debug((Object)"hyperCloneTargetLunVOs is empty!");
            return optimalHyperCloneTargetLunVOs;
        }
        for (HyperCloneTargetLunVO targetLunVo : hyperCloneTargetLunVOs) {
            if (!resourceCache.isExistedAndUnusedResource(targetLunVo.getTargetLun().getUuid())) continue;
            optimalHyperCloneTargetLunVOs.add(targetLunVo);
        }
        return optimalHyperCloneTargetLunVOs;
    }

    private boolean isUsedHyperCloneTargetLunByPg(HyperCloneTargetLunVO targetLunVO, String pgId) {
        logger.debug((Object)("pgId:" + pgId));
        return this.isUsedTargetLunByOtherPg(targetLunVO.getSrcLun().getDevSn(), targetLunVO.getSrcLun().getLunId(), targetLunVO.getTargetLun().getDevSn(), targetLunVO.getTargetLun().getLunId(), targetLunVO.getPairId(), pgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUsedTargetLunByOtherPg(String srcDevSn, String srcLunId, String tgtDevSn, String tgtLunId, String pairId, String pgId) {
        Session session;
        block6: {
            boolean bl;
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                StringBuilder querySQL = new StringBuilder();
                querySQL.append("select a.* from ti_relicastorageinfo a, ti_storagehyperclonereplica b");
                querySQL.append(",ti_protectobjectreplica c, ti_protectgroupreplica d ");
                querySQL.append("where d.pgid !=:pgId and a.poreplicaid=c.id and d.id=c.PGREPLICAID ");
                querySQL.append("and a.repilcastor_id=b.repilcastor_id and a.srcprovsn=:srcDevSn and ");
                querySQL.append("a.srcdevid=:srcLunId and a.provsn=:tgtDevSn and a.devid=:tgtLunId and b.pairId=:pairId");
                NativeQuery query = session.createSQLQuery(querySQL.toString());
                if (VerifyUtil.isEmpty((String)pgId)) {
                    query.setString("pgId", "null");
                } else {
                    query.setString("pgId", pgId);
                }
                query.setString("srcDevSn", srcDevSn);
                query.setString("srcLunId", srcLunId);
                query.setString("tgtDevSn", tgtDevSn);
                query.setString("tgtLunId", tgtLunId);
                query.setString("pairId", pairId);
                List results = query.list();
                if (!VerifyUtil.isEmpty((Collection)results)) break block6;
                bl = false;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("isUsedHyperCloneTargetLun failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
            DBOperationUtil.closeSession((Session)session);
            return bl;
        }
        DBOperationUtil.closeSession((Session)session);
        return true;
    }

    private HyperClonePair createNewlyHyperClonePair(Lun srcLun, String tgtLunId, StoragePoolResourceCache poolResourceCache) {
        IStorageHyperCloneManager hyperCloneMgr = StorageHyperCloneManagerProxy.getInstance().getStorageHyperCloneManager(srcLun.getDevSn());
        List<Lun> optimalTargetLuns = this.getAvailableTargetLuns(srcLun, tgtLunId);
        HyperClone hyperClone = this.createHyperClone(srcLun, hyperCloneMgr);
        HyperCloneTargetLunVO cloneTargetLunVO = this.addCloneTargetLunWithRetry(hyperClone, srcLun, optimalTargetLuns, hyperCloneMgr);
        if (null == cloneTargetLunVO.getHyperCloneTargetLun() || null == cloneTargetLunVO.getTargetLun()) {
            logger.error((Object)("hyperCloneTargetLun:" + cloneTargetLunVO.getHyperCloneTargetLun() + ", selectedLun:" + cloneTargetLunVO.getTargetLun()));
            throw new LegoCheckedException(1073948222L);
        }
        DrmStorageUtil.saveOrUpdateHyperCloneTargetLun((String)srcLun.getDevSn(), (HyperCloneTargetLun)cloneTargetLunVO.getHyperCloneTargetLun());
        HyperClonePair hyperClonePair = this.constructHyperClonePair(srcLun.getDevSn(), srcLun.getLunId(), cloneTargetLunVO.getTargetLun().getLunId(), cloneTargetLunVO.getHyperCloneTargetLun().getPairId());
        hyperClonePair.setNewlyCreated(true);
        this.recordNewlyHyperClonePair(hyperClonePair);
        poolResourceCache.updateStoragePoolResource(cloneTargetLunVO.getTargetLun().getUuid(), true);
        return hyperClonePair;
    }

    private List<Lun> getAvailableTargetLuns(Lun srcLun, String tgtLunId) {
        StoragePoolResourceCache resourceCache = this.geteStoragePoolResourceCache();
        ArrayList<Lun> targetLuns = new ArrayList<Lun>();
        List<Lun> optimalTargetLuns = resourceCache.getMatchedOptimalTargetLun(srcLun);
        if (!VerifyUtil.isEmpty((String)tgtLunId) && resourceCache.isExists(srcLun.getDevSn(), tgtLunId)) {
            IStorageResourceService resourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
            Lun lun = (Lun)resourceService.getStorageResource(srcLun.getDevSn(), tgtLunId, Lun.class);
            targetLuns.add(lun);
        }
        if (!VerifyUtil.isEmpty(optimalTargetLuns)) {
            targetLuns.addAll(optimalTargetLuns);
        }
        if (VerifyUtil.isEmpty(targetLuns)) {
            logger.error((Object)"targetLuns is empty!");
            throw new LegoCheckedException(1073948222L);
        }
        return targetLuns;
    }

    private HyperClone createHyperClone(Lun srcLun, IStorageHyperCloneManager hyperCloneMgr) {
        HyperClone hyperClone = hyperCloneMgr.getHyperClone(srcLun.getDevSn(), srcLun.getLunId());
        if (null == hyperClone) {
            hyperClone = hyperCloneMgr.createHyperClone(srcLun.getDevSn(), srcLun.getLunId(), srcLun.getLunId() + "-" + System.currentTimeMillis(), "");
        }
        DrmStorageUtil.saveOrUpdateHyperClone((String)srcLun.getDevSn(), (HyperClone)hyperClone);
        return hyperClone;
    }

    private HyperCloneTargetLunVO addCloneTargetLunWithRetry(HyperClone hyperClone, Lun srcLun, List<Lun> targetLuns, IStorageHyperCloneManager hyperCloneMgr) {
        HyperCloneTargetLunVO cloneTargetLunVO = new HyperCloneTargetLunVO();
        for (Lun optimalTargetLun : targetLuns) {
            String srcLunId = srcLun.getLunId();
            String targetLunId = optimalTargetLun.getLunId();
            HyperCloneTargetLun cloneTargetLun = this.addHyperCloneTargetLun(srcLun.getDevSn(), srcLunId, targetLunId, hyperClone, hyperCloneMgr);
            if (null == cloneTargetLun) continue;
            cloneTargetLunVO.setTargetLun(optimalTargetLun);
            cloneTargetLunVO.setHyperCloneTargetLun(cloneTargetLun);
            break;
        }
        return cloneTargetLunVO;
    }

    private HyperClonePair constructHyperClonePair(String deviceSN, String srcLunId, String tgtLunId, String pairId) {
        HyperClonePair pair = new HyperClonePair();
        pair.setDeviceSn(deviceSN);
        pair.setPairId(pairId);
        pair.setSrcLunId(srcLunId);
        pair.setTgtLunId(tgtLunId);
        logger.debug((Object)("deviceSN:" + deviceSN + ", pairId:" + pairId + ", srcLunId:" + srcLunId));
        return pair;
    }

    private CloneConsistentGroupCache getCloneConsistentGroupCache() {
        return (CloneConsistentGroupCache)this.getBuilderContext().get(CLONE_CG_CACHE);
    }

    private StoragePoolResourceCache geteStoragePoolResourceCache() {
        return (StoragePoolResourceCache)this.getBuilderContext().get(STORAGE_RESOURCE_CACHE);
    }
}

