/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.sdk.model.StoragePoolResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class StoragePoolResourceCache {
    public static final String INVALID_RESOURCE_POOL_ID = "-1";
    private String associatedPoolUuid;
    private Map<String, StoragePoolResource> cache = new ConcurrentHashMap<String, StoragePoolResource>();

    StoragePoolResourceCache() {
    }

    public String getAssociatedPoolUuid() {
        return this.associatedPoolUuid;
    }

    public void setAssociatedPoolUuid(String associatedPoolUuid) {
        this.associatedPoolUuid = associatedPoolUuid;
    }

    public void addStorageResources(List<StorageResource> storageResources) {
        if (VerifyUtil.isEmpty(storageResources)) {
            return;
        }
        for (StorageResource storageResource : storageResources) {
            if (null != this.cache.get(storageResource.getUuid())) continue;
            StoragePoolResource poolResource = new StoragePoolResource();
            poolResource.setStorageResource(storageResource);
            poolResource.setResourceId(storageResource.getResourceId());
            poolResource.setResourceUuid(storageResource.getResourceIndentifier());
            poolResource.setIsUsed(Boolean.valueOf(false));
            this.cache.put(storageResource.getUuid(), poolResource);
        }
    }

    public void addStoragePoolResources(List<StoragePoolResource> storagePoolResources) {
        if (VerifyUtil.isEmpty(storagePoolResources)) {
            return;
        }
        for (StoragePoolResource poolResource : storagePoolResources) {
            if (null != this.cache.get(poolResource.getResourceUuid())) continue;
            this.cache.put(poolResource.getStorageResource().getUuid(), poolResource);
        }
    }

    public void addStorageResource(StorageResource storageResource) {
        if (null == storageResource || null != this.cache.get(storageResource.getUuid())) {
            return;
        }
        StoragePoolResource poolResource = new StoragePoolResource();
        poolResource.setStorageResource(storageResource);
        poolResource.setResourceId(storageResource.getResourceId());
        poolResource.setResourceUuid(storageResource.getResourceIndentifier());
        poolResource.setIsUsed(Boolean.valueOf(false));
        this.cache.put(storageResource.getUuid(), poolResource);
    }

    public List<StorageResource> getUnusedStorageResources() {
        ArrayList<StorageResource> unusedStorageResources = new ArrayList<StorageResource>();
        Set<Map.Entry<String, StoragePoolResource>> entrySet = this.cache.entrySet();
        for (Map.Entry<String, StoragePoolResource> entry : entrySet) {
            if (entry.getValue().getIsUsed().booleanValue()) continue;
            unusedStorageResources.add(entry.getValue().getStorageResource());
        }
        return unusedStorageResources;
    }

    public void updateStoragePoolResource(String resourceUuid, boolean isUsed) {
        StoragePoolResource poolResource = this.cache.get(resourceUuid);
        if (null != poolResource) {
            poolResource.setIsUsed(Boolean.valueOf(isUsed));
        }
    }

    public boolean isExistedAndUnusedResource(String resourceUuid) {
        StoragePoolResource poolResource = this.cache.get(resourceUuid);
        return null != poolResource && poolResource.getIsUsed() == false;
    }

    public List<Lun> getMatchedOptimalTargetLun(Lun srcLun) {
        ArrayList<Lun> targetLuns = new ArrayList<Lun>();
        Set<Map.Entry<String, StoragePoolResource>> entrySet = this.cache.entrySet();
        for (Map.Entry<String, StoragePoolResource> entry : entrySet) {
            Lun targetLun;
            if (entry.getValue().getIsUsed().booleanValue() || !(entry.getValue().getStorageResource() instanceof Lun) || !(targetLun = (Lun)entry.getValue().getStorageResource()).getDevSn().equals(srcLun.getDevSn()) || targetLun.getLunId().equals(srcLun.getLunId()) || !targetLun.getTotalCapacity().equals(srcLun.getTotalCapacity()) || !targetLun.getTotalCapacityUnit().equals(srcLun.getTotalCapacityUnit()) || !targetLun.getControllerId().equals(srcLun.getControllerId())) continue;
            targetLuns.add(targetLun);
        }
        return targetLuns;
    }

    public boolean isExists(String deviceSn, String lunId) {
        Set<Map.Entry<String, StoragePoolResource>> entrySet = this.cache.entrySet();
        for (Map.Entry<String, StoragePoolResource> entry : entrySet) {
            Lun targetLun;
            StorageResource resource = entry.getValue().getStorageResource();
            if (!(resource instanceof Lun) || !(targetLun = (Lun)resource).getDevSn().equals(deviceSn) || !targetLun.getResourceId().equals(lunId)) continue;
            return true;
        }
        return false;
    }
}

