/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.factory;

import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaTools;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.protection.replica.factory.AbstractReplicaFactory;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CascadedSnapshotReplicaFactory
extends AbstractReplicaFactory {
    private static final Log logger = LogFactory.getInstance(CascadedSnapshotReplicaFactory.class);

    public ProtectGroupReplica createReplica(ProtectGroupReplica sourceReplica) {
        String devId = sourceReplica.getStorageDeviceId();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        StorageLicense license = storageService.getStorageAllLicense(devId);
        if (!(5 == sourceReplica.getType() && license.isSupportFeature("2") || 3 == sourceReplica.getType() && license.isSupportFeature("10000"))) {
            logger.error((Object)("The replica (" + sourceReplica.getId() + "-" + sourceReplica.getName() + ") can not create replica"));
            throw new LegoCheckedException(1073948693L);
        }
        ProtectGroupReplica cloneReplica = null;
        try {
            cloneReplica = (ProtectGroupReplica)sourceReplica.clone();
            cloneReplica.setId(UUIDGenerator.getUUID());
            cloneReplica.setName("CascadeSnapshot_" + this.buildReplicaName(sourceReplica));
            cloneReplica.setSourceReplicaId(sourceReplica.getId());
            cloneReplica.setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNTED.getStatus()));
            cloneReplica.setMountedHost("--");
            cloneReplica.addProperty("planId", null);
            cloneReplica.setGeneration(Integer.valueOf(2));
            cloneReplica.setType(3);
            Set replicaList = cloneReplica.getReplicas();
            HashMap<String, Snapshot> snapshotMap = new HashMap<String, Snapshot>();
            this.cascadeReplicaInit(devId, replicaList, snapshotMap);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"An error occurred while cloning a copy");
        }
        return cloneReplica;
    }

    private void cascadeReplicaInit(String devId, Set<ProtectObjectReplica> replicaList, Map<String, Snapshot> snapshotMap) {
        for (ProtectObjectReplica protectObjectReplica : replicaList) {
            protectObjectReplica.setId(UUIDGenerator.getUUID());
            Set protectObjectStorageList = protectObjectReplica.getStorageInfos();
            for (RelicaStorageInfo storageInfo : protectObjectStorageList) {
                IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devId);
                String srcDevId = storageInfo.getStorageId();
                String lunId = storageInfo.getSrcStorageId();
                String casadedSnapshotName = "DRdata_" + lunId + "_" + System.currentTimeMillis();
                Snapshot snapshot = snapshotMap.get(storageInfo.getSrcStorageId());
                if (null == snapshot) {
                    snapshot = new Snapshot();
                    snapshot.setParentMo((ManagedObject)new Snapshot());
                    snapshot.setDescription("this snapshot copy from snapshot or clone.");
                    snapshot.setName(casadedSnapshotName);
                    snapshot = proxy.createSnapshot(devId, Collections.singletonList(srcDevId), snapshot);
                    OperationResult result = proxy.activeSnapshot(devId, Collections.singletonList(snapshot.getSnapshotId()));
                    if (result != null && !result.isSuccess()) {
                        logger.error((Object)("active snapshot got error. snapshotId:" + snapshot.getSnapshotId()));
                        throw new LegoCheckedException(1073948689L);
                    }
                    snapshotMap.put(storageInfo.getSrcStorageId(), snapshot);
                }
                storageInfo.setStorageId(snapshot.getSnapshotId());
                ((LocalStorageReplica)storageInfo).setSnapshotName(casadedSnapshotName);
            }
        }
    }

    public boolean validReplica(ProtectGroupReplica replica, boolean needHandleException) {
        return CheckReplicaTools.checkSnapshotCorrect((ProtectGroupReplica)replica, (boolean)needHandleException);
    }

    public int getFactoryType() {
        return 10;
    }
}

