/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.factory;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.protection.replica.factory.SnapshotReplicaFactory;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class NasSnapshotReplicaFactory
extends SnapshotReplicaFactory {
    private static final Log LOGGER = LogFactory.getInstance(NasSnapshotReplicaFactory.class);

    @Override
    public ProtectGroupReplica createReplica(ProtectGroupReplica sourceReplica) {
        throw new UnsupportedOperationException("The operation is not supported.");
    }

    @Override
    public int getFactoryType() {
        return 8;
    }

    @Override
    protected void deleteReplica(ProtectGroupReplica replica, boolean isNeedSendAlarm) {
        if (VerifyUtil.isEmpty((Object)replica)) {
            LOGGER.info((Object)"There are no snapshots need to delete");
            return;
        }
        boolean isSecureSnapShot = Boolean.parseBoolean(Optional.ofNullable(replica.getProps().get("isNeedSecureSnapshot")).orElse("false"));
        if (!isSecureSnapShot) {
            super.deleteReplica(replica, isNeedSendAlarm);
        }
        LOGGER.info((Object)"Not need to delete secure snapshot on storage. replica name: %s", new Object[]{replica.getName()});
    }

    @Override
    protected List<Snapshot> querySnapshot(LocalStorageReplica localStorageReplica) {
        String deviceSN = localStorageReplica.getSrcStorageProviderSN();
        String fsId = localStorageReplica.getSrcStorageId();
        String snapshotId = localStorageReplica.getStorageId();
        StorageFileSystemSnapshotManagerProxy storageManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance();
        IStorageFileSystemSnapshotManager proxy = storageManagerProxy.getStorageFileSystemSnapshotManager(deviceSN);
        Snapshot snapshot = proxy.querySpecificSnapshot(deviceSN, fsId, snapshotId);
        return Arrays.asList(snapshot);
    }

    @Override
    protected OperationResult deleteSnapshot(LocalStorageReplica localStorageReplica, Snapshot snapshot) {
        String deviceSN = localStorageReplica.getSrcStorageProviderSN();
        String snapshotId = snapshot.getId();
        LOGGER.info((Object)"Delete snapshot{%s} on the storage device{%s}.", new Object[]{snapshotId, deviceSN});
        StorageFileSystemSnapshotManagerProxy storageManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance();
        IStorageFileSystemSnapshotManager proxy = storageManagerProxy.getStorageFileSystemSnapshotManager(deviceSN);
        return proxy.deleteSnapshot(deviceSN, snapshotId);
    }
}

