/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.realtime;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.impl.AbstractReplicaRealTimeBuilder;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.recovery.framework.task.MountBackTaskHandler;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySanHyperVaultBuilder;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArraySanHyperVaultRealTimeBuilder
extends AbstractReplicaRealTimeBuilder {
    private static final String REPLICATIONBOS_KEY = "replicationBo";
    private static final String PRODUCT_DEVICE_SN_PREFIX = "PRODUCT_DEVICE_SN_LOCATION_";
    private static final String DISATER_DEVICE_SN_PREFIX = "DISATER_DEVICE_SN_LOCATION_";
    private static final String PROTECT_GROUP = "PROTECT_GROUP";
    private static Log logger = LogFactory.getInstance(ArraySanHyperVaultRealTimeBuilder.class);
    private ArraySanHyperVaultBuilder arraySanHyperVaultBuilder;

    public ProtectGroupReplica buildReplica(ProtectGroup protectGroup, int protectLocation) {
        this.check(protectGroup, protectLocation);
        ExecutionContext context = this.initData(protectGroup, protectLocation);
        return this.buildProtectGroupReplica(context, protectLocation);
    }

    public void callBackReplica(final ProtectGroupReplica replica) {
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Asynchronous task to delete snapshots for VASA: {replicaId=%s, pgId=%s}", new Object[]{replica.getId(), replica.getPg() == null ? null : replica.getPg().getUuid()});
            }
            BackTask backTask = new BackTask();
            MountBackTaskHandler.getInstance().submitTask(new AbstractBackTask(replica.getId() + UUIDGenerator.getUUID(), backTask, false){

                protected void doWork() {
                    ArraySanHyperVaultRealTimeBuilder.this.arraySanHyperVaultBuilder.deleteSnapshots(replica);
                }
            });
            return;
        }
        this.arraySanHyperVaultBuilder.deleteSnapshots(replica);
    }

    public PolicyTemplateType.POLICY_TEMPLATE_E getType() {
        return PolicyTemplateType.POLICY_TEMPLATE_E.ARRAY_SAN_HYPERVAULT;
    }

    protected void check(ProtectGroup protectGroup, int protectLocation) {
        if (protectGroup == null) {
            logger.error((Object)"protectGroup is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (protectLocation != DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue() && protectLocation != DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue()) {
            logger.error((Object)("protectLocation is not right!protectLocation:" + protectLocation));
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected ExecutionContext initData(ProtectGroup protectGroup, int protectLocation) {
        ExecutionContext context = new ExecutionContext();
        context.setAttribute(PROTECT_GROUP, (Object)protectGroup);
        ProtectGroupReplica replica = null;
        for (ProtectGroupReplica protectGroupReplica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)protectGroupReplica) || protectGroupReplica.getProtectLocation() != protectLocation) continue;
            replica = protectGroupReplica;
            break;
        }
        ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
        IReplicaBuilder builder = factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        Map stroageInfos = builder.getAllStroageInfo(protectGroup);
        String devSn = (String)devSns.get(protectLocation);
        this.setDeviceSN(context, replica, devSns, protectLocation);
        List list = (List)stroageInfos.get(devSn);
        context.setAttribute(REPLICATIONBOS_KEY, (Object)list);
        return context;
    }

    protected ProtectGroupReplica buildProtectGroupReplica(ExecutionContext context, int location) {
        logger.debug((Object)("buildProtectGroupReplica. location:" + location));
        ProtectGroup protectGroup = this.getPG(context);
        ProtectGroupReplica protectGroupReplica = new ProtectGroupReplica();
        protectGroupReplica.setId(UUIDGenerator.getUUID());
        protectGroupReplica.setName("SNAPSHOT-" + protectGroup.getName() + "-" + Calendar.getInstance().getTimeInMillis());
        protectGroupReplica.setType(this.getReplicaType(protectGroup, location));
        protectGroupReplica.setPg(protectGroup);
        protectGroupReplica.setProtectLocation(location);
        String productDevSn = (String)context.getAttribute(PRODUCT_DEVICE_SN_PREFIX, String.class);
        String disaterDevSn = (String)context.getAttribute(DISATER_DEVICE_SN_PREFIX, String.class);
        String siteId = this.getSiteByArraySn(disaterDevSn);
        protectGroupReplica.setRecoverySite(siteId);
        protectGroupReplica.setProductArray(productDevSn);
        protectGroupReplica.setRecoveryArray(disaterDevSn);
        protectGroup.getReplicaList().add(protectGroupReplica);
        this.buildProtectObjectReplica(context, protectGroupReplica);
        return protectGroupReplica;
    }

    private void buildProtectObjectReplica(ExecutionContext context, ProtectGroupReplica protectGroupReplica) {
        ProtectGroup protectGroup = this.getPG(context);
        long startTime = System.currentTimeMillis();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ProtectObjectReplica poReplica = new ProtectObjectReplica();
            poReplica.setId(UUIDGenerator.getUUID());
            poReplica.setPoId(protectObject.getUuid());
            poReplica.setProtectObject(protectObject);
            poReplica.setPgReplica(protectGroupReplica);
            IProtectObjectProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
            provider.backUpPoMetadata(poReplica);
            protectGroupReplica.getReplicas().add(poReplica);
            this.buildPoStorageInfoReplica(context, protectObject, poReplica);
        }
        logger.debug((Object)("build protectObject replica cost time:" + (System.currentTimeMillis() - startTime)));
    }

    private void buildPoStorageInfoReplica(ExecutionContext context, ProtectObject protectObject, ProtectObjectReplica poReplica) {
        Set usedStorageResourceSet = protectObject.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.error((Object)("usedStorageResourceSet is empty!" + this.getMsg(this.getPG(context))));
            throw new LegoCheckedException(1073948453L);
        }
        for (ProtectObjectStorageInfo poStorageInfo : usedStorageResourceSet) {
            this.buildPoStorageInfo(context, poReplica, poStorageInfo);
        }
    }

    protected void buildPoStorageInfo(ExecutionContext context, ProtectObjectReplica poReplica, ProtectObjectStorageInfo poStorageInfo) {
        String resourceId = null;
        String resourceProviderSN = null;
        String wwn = null;
        List storageInfos = (List)context.getAttribute(REPLICATIONBOS_KEY);
        for (ProtectObjectStorageInfo storageInfo : storageInfos) {
            if (!storageInfo.getLunWWN().equals(poStorageInfo.getLunWWN())) continue;
            wwn = storageInfo.getLunWWN();
            resourceId = storageInfo.getResourceId();
            resourceProviderSN = storageInfo.getResourceProviderSN();
            break;
        }
        if (VerifyUtil.isEmpty(resourceId) || VerifyUtil.isEmpty(resourceProviderSN)) {
            logger.error((Object)"resourceId or resourceProviderSN is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String snapshotName = PolicyTemplateTools.getInstance().generateSnapshotName(resourceId);
        String snapshotId = "NONE";
        this.buildLocalReplica(poReplica, snapshotId, snapshotName, resourceId, resourceProviderSN, wwn);
    }

    protected LocalStorageReplica buildLocalReplica(ProtectObjectReplica poReplica, String snapshotId, String snapshotName, String resourceId, String resourceProviderSN, String wwn) {
        logger.debug((Object)("snapshotId:" + snapshotId + ", snapshotNm:" + snapshotName));
        LocalStorageReplica localStorageReplica = new LocalStorageReplica();
        localStorageReplica.setId(UUIDGenerator.getUUID());
        localStorageReplica.setSnapshotName(snapshotName);
        localStorageReplica.setSrcStorageId(resourceId);
        localStorageReplica.setSrcStorageProviderSN(resourceProviderSN);
        localStorageReplica.setStorageId(snapshotId);
        localStorageReplica.setStorageProviderSN(resourceProviderSN);
        localStorageReplica.setPoReplica(poReplica);
        localStorageReplica.setProtectObjectStorageWwn(wwn);
        poReplica.getStorageInfos().add(localStorageReplica);
        return localStorageReplica;
    }

    protected ProtectGroup getPG(ExecutionContext context) {
        return (ProtectGroup)context.getAttribute(PROTECT_GROUP, ProtectGroup.class);
    }

    protected void setDeviceSN(ExecutionContext context, ProtectGroupReplica replica, Map<Integer, String> devSns, int protectLocation) {
        String devSn = devSns.get(protectLocation);
        context.setAttribute(PRODUCT_DEVICE_SN_PREFIX, (Object)devSn);
        context.setAttribute(DISATER_DEVICE_SN_PREFIX, (Object)devSn);
        if (replica == null) {
            if (protectLocation == DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue() || protectLocation == DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue()) {
                logger.debug((Object)"Set product device and disaster device sn with deSn: %s.", new Object[]{devSn});
                return;
            }
            logger.error((Object)"remoteReplica not exists.");
            throw new LegoCheckedException(1073947393L);
        }
        if (protectLocation == DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue() || protectLocation == DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue() || protectLocation == DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue()) {
            context.setAttribute(DISATER_DEVICE_SN_PREFIX, (Object)replica.getRecoveryArray());
            context.setAttribute(PRODUCT_DEVICE_SN_PREFIX, (Object)replica.getProductArray());
        }
    }

    protected String getMsg(ProtectGroup protectGroup) {
        return " [pgName:" + protectGroup.getName() + ", pgId:" + protectGroup.getUuid() + "]";
    }

    public void setArraySanHyperVaultBuilder(ArraySanHyperVaultBuilder arraySanHyperVaultBuilder) {
        this.arraySanHyperVaultBuilder = arraySanHyperVaultBuilder;
    }
}

