/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperVaultFilter
extends AbstractPolicyTemplateFilter {
    private static final Log logger = LogFactory.getInstance(ArrayHyperVaultFilter.class);
    private static final String SRC_DEVICE_SN = "SRC_DEVICE_SN";
    private static final String POLICY_TEMPLATE = "POLICY_TEMPLATE";
    private static final String SRC_RESOURCE_ID = "SRC_RESOURCE_ID";
    private static final String SRC_DEVICE_SITE = "SRC_DEVICE_SITE";
    private static final String TARGET_DEVICE_SITE = "TARGET_DEVICE_SITE";
    private static final String HYPER_VAULT = "HYPERVAULT";
    private static final String PO_LIST = "PO_LIST";

    public boolean isMatch(List<ProtectObject> protectObjects) {
        return false;
    }

    public boolean isMatch(List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"));
        this.checkParam(protectObjects, policyTemplate);
        boolean flag = false;
        ExecutionContext context = this.init(protectObjects, policyTemplate);
        try {
            this.check(context, policyTemplate);
            this.setProtectionRelation(context);
            flag = true;
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)(((Object)((Object)this)).getClass().getSimpleName() + " failed!errorcode:" + e.getErrorCode()));
            throw e;
        }
        finally {
            logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch " + flag));
        }
        return flag;
    }

    private void checkParam(List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        if (VerifyUtil.isEmpty(protectObjects) || policyTemplate == null) {
            logger.error((Object)("protectObjects or policyTemplate is empty!policyTemplate:" + policyTemplate), 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    private ExecutionContext init(List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        ExecutionContext context = new ExecutionContext();
        context.setAttribute(PO_LIST, protectObjects);
        context.setAttribute(POLICY_TEMPLATE, (Object)policyTemplate);
        return context;
    }

    private void check(ExecutionContext context, PolicyTemplate policyTemplate) {
        this.checkIsSameNasFile(context);
        this.checkDeviceRegistered(context);
        this.checkIsSameSiteWithApp(context);
        boolean isHyperVault = this.existHyperVaultRelation(context);
        if (policyTemplate.getType() == 17 && !isHyperVault) {
            logger.error((Object)"resource is not hyper vault for ARRAY_HYPER_VAULT", 90160758786989L);
            throw new LegoCheckedException(1073948242L);
        }
        if (!isHyperVault) {
            this.existOtherProtection(context);
            return;
        }
        this.checkTargetDeviceRegistered(context);
        this.checkHyperVaultStatus(context);
    }

    private void checkIsSameSiteWithApp(ExecutionContext context) {
        Site srcDeviceSite = (Site)context.getAttribute(SRC_DEVICE_SITE, Site.class);
        List<ProtectObject> protectObjectList = this.getProtectObjectList(context);
        HashSet<String> providerSnSet = new HashSet<String>();
        for (ProtectObject po : protectObjectList) {
            providerSnSet.add(po.getProviderSN());
        }
        for (String providerSN : providerSnSet) {
            Site providerSite = this.getSiteFromSn(providerSN);
            if (providerSite.getSiteId().equals(srcDeviceSite.getSiteId())) continue;
            logger.error((Object)("the providerSite is not same with the srcDevicesite! providerSite:" + providerSite.getName() + ", srcDevicesite:" + srcDeviceSite.getName()), 90160758786897L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkHyperVaultStatus(ExecutionContext context) {
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPER_VAULT, HyperVault.class);
        String healthStateStr = hyperVault.getHealthState();
        String normalStateStr = String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue());
        if (!normalStateStr.equals(healthStateStr)) {
            logger.error((Object)("the health status is not normal! healthStatus:" + healthStateStr));
            throw new LegoCheckedException(1073948239L);
        }
    }

    private void checkTargetDeviceRegistered(ExecutionContext context) {
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPER_VAULT, HyperVault.class);
        String targetDeviceSN = hyperVault.getRemoteDeviceSn();
        if (VerifyUtil.isEmpty((String)targetDeviceSN)) {
            logger.error((Object)"targetDeviceSN is empty!", 90160758786989L);
            throw new LegoCheckedException(1073948245L);
        }
        Site targetSite = this.getSiteFromSn(targetDeviceSN);
        this.checkIsLocalSite(targetDeviceSN, targetSite);
        context.setAttribute(TARGET_DEVICE_SITE, (Object)targetSite);
    }

    private void existOtherProtection(ExecutionContext context) {
        String srcResourceId = (String)context.getAttribute(SRC_RESOURCE_ID, String.class);
        String srcDeviceSn = (String)context.getAttribute(SRC_DEVICE_SN, String.class);
        ArrayList<String> nasIdList = new ArrayList<String>();
        nasIdList.add(srcResourceId);
        this.existNasFileSystem(srcResourceId, srcDeviceSn, nasIdList);
        List pairs = this.queryValidReplicationPairsBy(srcDeviceSn, nasIdList, true, DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue());
        if (!VerifyUtil.isEmpty((Collection)pairs)) {
            logger.warn((Object)("the nas file system[deviceSN:" + srcDeviceSn + ",nasID:" + srcResourceId + "] exist remote replication pair."), 90160758786989L);
            throw new LegoCheckedException(1073948240L);
        }
        List<HyperMetroPair> hyperMetroPairList = this.queryHyperMetroPair(srcDeviceSn, nasIdList);
        if (!VerifyUtil.isEmpty(hyperMetroPairList)) {
            logger.warn((Object)("the nas file system[deviceSN:" + srcDeviceSn + ",nasID:" + srcResourceId + "] exist hyperMetro pair."), 90160758786989L);
            throw new LegoCheckedException(1073948240L);
        }
    }

    private List<HyperMetroPair> queryHyperMetroPair(String devSn, List<String> lunIds) {
        List pairList = null;
        try {
            pairList = this.getStorageResourceService().getHyperMetroPairByFileSystems(devSn, lunIds, null, Boolean.valueOf(true));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("query replicationpairs error." + devSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            return new ArrayList<HyperMetroPair>();
        }
        return pairList;
    }

    private void existNasFileSystem(String resourceId, String srcDeviceSn, List<String> nasIdList) {
        List nasList = null;
        try {
            nasList = this.getStorageResourceService().getStorageResources(srcDeviceSn, nasIdList, NasFileSystem.class);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("query nas error: " + srcDeviceSn + ", resourceId:" + resourceId), (long)1073948705L, (String[])new String[0], (Log)logger);
        }
        if (VerifyUtil.isEmpty((Collection)nasList)) {
            logger.warn((Object)("can't get nas info(" + srcDeviceSn + "_" + resourceId + ")."), 90160758786989L);
            throw new LegoCheckedException(1073948685L, new String[]{resourceId, srcDeviceSn});
        }
    }

    private boolean existHyperVaultRelation(ExecutionContext context) {
        boolean flag = false;
        String devSn = (String)context.getAttribute(SRC_DEVICE_SN, String.class);
        HyperVault hyperVault = this.getHyperVaultService(devSn).queryHyperVaultByResourceId(devSn, (String)context.getAttribute(SRC_RESOURCE_ID, String.class));
        if (hyperVault != null) {
            flag = true;
        }
        context.setAttribute(HYPER_VAULT, (Object)hyperVault);
        return flag;
    }

    private void setProtectionRelation(ExecutionContext context) {
        String srcDeviceSN = (String)context.getAttribute(SRC_DEVICE_SN, String.class);
        String srcResourceId = (String)context.getAttribute(SRC_RESOURCE_ID, String.class);
        Site srcDeviceSite = (Site)context.getAttribute(SRC_DEVICE_SITE, Site.class);
        ArrayList poList = (ArrayList)context.getAttribute(PO_LIST, ArrayList.class);
        Integer resourceType = DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue();
        if (!VerifyUtil.isEmpty((Collection)poList)) {
            Set storageResourceSet = ((ProtectObject)poList.get(0)).getUsedStorageResourceSet();
            resourceType = ((ProtectObjectStorageInfo)storageResourceSet.stream().findFirst().get()).getResourceType();
        }
        ProtectionRelation srcProtectionRelation = this.constructProtectionRelation("", srcResourceId, srcDeviceSN, srcDeviceSite, resourceType);
        ArrayList<ProtectionRelation> targetResources = new ArrayList<ProtectionRelation>();
        this.setTargetResource(context, targetResources, resourceType);
        srcProtectionRelation.setTargetResources(targetResources);
        PolicyTemplate policyTemplate = (PolicyTemplate)context.getAttribute(POLICY_TEMPLATE, PolicyTemplate.class);
        Map props = policyTemplate.getProps();
        if (props.get("protectionRelation") == null) {
            props.put("protectionRelation", ProtectionRelationJsonConverter.toJsonStr((ProtectionRelation)srcProtectionRelation, (boolean)false));
        }
    }

    private void setTargetResource(ExecutionContext context, List<ProtectionRelation> targetResources, Integer resourceType) {
        HyperVault hyperVault = (HyperVault)context.getAttribute(HYPER_VAULT, HyperVault.class);
        if (hyperVault != null) {
            Site targetSite = (Site)context.getAttribute(TARGET_DEVICE_SITE, Site.class);
            ProtectionRelation protectionRelation = this.constructProtectionRelation(hyperVault.getId(), hyperVault.getRemoteResourceId(), hyperVault.getRemoteDeviceSn(), targetSite, resourceType);
            targetResources.add(protectionRelation);
        }
    }

    private ProtectionRelation constructProtectionRelation(String pairId, String resourceId, String deviceSN, Site site, Integer resourceType) {
        ProtectionRelation protectionRelation = new ProtectionRelation();
        protectionRelation.setPairId(pairId);
        protectionRelation.setSrcResourceId(resourceId);
        protectionRelation.setSrcResourceProviderSn(deviceSN);
        protectionRelation.setSrcResourceName(ProtectionRelationJsonConverter.getResourceName((String)deviceSN, (String)resourceId, (Integer)resourceType));
        protectionRelation.setSrcResourceProviderName(ProtectionRelationJsonConverter.getResourceProviderName((String)deviceSN));
        protectionRelation.setSrcSiteId(site.getSiteId());
        protectionRelation.setSrcSiteName(site.getName());
        protectionRelation.setSrcResourceType(resourceType.toString());
        return protectionRelation;
    }

    private void checkDeviceRegistered(ExecutionContext context) {
        String srcDeviceSn = (String)context.getAttribute(SRC_DEVICE_SN, String.class);
        Site srcDevicesite = this.getSiteFromSn(srcDeviceSn);
        this.checkIsLocalSite(srcDeviceSn, srcDevicesite);
        context.setAttribute(SRC_DEVICE_SITE, (Object)srcDevicesite);
    }

    private void checkIsLocalSite(String deviceSn, Site devicesite) {
        if (devicesite.getSiteType() != 0) {
            logger.error((Object)("The array [" + deviceSn + "] registered site is not local! site name:" + devicesite.getName()), 90160758786897L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkIsSameNasFile(ExecutionContext context) {
        List<ProtectObject> poList = this.getProtectObjectList(context);
        String nasFileId = null;
        String srcDeviceSN = null;
        for (ProtectObject po : poList) {
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
                logger.error((Object)"usedStorageResourceSet is empty!", 90160758786989L);
                throw new LegoCheckedException(1073948191L);
            }
            for (ProtectObjectStorageInfo poStorageInfo : usedStorageResourceSet) {
                String resourceId = poStorageInfo.getResourceId();
                String resourceProviderSN = poStorageInfo.getResourceProviderSN();
                if (resourceId == null || resourceProviderSN == null) {
                    logger.error((Object)("resourceId or resourceProviderSN is empty! resourceId:" + resourceId + ", resourceProviderSN:" + resourceProviderSN), 90160758786989L);
                    throw new LegoCheckedException(1073948191L);
                }
                if (nasFileId == null) {
                    nasFileId = resourceId;
                    context.setAttribute(SRC_RESOURCE_ID, (Object)nasFileId);
                }
                if (srcDeviceSN == null) {
                    srcDeviceSN = resourceProviderSN;
                    context.setAttribute(SRC_DEVICE_SN, (Object)srcDeviceSN);
                }
                if (nasFileId.equals(resourceId) && srcDeviceSN.equals(resourceProviderSN)) continue;
                String errorMsg = "nasFileId:" + nasFileId + "\u3001" + resourceId + ". srcDeviceSN:" + srcDeviceSN + "\u3001" + resourceProviderSN;
                logger.error((Object)("nas file system is not the same! " + errorMsg), 90160758786989L);
                throw new LegoCheckedException(1073948241L);
            }
        }
    }

    private IStorageHyperVaultManager getHyperVaultService(String devSn) {
        IStorageHyperVaultManager service = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(devSn);
        if (service == null) {
            logger.error((Object)("to get the IStorageHyperVaultManager failed! devSn:" + devSn));
            throw new LegoCheckedException(-1L);
        }
        return service;
    }

    private List<ProtectObject> getProtectObjectList(ExecutionContext context) {
        return (List)context.getAttribute(PO_LIST);
    }

    public int getType() {
        return 17;
    }
}

