/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageVstoreReplicationPairManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreReplicationPairManager;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySanAirGapSnapshotFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ArrayNasAirGapSnapshotFilter
extends ArraySanAirGapSnapshotFilter {
    private static final Log LOGGER = LogFactory.getInstance(ArrayNasAirGapSnapshotFilter.class);
    private static final String EMPTY_VSTORE_REPLICATION_ID = "";

    @Override
    public int getType() {
        return 45;
    }

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            LOGGER.error((Object)"The parameter protectObjects is empty.");
            throw new LegoCheckedException(1073948191L);
        }
        this.saveDeviceSnToContext(protectObjects);
        this.checkResource(this.getFilterContext().get("airGapDevSn").toString(), true);
        this.checkAndSetAirGapNasSite(protectObjects);
        return true;
    }

    private void checkAndSetAirGapNasSite(List<ProtectObject> protectObjects) {
        this.checkNasFs(protectObjects);
        List<String> nasIdList = this.getResourceIds(this.getAllStorageInfo(protectObjects));
        String devSn = this.getFilterContext().get("airGapDevSn").toString();
        List pairs = this.getStorageService().getReplicationPairsByResourceIds(devSn, nasIdList, false, Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()));
        if (VerifyUtil.isEmpty((Collection)pairs) || protectObjects.size() != pairs.size()) {
            LOGGER.error((Object)"Some of the protected objects are not the slave end of the replication pair.");
            throw new LegoCheckedException(1073948191L);
        }
        Set srcDevSet = pairs.stream().map(ReplicationRelation::getSrcDevSN).collect(Collectors.toSet());
        if (srcDevSet.size() != 1) {
            LOGGER.error((Object)"Storage resource is illegal. devSn: %s", new Object[]{devSn});
            throw new LegoCheckedException(1073948191L);
        }
        String srcDevSn = (String)srcDevSet.stream().findFirst().get();
        this.checkResource(srcDevSn, false);
        String vstoreReplicationId = this.getVstoreReplicationId(protectObjects);
        if (ArrayNasAirGapSnapshotFilter.isValidVstorePairId(vstoreReplicationId)) {
            this.checkVstoreReplicationPair(vstoreReplicationId);
        }
        this.checkPair(pairs, vstoreReplicationId);
        ExecutionContext context = new ExecutionContext();
        context.setAttribute("pairList", (Object)pairs);
        this.getFilterContext().put("SITE_PROVIDER_CONTEXT", context);
        HashSet<String> devSnSetAirGap = new HashSet<String>();
        devSnSetAirGap.add(devSn);
        Site site = this.getSiteFromSn(devSn);
        HashSet<String> siteIdSetAirGap = new HashSet<String>();
        siteIdSetAirGap.add(site.getSiteId());
        List<SiteInfo> siteInfoList = Collections.singletonList(new SiteInfo(siteIdSetAirGap, devSnSetAirGap));
        this.getFilterContext().put("siteInfoList", siteInfoList);
    }

    private void checkPair(List<ReplicationPair> pairs, String vstoreReplicationId) {
        if (CollectionUtils.isEmpty(pairs)) {
            LOGGER.error((Object)"Get pair list error!");
            throw new LegoCheckedException(1073948191L);
        }
        boolean isVstoreReplicationIdEmpty = EMPTY_VSTORE_REPLICATION_ID.equals(vstoreReplicationId);
        for (ReplicationPair pair : pairs) {
            if (pair.getReplicationMode() != 2) {
                LOGGER.error((Object)"Pair mode is not Asynchronous!.");
                throw new LegoCheckedException(1073948191L);
            }
            String replicationPairId = pair.getReplicationId();
            if (ArrayNasAirGapSnapshotFilter.checkSinglePair(pair)) {
                LOGGER.error((Object)"The recovery policy or synchronization type of the replicated pair{%s} is not manual!", new Object[]{replicationPairId});
                String nasFsName = ((ReplicationTargetLun)pair.getRepTgtLuns().get(0)).getTgtLunName();
                throw new LegoCheckedException(1073948473L, new String[]{nasFsName});
            }
            if (isVstoreReplicationIdEmpty) {
                if (!ArrayNasAirGapSnapshotFilter.isValidVstorePairId(pair.getVstorePairId())) continue;
                LOGGER.error((Object)"The replication pair {%s} should not belong to a remote replication Vstore pair", new Object[]{replicationPairId});
                throw new LegoCheckedException(1073948478L);
            }
            if (!ArrayNasAirGapSnapshotFilter.isValidVstorePairId(pair.getVstorePairId())) {
                LOGGER.error((Object)"The replication pair {%s} should belong to a remote replication Vstore pair", new Object[]{replicationPairId});
                throw new LegoCheckedException(1073948479L);
            }
            if (vstoreReplicationId.equals(pair.getVstorePairId())) continue;
            LOGGER.error((Object)"Replication pair{%s} doesn't belong to the remote replication vStore pair{%s}", new Object[]{replicationPairId, vstoreReplicationId});
            throw new LegoCheckedException(1073948476L);
        }
    }

    protected void saveDeviceSnToContext(List<ProtectObject> protectObjects) {
        HashSet providerSnSet = new HashSet();
        protectObjects.stream().map(ProtectObject::getUsedStorageResourceSet).flatMap(Collection::stream).forEach(posi -> providerSnSet.add(posi.getResourceProviderSN()));
        if (providerSnSet.size() != 1) {
            LOGGER.error((Object)"The ProtectObject's device not the same as: %s", new Object[]{StringUtil.arrayToString((Object[])providerSnSet.toArray(new String[0]))});
            throw new LegoCheckedException(1073948192L);
        }
        String airGapDevSn = providerSnSet.stream().findFirst().orElse(EMPTY_VSTORE_REPLICATION_ID);
        this.getFilterContext().put("airGapDevSn", airGapDevSn);
    }

    private void checkNasFs(List<ProtectObject> protectObjects) {
        Set vStoreFsIdSet;
        for (ProtectObject protectObject : protectObjects) {
            if (protectObject.getPoType() == 14) continue;
            LOGGER.error((Object)"The type of protection object required by NAS airgap networking is NAS file system");
            throw new LegoCheckedException(1073948191L);
        }
        List allStorageInfo = this.getAllStorageInfo(protectObjects);
        List<String> nasIdList = this.getResourceIds(allStorageInfo);
        String deviceSN = this.getFilterContext().get("airGapDevSn").toString();
        String vStoreId = null;
        try {
            IStorageFileSystemManager fileSystemManagerProxy = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(deviceSN);
            vStoreId = this.getVstoreId(protectObjects);
            List nasFileSystems = fileSystemManagerProxy.queryFileSystems(deviceSN, vStoreId);
            vStoreFsIdSet = nasFileSystems.stream().map(StorageResource::getResourceId).collect(Collectors.toSet());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Error querying file system under vStore.(Device SN: %s, vStore id: %s)", new Object[]{deviceSN, vStoreId});
            throw new LegoCheckedException(1073947394L);
        }
        for (String nasId : nasIdList) {
            if (vStoreFsIdSet.contains(nasId)) continue;
            LOGGER.error((Object)"The file system(id: %s) does not belong to the vStore(id: %s).", new Object[]{nasId, vStoreId});
            throw new LegoCheckedException(1073948191L);
        }
    }

    private String getVstoreId(List<ProtectObject> protectObjects) {
        String vStoreId = Optional.ofNullable(protectObjects.get(0)).map(ProtectObject::getUsedStorageResourceSet).filter(item -> !VerifyUtil.isEmpty((Collection)item)).map(item -> ((ProtectObjectStorageInfo)item.iterator().next()).getVstoreId()).orElse(null);
        if (VerifyUtil.isEmpty((String)vStoreId)) {
            String poName = protectObjects.get(0).getName();
            LOGGER.error((Object)"The vstore information of NAS file system {%s} was not found", new Object[]{poName});
            throw new LegoCheckedException(1073947394L, new String[]{poName});
        }
        return vStoreId;
    }

    private List<String> getResourceIds(List<ProtectObjectStorageInfo> storageInfoList) {
        HashSet resourceIdSet = new HashSet();
        storageInfoList.forEach(storageInfo -> resourceIdSet.add(storageInfo.getResourceId().toLowerCase(Locale.getDefault())));
        return new ArrayList<String>(resourceIdSet);
    }

    private String getVstoreReplicationId(List<ProtectObject> protectObjects) {
        return Optional.ofNullable(protectObjects.get(0).getProps().get("PROP_KEY_VSTORE_REPLICATION_PAIR_ID")).orElse(EMPTY_VSTORE_REPLICATION_ID);
    }

    protected static boolean isValidVstorePairId(String vStoreReplicationId) {
        return !VerifyUtil.isEmpty((String)vStoreReplicationId) && !vStoreReplicationId.matches("-*");
    }

    private void checkVstoreReplicationPair(String vStorePairId) {
        String devSN = this.getFilterContext().get("airGapDevSn").toString();
        IStorageVstoreReplicationPairManager vstoreReplicationPairManager = StorageVstoreReplicationPairManagerProxy.getInstance().getMgrByDevId(devSN);
        VstoreReplicationPair vstoreReplicationPair = vstoreReplicationPairManager.queryVstorePairById(devSN, vStorePairId);
        if (VerifyUtil.isEmpty((Object)vstoreReplicationPair)) {
            LOGGER.error((Object)"The information of vstore replication pair {%s} is not found", new Object[]{vStorePairId});
            throw new LegoCheckedException(1073947394L);
        }
        if (vstoreReplicationPair.isCmoIdentityPreserve()) {
            LOGGER.error((Object)"Replication vstore pair{%s} has enabled synchronous sharing and authentication.", new Object[]{vstoreReplicationPair.getVstorePairId()});
            throw new LegoCheckedException(1073948480L);
        }
    }
}

