/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayHyperMetroAsynReplicationFilter;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ArraySanHyperMetroVaultFilter
extends ArrayHyperMetroAsynReplicationFilter {
    private static final Log logger = LogFactory.getInstance(ArraySanHyperMetroVaultFilter.class);

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        return super.isMatch(protectObjects);
    }

    @Override
    public int getType() {
        return 31;
    }

    @Override
    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        List paths = this.getReplicationProtectLocationPaths(protectObjects);
        ProtectObjectStorageInfo info = (ProtectObjectStorageInfo)protectObjects.iterator().next().getUsedStorageResourceSet().iterator().next();
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{info.getLunWWN()});
        if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 2) {
            logger.error((Object)("resources is empty or the size is not two!" + info.getLunWWN()), 90160758786897L);
            return paths;
        }
        HashSet set = new HashSet();
        paths.forEach(protectLocationPath -> set.add(protectLocationPath.getProtectedStorageSN()));
        for (StorageResource resource : resources) {
            if (set.contains(resource.getDevSn())) continue;
            ProtectLocationPath path = new ProtectLocationPath();
            Site site = this.getSiteFromSn(resource.getDevSn());
            path.setProtectedSiteId(site.getSiteId());
            path.setProtectedSiteName(site.getName());
            path.setRecoverySiteId(site.getSiteId());
            path.setRecoverySiteName(site.getName());
            path.setProtectedStorageSN(resource.getDevSn());
            path.setRecoveryStorageSN(resource.getDevSn());
            path.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue());
            paths.add(path);
        }
        return paths;
    }
}

