/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class ArraySnapshotFilter
extends AbstractPolicyTemplateFilter {
    private static final Log logger = LogFactory.getInstance(ArraySyncReplicationFilter.class);

    public boolean isMatch(List<ProtectObject> protectObjects) {
        this.checkSameSrcDevice(protectObjects);
        List allStorageInfo = this.getAllStorageInfo(protectObjects);
        ArrayList<String> allLunIds = new ArrayList<String>();
        String deviceSN = "";
        StringBuilder builder = new StringBuilder();
        for (ProtectObjectStorageInfo posi : allStorageInfo) {
            if (!allLunIds.contains(posi.getResourceId().toLowerCase(Locale.getDefault()))) {
                allLunIds.add(posi.getResourceId().toLowerCase(Locale.getDefault()));
                builder.append(posi.getResourceId()).append(" ");
            }
            deviceSN = posi.getResourceProviderSN();
        }
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (!VerifyUtil.isEmpty((Object)drResource) && drResource.getIsAirGapResource().booleanValue()) {
            logger.error((Object)"It is Air Gap resource, can not match.");
            throw new LegoCheckedException(1073948191L);
        }
        List lunList = new ArrayList();
        try {
            lunList = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryLunByDevSnAndLunIds(deviceSN, allLunIds);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("query lun error: " + deviceSN + "," + builder.toString()), (long)1073948705L, (String[])new String[0], (Log)logger);
        }
        if (allLunIds.size() != lunList.size()) {
            logger.warn((Object)"ArraySnapshotFilter is not match.", 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        Site siteFromDevice = this.getSiteByDeviceSN(deviceSN);
        if (VerifyUtil.isEmpty((Object)siteFromDevice)) {
            logger.warn((Object)("can't get site by deviceSN:" + deviceSN), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        return true;
    }

    public int getType() {
        return 2;
    }

    protected Site getSiteByDeviceSN(String deviceSN) {
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            return this.getSiteService().getSiteById(drResource.getSiteId());
        }
        return null;
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects) || VerifyUtil.isEmpty((Collection)protectObjects.iterator().next().getUsedStorageResourceSet())) {
            logger.error((Object)"protectObjects is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<ProtectLocationPath> results = new ArrayList<ProtectLocationPath>();
        ProtectObjectStorageInfo info = (ProtectObjectStorageInfo)protectObjects.iterator().next().getUsedStorageResourceSet().iterator().next();
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{info.getLunWWN()});
        if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 1) {
            logger.error((Object)("resources is empty or the size is not two!" + info.getLunWWN()), 90160758786897L);
            return null;
        }
        for (StorageResource res : resources) {
            ProtectLocationPath path = new ProtectLocationPath();
            Site site = this.getSiteFromSn(res.getDevSn());
            path.setProtectedSiteId(site.getSiteId());
            path.setProtectedSiteName(site.getName());
            path.setRecoverySiteId(site.getSiteId());
            path.setRecoverySiteName(site.getName());
            path.setProtectedStorageSN(res.getDevSn());
            path.setRecoveryStorageSN(res.getDevSn());
            path.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue());
            results.add(path);
        }
        return results;
    }
}

