/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class ArraySyncAsyncConcurrent3DCFilter
extends ArraySyncReplicationFilter {
    protected static final String SYNC_ASYNC_SKETCH = "policy_template_6_concurrent_sa.png";
    private static final Log logger = LogFactory.getInstance(ArraySyncAsyncConcurrent3DCFilter.class);

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        boolean is3DCSite;
        boolean isTwoTgt;
        logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        String arraySn = this.checkSameSrcDevice(protectObjects);
        Site site = this.getSiteFromSn(arraySn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.warn((Object)("can't get site by deviceSN:" + arraySn), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        this.getFilterContext().clear();
        boolean isMatchAB = this.isMatchByLocation(1, DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), protectObjects, this.getType());
        if (!isMatchAB) {
            logger.warn((Object)"Concurrent3DC is not MatchAB", 90160758787071L);
        }
        boolean bl = isTwoTgt = !VerifyUtil.isEmpty(this.getFilterContext().get("CONCURRENT_3DC")) && (Boolean)this.getFilterContext().get("CONCURRENT_3DC") != false;
        if (!isTwoTgt) {
            logger.warn((Object)"Concurrent3DC is not isTwoTgt", 90160758787071L);
            throw new LegoCheckedException(1073948191L);
        }
        Object siteA = this.getFilterContext().get("SITE_A_3DC");
        Object siteB = this.getFilterContext().get("SITE_B_3DC");
        Object siteC = this.getFilterContext().get("SITE_C_3DC");
        if (VerifyUtil.isEmpty(siteA) || VerifyUtil.isEmpty(siteB) || VerifyUtil.isEmpty(siteC)) {
            logger.warn((Object)("Concurrent3DC isMatch site is null:" + siteA + "-" + siteB + "-" + siteC), 90160758787071L);
            throw new LegoCheckedException(1073948211L);
        }
        boolean bl2 = is3DCSite = !String.valueOf(siteA).equals(String.valueOf(siteB)) && !String.valueOf(siteB).equals(String.valueOf(siteC)) && !String.valueOf(siteA).equals(String.valueOf(siteC));
        if (!is3DCSite) {
            logger.warn((Object)("Concurrent3DC isMatch site is same:" + siteA + "-" + siteB + "-" + siteC), 90160758787071L);
            throw new LegoCheckedException(1073948211L);
        }
        logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        return isMatchAB;
    }

    @Override
    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        this.isMatch(protectObjects);
        String siteA = (String)this.getFilterContext().get("SITE_A_3DC");
        String siteB = (String)this.getFilterContext().get("SITE_B_3DC");
        String siteC = (String)this.getFilterContext().get("SITE_C_3DC");
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        path.add(this.constructSitePath(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), siteA, siteB));
        path.add(this.constructSitePath(DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue(), siteA, siteC));
        return path;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    protected void saveProSite(int type, String proSite) {
        if (DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue() == type) {
            this.getFilterContext().put("SITE_A_3DC", proSite);
        } else if (DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue() == type) {
            this.getFilterContext().put("SITE_B_3DC", proSite);
        }
    }
}

