/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FusionStorageAsyncReplicationFilter
extends AbstractPolicyTemplateFilter {
    private static Log logger = LogFactory.getInstance(FusionStorageAsyncReplicationFilter.class);

    public boolean isMatch(List<ProtectObject> protectObjects) {
        logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        String arraySn = this.checkSameSrcDevice(protectObjects);
        Site site = this.getSiteFromSn(arraySn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.warn((Object)("can't get site by deviceSN:" + arraySn), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        CreateProtectGroupRefineService instanceService = CreateProtectGroupRefineService.getInstance();
        MessageEvent event = new MessageEvent();
        event.setMessageType(0);
        ProtectGroup protectGroup = new ProtectGroup();
        PolicyTemplate template = new PolicyTemplate();
        template.setType(this.getType());
        protectGroup.setTemplate(template);
        protectGroup.getPolist().addAll(protectObjects);
        Map props = protectGroup.getProps();
        props.put("PROP_IS_TEMPLATE_FILTER_PG", "true");
        protectGroup.setProps(props);
        protectGroup.setPrimary(true);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(protectGroup);
        event.setObjectList(objectList);
        instanceService.notifyObserverList(event, "before");
        return true;
    }

    public int getType() {
        return 33;
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            logger.error((Object)"protectObjects is empty.");
            return Collections.emptyList();
        }
        ProtectObject po = protectObjects.iterator().next();
        ProtectGroupReplica replica = po.getProtectGroup().getAnyoneReplicationReplica();
        String productSite = this.getSiteByArraySn(replica.getProductArray());
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        path.add(this.constructSitePath(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), replica.getProductArray(), productSite, replica.getRecoveryArray(), replica.getRecoverySite()));
        return path;
    }
}

