/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class NasSnapshotFilter
extends AbstractPolicyTemplateFilter {
    private static final Log logger = LogFactory.getInstance(ArraySyncReplicationFilter.class);

    public boolean isMatch(List<ProtectObject> protectObjects) {
        this.checkSameSrcDevice(protectObjects);
        List allStorageInfo = this.getAllStorageInfo(protectObjects);
        ArrayList<String> allNasIds = new ArrayList<String>();
        String deviceSN = "";
        StringBuilder builder = new StringBuilder();
        for (ProtectObjectStorageInfo posi : allStorageInfo) {
            if (!allNasIds.contains(posi.getResourceId().toLowerCase(Locale.getDefault()))) {
                allNasIds.add(posi.getResourceId().toLowerCase(Locale.getDefault()));
                builder.append(posi.getResourceId()).append(" ");
            }
            deviceSN = posi.getResourceProviderSN();
        }
        List nasFileSystems = new ArrayList();
        try {
            IStorageFileSystemManager fileSystemManagerProxy = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(deviceSN);
            nasFileSystems = fileSystemManagerProxy.queryFileSystems(deviceSN, allNasIds, this.getVstoreId(protectObjects));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("query Nas error: " + deviceSN + builder.toString()), (long)1073948705L, (String[])new String[0], (Log)logger);
        }
        if (allNasIds.size() != nasFileSystems.size()) {
            logger.warn((Object)"NasSnapshotFilter is not match.", 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        Site siteFromDevice = this.getSiteByDeviceSN(deviceSN);
        if (VerifyUtil.isEmpty((Object)siteFromDevice)) {
            logger.warn((Object)("can't get site by deviceSN:" + deviceSN), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        return true;
    }

    private String getVstoreId(List<ProtectObject> protectObjects) {
        ProtectObject protectObject;
        String vStoreId = null;
        if (null != protectObjects && !protectObjects.isEmpty() && null != (protectObject = protectObjects.get(0)) && null != protectObject.getUsedStorageResourceSet() && !protectObject.getUsedStorageResourceSet().isEmpty()) {
            ProtectObjectStorageInfo protectObjectStorageInfo = (ProtectObjectStorageInfo)protectObject.getUsedStorageResourceSet().iterator().next();
            vStoreId = null != protectObjectStorageInfo ? protectObjectStorageInfo.getVstoreId() : null;
        }
        return vStoreId;
    }

    public int getType() {
        return 14;
    }

    protected Site getSiteByDeviceSN(String deviceSN) {
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            return this.getSiteService().getSiteById(drResource.getSiteId());
        }
        return null;
    }
}

