/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.airgap.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.airgap.process.NasAirGapRollbackProcessor;
import com.huawei.ism.drm.storage.recovery.process.SynchronizeReplicationProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class IncrementalSynchronousReplicationProcessor
extends SynchronizeReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(NasAirGapRollbackProcessor.class);
    private static final long serialVersionUID = -1526723542608151767L;
    private static final String ENABLE_DATA_REPLICATION = "com.huawei.ism.drm.storage.recovery.airgap.process.IncrementalSynchronousReplicationProcessor.enable";
    private static final String SKIP_DATA_REPLICATION = "com.huawei.ism.drm.storage.recovery.airgap.process.IncrementalSynchronousReplicationProcessor.skip";

    @Override
    public boolean execute(RecoveryProcessorContext context) {
        if (context.getProtectGroup().getTemplate().getType() != 45) {
            return true;
        }
        if (this.checkIfNecessary(context)) {
            LOGGER.info((Object)"Start incremental replication of protection group(name: %s)", new Object[]{context.getProtectGroup().getName()});
            this.updateProcessDetail(ENABLE_DATA_REPLICATION, new String[0]);
            return super.execute(context);
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        this.updateProcessDetail(SKIP_DATA_REPLICATION, new String[0]);
        return true;
    }

    private boolean checkIfNecessary(RecoveryProcessorContext context) {
        ProtectGroupReplica protectGroupReplica = context.getProtectGroupReplica();
        ProtectGroup protectGroup = context.getProtectGroup();
        if (protectGroupReplica.getReplicas().size() == protectGroup.getPolist().size()) {
            return false;
        }
        this.filterIncrementalReplicationTask(context);
        return true;
    }

    private void filterIncrementalReplicationTask(RecoveryProcessorContext context) {
        Set protectObjectReplicas = context.getProtectGroupReplica().getReplicas();
        Set moUuidsInPgReplica = protectObjectReplicas.stream().map(ProtectObjectReplica::getProtectObject).map(ProtectObject::getMoUuid).collect(Collectors.toSet());
        List resourceIds = context.getProtectGroup().getPolist().stream().filter(protectObject -> !moUuidsInPgReplica.contains(protectObject.getMoUuid())).map(ProtectObject::getProps).map(map -> (String)map.get("nasFsId")).collect(Collectors.toList());
        String devSn = context.getProtectGroup().getPoProviderSN();
        List pairs = ((DrmStorageServiceImpl)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class)).getReplicationPairsByResourceIds(devSn, resourceIds, false, Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()));
        if (VerifyUtil.isEmpty((Collection)pairs)) {
            LOGGER.error((Object)"Can't query replication pairs of newly added protectObject(ids: %s).", new Object[]{resourceIds});
            throw new LegoCheckedException(1073947394L);
        }
        Set pairIds = pairs.stream().map(ReplicationRelation::getReplicationId).collect(Collectors.toSet());
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        recoveryPlan.getGlobalSettings().put("creteRecoveryTaskByReplicationPairOnly", String.valueOf(Boolean.TRUE));
        Collection recoveryTasks = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler().getRecoveryTasks(recoveryPlan);
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            LOGGER.error((Object)"Construct recovery task failed.");
            throw new LegoCheckedException(1073947394L);
        }
        List incrementalReplicationTask = recoveryTasks.stream().filter(recoveryTask -> pairIds.contains(recoveryTask.getProtectId())).collect(Collectors.toList());
        context.setAttribute("incrementalReplicationTask", incrementalReplicationTask);
    }

    @Override
    public String getRecoveryTasksKey() {
        return "incrementalReplicationTask";
    }
}

