/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.airgap.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.airgap.process.NasHyperVaultRefactorStorageRelationProcessor;
import com.huawei.ism.drm.storage.recovery.base.BaseHyperVaultRollbackProcessor;
import com.huawei.ism.drm.storage.recovery.process.RollbackNasSnapshotProcessor;
import com.huawei.ism.drm.storage.recovery.process.SwapReplicationProcessor;
import com.huawei.ism.drm.storage.recovery.process.SynchronizeReplicationProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class NasAirGapRollbackProcessor
extends BaseHyperVaultRollbackProcessor {
    private static final long serialVersionUID = -4390191372900215814L;
    private static final Log LOGGER = LogFactory.getInstance(NasAirGapRollbackProcessor.class);

    @Override
    public boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Execute Nas AirGap hyper vault snapshot rollback.");
        return super.execute(context);
    }

    @Override
    protected Collection<RecoveryTask> getRemoteRecoveryTasks(RecoveryProcessorContext context) {
        Collection<RecoveryTask> recoveryTasks = super.getRemoteRecoveryTasks(context);
        ProtectGroup protectGroup = context.getProtectGroup();
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOGGER.error((Object)"Protect group does not Exist!");
            throw new LegoCheckedException(1073947394L);
        }
        String vStorePairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_REPLICATION_PAIR_ID");
        if (!VerifyUtil.isEmpty((String)vStorePairId) && !VerifyUtil.isEmpty(recoveryTasks)) {
            String tgtDeviceId;
            String srcDeviceId = recoveryTasks.stream().findFirst().map(RecoveryTask::getSrcDeviceId).orElse("");
            VstoreReplicationPair vstoreReplicationPair = this.getVstoreReplicationPair(srcDeviceId, tgtDeviceId = recoveryTasks.stream().findFirst().map(RecoveryTask::getTgtDevcieId).orElse(""), vStorePairId);
            if (VerifyUtil.isEmpty((Object)vstoreReplicationPair)) {
                LOGGER.error((Object)"Unable to get remote replication Vstore information according to the pairId{%s}!", new Object[]{vStorePairId});
                throw new LegoCheckedException(1073947394L);
            }
            for (RecoveryTask recoveryTask : recoveryTasks) {
                String replicationPairId = recoveryTask.getProtectId();
                if (vStorePairId.equals(replicationPairId) || vStorePairId.equals(this.getVstorePairId(srcDeviceId, tgtDeviceId, replicationPairId))) continue;
                LOGGER.error((Object)"The vStore pair Id of the replication pair{%s} is not same with {%s} , or does not exist! ", new Object[]{replicationPairId, vStorePairId});
                throw new LegoCheckedException(1073948476L);
            }
            RecoveryTask recoveryTask = recoveryTasks.stream().findFirst().get();
            recoveryTask.setProtectType(ReplicationConstantDefine.ReplicationDescription.VSTORE_PAIR.getValue());
            recoveryTask.setProtectId(vStorePairId);
            ArrayList<RecoveryTask> resultList = new ArrayList<RecoveryTask>();
            resultList.add(recoveryTask);
            return resultList;
        }
        return recoveryTasks;
    }

    public String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected void setSubProcessors(ProtectGroupReplica replica) {
        this.setRemoteSubProcessors();
    }

    @Override
    protected void setSplitSubProcessor(Set<RecoveryProcessor> subProcessors, boolean onlySplit, boolean revertRep) {
        SwapReplicationProcessor swapReplicationProcessor = new SwapReplicationProcessor();
        swapReplicationProcessor.setProcType(this.getProcType());
        swapReplicationProcessor.setParentProc((RecoveryProcessor)this);
        swapReplicationProcessor.setRecoveryTasksKey("remoteRecoveryTasks");
        subProcessors.add((RecoveryProcessor)swapReplicationProcessor);
    }

    @Override
    protected void setSyncSubProcessor(Set<RecoveryProcessor> subProcessors) {
        SynchronizeReplicationProcessor synchronizeReplicationProcessor = new SynchronizeReplicationProcessor();
        synchronizeReplicationProcessor.setParentProc((RecoveryProcessor)this);
        synchronizeReplicationProcessor.setPlanId(this.getPlanId());
        synchronizeReplicationProcessor.setProcType(this.getProcType());
        synchronizeReplicationProcessor.setRecoveryTasksKey("remoteRecoveryTasks");
        subProcessors.add((RecoveryProcessor)synchronizeReplicationProcessor);
    }

    @Override
    protected void setRefactorSubProcessor(Set<RecoveryProcessor> subProcessors, boolean revertRep) {
        NasHyperVaultRefactorStorageRelationProcessor refactorStorageRelationProcessor = new NasHyperVaultRefactorStorageRelationProcessor(revertRep);
        refactorStorageRelationProcessor.setParentProc((RecoveryProcessor)this);
        subProcessors.add((RecoveryProcessor)refactorStorageRelationProcessor);
    }

    @Override
    protected void setRollbackSubProcessor(Set<RecoveryProcessor> subProcessors) {
        RollbackNasSnapshotProcessor rollbackNasSnapshotProcessor = new RollbackNasSnapshotProcessor();
        rollbackNasSnapshotProcessor.setParentProc((RecoveryProcessor)this);
        rollbackNasSnapshotProcessor.setProcType(this.getProcType());
        rollbackNasSnapshotProcessor.setIsNeedSave(false);
        subProcessors.add((RecoveryProcessor)rollbackNasSnapshotProcessor);
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    private VstoreReplicationPair getVstoreReplicationPair(String srcDeviceId, String tgtDeviceId, String replicationId) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        return recoveryService.queryVstoreReplicationPair(srcDeviceId, tgtDeviceId, replicationId);
    }

    private String getVstorePairId(String srcDeviceId, String tgtDeviceId, String replicationPairId) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        ReplicationRelation replicationRelation = recoveryService.queryReplication(srcDeviceId, tgtDeviceId, replicationPairId, false);
        if (replicationRelation instanceof ReplicationPair) {
            ReplicationPair replicationPair = (ReplicationPair)replicationRelation;
            return replicationPair.getVstorePairId();
        }
        return "";
    }
}

