/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.base;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorReplicationSubProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class BaseHyperVaultRefactorReplicationSubProcessor
extends RefactorReplicationSubProcessor {
    private static final long serialVersionUID = -6058292910463829818L;
    private static final Log LOGGER = LogFactory.getInstance(BaseHyperVaultRefactorReplicationSubProcessor.class);
    private final boolean revertRep;

    public BaseHyperVaultRefactorReplicationSubProcessor(RecoveryProcessor parentProcess, boolean revertRep) {
        super(parentProcess);
        this.setIsNeedSave(false);
        this.revertRep = revertRep;
    }

    protected String getRecoveryArrayByPg(ProtectGroup pg, String disasterSiteId) {
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica)) continue;
            if (this.revertRep) {
                return replica.getProductArray();
            }
            if (VerifyUtil.isEmpty((String)replica.getRecoverySite()) || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            return replica.getRecoveryArray();
        }
        return null;
    }

    protected String getRecoveryArrayByLocation(ProtectGroup protectGroup, int location) {
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica) || replica.getProtectLocation() != location) continue;
            if (this.revertRep) {
                return replica.getProductArray();
            }
            return replica.getRecoveryArray();
        }
        return "";
    }

    protected String getDisasterSiteId(RecoveryProcessorContext context) {
        if (this.revertRep) {
            ProtectGroup pg = context.getProtectGroup();
            if (!VerifyUtil.isEmpty((Object)pg)) {
                return pg.getProductSiteId();
            }
            return null;
        }
        return super.getDisasterSiteId(context);
    }

    protected List<RemoteStorageReplica> getRemoteReplicas(RecoveryProcessorContext context, ProtectGroup protectGroup, String disasterSiteId) {
        List remoteReplicas = this.revertRep ? super.getRemoteReplicas(context, protectGroup, context.getDisasterSiteId()) : super.getRemoteReplicas(context, protectGroup, disasterSiteId);
        if (this.revertRep) {
            try {
                return this.revertRemoteReplicas(remoteReplicas);
            }
            catch (CloneNotSupportedException e) {
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
        }
        return remoteReplicas;
    }

    private List<RemoteStorageReplica> revertRemoteReplicas(List<RemoteStorageReplica> remoteReplicas) throws CloneNotSupportedException {
        if (VerifyUtil.isEmpty(remoteReplicas)) {
            return new ArrayList<RemoteStorageReplica>();
        }
        ArrayList<RemoteStorageReplica> list = new ArrayList<RemoteStorageReplica>();
        for (RemoteStorageReplica remoteStorageReplica : remoteReplicas) {
            Object clone = remoteStorageReplica.clone();
            if (!(clone instanceof RemoteStorageReplica)) {
                LOGGER.error((Object)"Clone remote Storage Replica error! Replication pair id is %s", new Object[]{remoteStorageReplica.getReplicationPairId()});
                throw new LegoCheckedException(1073947393L);
            }
            RemoteStorageReplica newRemoteStorageReplica = (RemoteStorageReplica)clone;
            String srcStorageProviderSN = newRemoteStorageReplica.getSrcStorageProviderSN();
            String srcStorageId = newRemoteStorageReplica.getSrcStorageId();
            newRemoteStorageReplica.setSrcStorageProviderSN(newRemoteStorageReplica.getStorageProviderSN());
            newRemoteStorageReplica.setSrcStorageId(newRemoteStorageReplica.getStorageId());
            newRemoteStorageReplica.setStorageProviderSN(srcStorageProviderSN);
            newRemoteStorageReplica.setStorageId(srcStorageId);
            list.add(newRemoteStorageReplica);
        }
        return list;
    }
}

