/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.base;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorStorageRelationProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseHyperVaultRefactorStorageRelationProcessor
extends RefactorStorageRelationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(BaseHyperVaultRefactorStorageRelationProcessor.class);
    private static final long serialVersionUID = -3765999739645467197L;
    private final boolean revertRep;

    public BaseHyperVaultRefactorStorageRelationProcessor() {
        this.revertRep = false;
    }

    public BaseHyperVaultRefactorStorageRelationProcessor(boolean revertRep) {
        this.setIsNeedSave(false);
        this.revertRep = revertRep;
    }

    protected boolean isRevertRep() {
        return this.revertRep;
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.refreshStorage(context);
        return super.execute(context);
    }

    public String getName() {
        return RefactorStorageRelationProcessor.class.getName();
    }

    protected List<String> getLunIds(ProtectGroup pg, String disasterSiteId, Map<String, Integer> resourceTypeMap) {
        ArrayList<String> lunIds = new ArrayList<String>();
        ProtectGroupReplica pgReplica = null;
        String recoveryArray = "";
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica) || VerifyUtil.isEmpty((String)replica.getRecoverySite()) || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            pgReplica = replica;
            recoveryArray = pgReplica.getRecoveryArray();
            break;
        }
        if (VerifyUtil.isEmpty(pgReplica)) {
            return lunIds;
        }
        for (ProtectGroupReplica replica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : replica.getStorageInfos()) {
                if (!recoveryArray.equals(storageInfo.getStorageProviderSN())) continue;
                int localResType = 11;
                String wwn = storageInfo.getProtectObjectStorageWwn();
                if (VerifyUtil.isEmpty((String)wwn) || wwn.contains("/")) {
                    localResType = 40;
                }
                if (this.revertRep) {
                    lunIds.add(storageInfo.getSrcStorageId());
                    resourceTypeMap.put(storageInfo.getSrcStorageId(), localResType);
                    continue;
                }
                lunIds.add(storageInfo.getStorageId());
                resourceTypeMap.put(storageInfo.getStorageId(), localResType);
            }
        }
        return lunIds;
    }

    protected boolean isStorageRelationReversed(ProtectGroup pg, String disasterSiteId) {
        if (this.revertRep) {
            HashMap<String, Integer> resourceMap = new HashMap<String, Integer>();
            List<String> storageResourceIds = this.getLunIds(pg, disasterSiteId, resourceMap);
            LOGGER.info((Object)"Storage resource ids. PgName: %s, Ids: %s", new Object[]{pg.getName(), storageResourceIds.toString()});
            String recoveryArray = this.getRecoveryArrayByPg(pg, disasterSiteId);
            String productArray = this.getProductArrayByPg(pg, disasterSiteId);
            int templateType = pg.getTemplate().getType();
            boolean reversedFlag = true;
            for (String lunId : storageResourceIds) {
                boolean isPrimary = true;
                if (templateType == 44 || templateType == 45) {
                    isPrimary = false;
                }
                ReplicationRelation replicationRelation = this.findReversedStorageRelation(recoveryArray, productArray, lunId, (Integer)resourceMap.get(lunId), isPrimary);
                String logMsg = "ProductSiteId:" + pg.getProductSiteId() + ",ProductArray:" + productArray + ",RecoverySiteId:" + disasterSiteId + ",RecoveryArray:" + recoveryArray + ",LunId:" + lunId;
                LOGGER.info((Object)("isStorageRelationReversed:" + logMsg));
                if (replicationRelation != null) continue;
                reversedFlag = false;
                break;
            }
            return reversedFlag;
        }
        return super.isStorageRelationReversed(pg, disasterSiteId);
    }
}

