/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.precheck;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.process.IRecoveryPreChecker;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class Array4DCRecoveryPreChecker
implements IRecoveryPreChecker {
    private static final Log LOGGER = LogFactory.getInstance(Array4DCRecoveryPreChecker.class);

    public void check(RecoveryPlan plan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION != execType) {
            return;
        }
        String disasterSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
        if (VerifyUtil.isEmpty((String)disasterSiteId)) {
            LOGGER.warn((Object)("disasterSiteId is null in recovery plan, planId=" + plan.getUuid()), 90160758787071L);
            return;
        }
        Set protectGroups = plan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            LOGGER.warn((Object)("there is no protectgroup in recovery plan, planId=" + plan.getUuid()), 90160758787071L);
            return;
        }
        for (ProtectGroup pg : protectGroups) {
            Set thirdSiteIdSet;
            List siteInfoList;
            String siteInfoListStr;
            PolicyTemplate policyTemplate = pg.getTemplate();
            if (VerifyUtil.isEmpty((Object)policyTemplate) || 35 != policyTemplate.getType() || null == (siteInfoListStr = (String)pg.getProps().get("PROP_KEY_SITE_INFO")) || ((SiteInfo)(siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).get(1)).getSiteIdSet().size() <= 1 || !(thirdSiteIdSet = ((SiteInfo)siteInfoList.get(2)).getSiteIdSet()).contains(disasterSiteId)) continue;
            LOGGER.error((Object)("not support planed motion for:" + disasterSiteId + " plan id:" + plan.getPlanId()));
            throw new LegoCheckedException(1073948806L);
        }
    }
}

