/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.ActiveSnapshotProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Objects;

public class ActiveSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 2438435784236635204L;
    private static final Log logger = LogFactory.getInstance(ActiveSnapshotSubProcessor.class);
    private List<String> snapshotIds;
    private String deviceId;
    private String pgId;
    private String pgName;

    public ActiveSnapshotSubProcessor() {
        this.setIsNeedSave(false);
    }

    public List<String> getSnapshotIds() {
        return this.snapshotIds;
    }

    public void setSnapshotIds(List<String> snapshotIds) {
        this.snapshotIds = snapshotIds;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getPgId() {
        return this.pgId;
    }

    public void setPgId(String pgId) {
        this.pgId = pgId;
    }

    public String getPgName() {
        return this.pgName;
    }

    public void setPgName(String pgName) {
        this.pgName = pgName;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupByID(this.pgId, false);
        if (null == pg) {
            this.updateProcessNameParams(new String[]{this.pgId});
            String[] errorParams = new String[]{this.pgId};
            this.updateProcessDetail("ism.drm.recovery.protectgroup.not.exist", errorParams);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return true;
        }
        this.setPgName(pg.getName());
        this.updateProcessNameParams(new String[]{this.getDeviceId()});
        if (VerifyUtil.isEmpty(this.snapshotIds) || this.snapshotIds.contains("")) {
            this.updateProcessDetail("ism.drm.recovery.snapshot.create.failed", new String[0]);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return true;
        }
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        long startTime = System.currentTimeMillis();
        OperationResult operationResult = proxy.activeSnapshotAfterStop(this.deviceId, this.snapshotIds);
        logger.debug((Object)("activeSnapshotAfterStop cost time:" + (System.currentTimeMillis() - startTime)));
        if (null != operationResult && !operationResult.isSuccess()) {
            this.updateProcessDetail("lego.err." + operationResult.getErrorCode(), operationResult.getArgs());
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        } else if (null != operationResult) {
            this.updateSnapshotWwn(operationResult.getArgs());
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        }
        return true;
    }

    private void updateSnapshotWwn(String[] wwns) {
        if (wwns == null || wwns.length == 0) {
            return;
        }
        RecoveryProcessor parent = this.getParentProc();
        if (!ActiveSnapshotProcessor.class.isInstance(parent)) {
            return;
        }
        ActiveSnapshotProcessor activeSnapshotProcessor = (ActiveSnapshotProcessor)parent;
        activeSnapshotProcessor.getCreateSnapshotSubProcessors().stream().filter(CreateSnapshotSubProcessor.class::isInstance).map(CreateSnapshotSubProcessor.class::cast).forEach(processor -> this.updateSnapshotWwn((CreateSnapshotSubProcessor)processor, wwns));
    }

    private void updateSnapshotWwn(CreateSnapshotSubProcessor processor, String[] wwns) {
        String wwn = this.getSnapshotWwn(wwns, processor);
        if (wwn != null) {
            processor.setSnapshotWWN(wwn);
        }
    }

    private String getSnapshotWwn(String[] wwns, CreateSnapshotSubProcessor processor) {
        for (String wwn : wwns) {
            int index = wwn.indexOf(">");
            if (index == -1 || !Objects.equals(processor.getSnapshotWWN(), wwn.substring(0, index))) continue;
            return wwn.substring(index + 1);
        }
        return null;
    }

    protected String generateResultKey() {
        return RecoveryProcessResult.getActiveSnapshotProcResultKey((String)this.deviceId, (String)this.pgId);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

