/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.backup.BackupManagerProxy;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.BackupTask;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CheckRollbackBackupSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -8882528752975196418L;
    private static final Log logger = LogFactory.getInstance(CheckRollbackBackupSubProcessor.class);
    private static final String KEY_RESTORE_PROGRESS = "ism.drm.recovery.backup.restore.process";
    private static final long SLEEP_TIME = 2000L;
    private static final int TRY_TIME = 3;
    private static final int TRY_SLEEP_TIME = 10;
    private static final long EXEC_TIMEOUT = 1077949001L;
    private String deviceId;
    private String requestId;
    private String imageId;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        BackupTask backupTask = null;
        int retryTime = 0;
        do {
            try {
                backupTask = this.getBackupTask(this.requestId);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 1077949001L) {
                    logger.error((Object)("Query backup task timeout, requestId:" + this.requestId));
                    if (++retryTime >= 3) {
                        logger.error((Object)("Have retrying 3 times to query backup task, requestId:" + this.requestId));
                        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                        this.updateProcessDetail(e.getErrorMessageKey(), null);
                        return false;
                    }
                    CommUtil.pauseThread((long)10L);
                    continue;
                }
                logger.error((Object)("get backup task got error:" + e.getErrorCode() + ", requestId:" + this.requestId));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail(e.getErrorMessageKey(), null);
                return false;
            }
            if (VerifyUtil.isEmpty((Object)backupTask)) {
                logger.error((Object)("get backup task got error, requestId:" + this.requestId));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073947394", null);
                return false;
            }
            if (backupTask.isFinished()) {
                CommUtil.pauseThread((long)2000L);
                logger.info((Object)("backup(" + backupTask.getAssociateImageID() + ")'s rollback process is :" + backupTask.getProgress() + ", Status:" + backupTask.getStatus().toString()));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                this.updateProcessDetail(KEY_RESTORE_PROGRESS, new String[]{String.valueOf(backupTask.getProgress())});
                return true;
            }
            if (!(BackupTask.STATUS.IN_PROGRESS.equals((Object)backupTask.getStatus()) || BackupTask.STATUS.COMPLETED.equals((Object)backupTask.getStatus()) || BackupTask.STATUS.PENDING.equals((Object)backupTask.getStatus()))) {
                logger.error((Object)("backup(" + backupTask.getAssociateImageID() + ")'s rollback process is :" + backupTask.getProgress() + ", Status:" + backupTask.getStatus().toString()));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                return false;
            }
            this.updateProcessDetail(KEY_RESTORE_PROGRESS, new String[]{String.valueOf(backupTask.getProgress())});
            CommUtil.pauseThread((long)2000L);
        } while (backupTask != null);
        logger.error((Object)("query backuptask got error. requestId:" + this.requestId));
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        return false;
    }

    private BackupTask getBackupTask(String requestID) {
        IBackupManager iBackupManager = BackupManagerProxy.getInstance().getBackupService("NativeBackupEngine");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requestID", requestID);
        List backupTasks = iBackupManager.queryTask(this.deviceId, params);
        return (BackupTask)CommonUtil.getFirstElement((Collection)backupTasks);
    }
}

